/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.dto.marketdata;

import java.util.concurrent.TimeUnit;

public enum KlineInterval {
    m1("1m", TimeUnit.MINUTES.toMillis(1L)),
    m3("3m", TimeUnit.MINUTES.toMillis(3L)),
    m5("5m", TimeUnit.MINUTES.toMillis(5L)),
    m15("15m", TimeUnit.MINUTES.toMillis(15L)),
    m30("30m", TimeUnit.MINUTES.toMillis(30L)),
    h1("1h", TimeUnit.HOURS.toMillis(1L)),
    h2("2h", TimeUnit.HOURS.toMillis(2L)),
    h4("4h", TimeUnit.HOURS.toMillis(4L)),
    h6("6h", TimeUnit.HOURS.toMillis(6L)),
    h8("8h", TimeUnit.HOURS.toMillis(8L)),
    h12("12h", TimeUnit.HOURS.toMillis(12L)),
    d1("1d", TimeUnit.DAYS.toMillis(1L)),
    d3("3d", TimeUnit.DAYS.toMillis(3L)),
    w1("1w", TimeUnit.DAYS.toMillis(7L)),
    M1("1M", TimeUnit.DAYS.toMillis(30L));

    private final String code;
    private final Long millis;

    private KlineInterval(String code, Long millis) {
        this.millis = millis;
        this.code = code;
    }

    public Long getMillis() {
        return this.millis;
    }

    public String code() {
        return this.code;
    }

    public static KlineInterval getPeriodTypeFromSecs(long periodInSecs) {
        KlineInterval result = null;
        for (KlineInterval period : KlineInterval.values()) {
            if (period.millis != periodInSecs * 1000L) continue;
            result = period;
            break;
        }
        return result;
    }
}

