/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.binance.BinanceAuthenticated;
import org.knowm.xchange.binance.BinanceExchange;
import org.knowm.xchange.binance.dto.BinanceException;
import org.knowm.xchange.binance.dto.account.AssetDetail;
import org.knowm.xchange.binance.dto.account.AssetDividendResponse;
import org.knowm.xchange.binance.dto.account.BinanceAccountInformation;
import org.knowm.xchange.binance.dto.account.BinanceDeposit;
import org.knowm.xchange.binance.dto.account.BinanceWithdraw;
import org.knowm.xchange.binance.dto.account.DepositAddress;
import org.knowm.xchange.binance.dto.account.TransferHistory;
import org.knowm.xchange.binance.dto.account.TransferSubUserHistory;
import org.knowm.xchange.binance.dto.account.WithdrawResponse;
import org.knowm.xchange.binance.service.BinanceBaseService;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.Currency;

public class BinanceAccountServiceRaw
extends BinanceBaseService {
    public BinanceAccountServiceRaw(BinanceExchange exchange, BinanceAuthenticated binance, ResilienceRegistries resilienceRegistries) {
        super(exchange, binance, resilienceRegistries);
    }

    public BinanceAccountInformation account() throws BinanceException, IOException {
        return this.decorateApiCall(() -> this.binance.account(this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("account")).withRateLimiter(this.rateLimiter("requestWeight"), 5).call();
    }

    public WithdrawResponse withdraw(String coin, String address, BigDecimal amount) throws IOException, BinanceException {
        String name = address.length() <= 10 ? address : address.substring(0, 10);
        return this.withdraw(coin, address, null, amount, name);
    }

    public WithdrawResponse withdraw(String coin, String address, String addressTag, BigDecimal amount) throws IOException, BinanceException {
        String name = address.length() <= 10 ? address : address.substring(0, 10);
        return this.withdraw(coin, address, addressTag, amount, name);
    }

    private WithdrawResponse withdraw(String coin, String address, String addressTag, BigDecimal amount, String name) throws IOException, BinanceException {
        return this.decorateApiCall(() -> this.binance.withdraw(coin, address, addressTag, amount, name, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("withdraw", "nonIdempotentCallsBase")).withRateLimiter(this.rateLimiter("requestWeight"), 5).call();
    }

    public DepositAddress requestDepositAddress(Currency currency) throws IOException {
        return this.decorateApiCall(() -> this.binance.depositAddress(BinanceAdapters.toSymbol(currency), this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("depositAddress")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public Map<String, AssetDetail> requestAssetDetail() throws IOException {
        return this.decorateApiCall(() -> this.binance.assetDetail(this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("assetDetail")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public List<BinanceDeposit> depositHistory(String asset, Long startTime, Long endTime) throws BinanceException, IOException {
        return this.decorateApiCall(() -> this.binance.depositHistory(asset, startTime, endTime, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("depositHistory")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public List<BinanceWithdraw> withdrawHistory(String asset, Long startTime, Long endTime) throws BinanceException, IOException {
        return this.decorateApiCall(() -> this.binance.withdrawHistory(asset, startTime, endTime, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("withdrawHistory")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public List<AssetDividendResponse.AssetDividend> getAssetDividend(Long startTime, Long endTime) throws BinanceException, IOException {
        return this.getAssetDividend("", startTime, endTime);
    }

    public List<AssetDividendResponse.AssetDividend> getAssetDividend(String asset, Long startTime, Long endTime) throws BinanceException, IOException {
        return this.decorateApiCall(() -> this.binance.assetDividend(asset, startTime, endTime, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("assetDividend")).withRateLimiter(this.rateLimiter("requestWeight")).call().getData();
    }

    public List<TransferHistory> getTransferHistory(String fromEmail, Long startTime, Long endTime, Integer page, Integer limit) throws BinanceException, IOException {
        return this.decorateApiCall(() -> this.binance.transferHistory(fromEmail, startTime, endTime, page, limit, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("transferHistory")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public List<TransferSubUserHistory> getSubUserHistory(String asset, Integer type, Long startTime, Long endTime, Integer limit) throws BinanceException, IOException {
        return this.decorateApiCall(() -> this.binance.transferSubUserHistory(asset, type, startTime, endTime, limit, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("transferSubUserHistory")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }
}

