/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.service;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.binance.BinanceAuthenticated;
import org.knowm.xchange.binance.BinanceExchange;
import org.knowm.xchange.binance.dto.marketdata.BinanceAggTrades;
import org.knowm.xchange.binance.dto.marketdata.BinanceKline;
import org.knowm.xchange.binance.dto.marketdata.BinanceOrderbook;
import org.knowm.xchange.binance.dto.marketdata.BinancePrice;
import org.knowm.xchange.binance.dto.marketdata.BinancePriceQuantity;
import org.knowm.xchange.binance.dto.marketdata.BinanceTicker24h;
import org.knowm.xchange.binance.dto.marketdata.KlineInterval;
import org.knowm.xchange.binance.dto.meta.BinanceTime;
import org.knowm.xchange.binance.service.BinanceBaseService;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.utils.StreamUtils;

public class BinanceMarketDataServiceRaw
extends BinanceBaseService {
    protected BinanceMarketDataServiceRaw(BinanceExchange exchange, BinanceAuthenticated binance, ResilienceRegistries resilienceRegistries) {
        super(exchange, binance, resilienceRegistries);
    }

    public void ping() throws IOException {
        this.decorateApiCall(() -> this.binance.ping()).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public BinanceTime binanceTime() throws IOException {
        return this.decorateApiCall(() -> this.binance.time()).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public BinanceOrderbook getBinanceOrderbook(CurrencyPair pair, Integer limit) throws IOException {
        return this.decorateApiCall(() -> this.binance.depth(BinanceAdapters.toSymbol(pair), limit)).withRetry(this.retry("depth")).withRateLimiter(this.rateLimiter("requestWeight"), this.depthPermits(limit)).call();
    }

    public List<BinanceAggTrades> aggTrades(CurrencyPair pair, Long fromId, Long startTime, Long endTime, Integer limit) throws IOException {
        return this.decorateApiCall(() -> this.binance.aggTrades(BinanceAdapters.toSymbol(pair), fromId, startTime, endTime, limit)).withRetry(this.retry("aggTrades")).withRateLimiter(this.rateLimiter("requestWeight"), this.aggTradesPermits(limit)).call();
    }

    public BinanceKline lastKline(CurrencyPair pair, KlineInterval interval) throws IOException {
        return (BinanceKline)this.klines(pair, interval, 1, null, null).stream().collect(StreamUtils.singletonCollector());
    }

    public List<BinanceKline> klines(CurrencyPair pair, KlineInterval interval) throws IOException {
        return this.klines(pair, interval, null, null, null);
    }

    public List<BinanceKline> klines(CurrencyPair pair, KlineInterval interval, Integer limit, Long startTime, Long endTime) throws IOException {
        List raw = this.decorateApiCall(() -> this.binance.klines(BinanceAdapters.toSymbol(pair), interval.code(), limit, startTime, endTime)).withRetry(this.retry("klines")).withRateLimiter(this.rateLimiter("requestWeight")).call();
        return raw.stream().map(obj -> new BinanceKline(pair, interval, (Object[])obj)).collect(Collectors.toList());
    }

    public List<BinanceTicker24h> ticker24h() throws IOException {
        return this.decorateApiCall(() -> this.binance.ticker24h()).withRetry(this.retry("ticker24h")).withRateLimiter(this.rateLimiter("requestWeight"), 40).call();
    }

    public BinanceTicker24h ticker24h(CurrencyPair pair) throws IOException {
        BinanceTicker24h ticker24h = this.decorateApiCall(() -> this.binance.ticker24h(BinanceAdapters.toSymbol(pair))).withRetry(this.retry("ticker24h")).withRateLimiter(this.rateLimiter("requestWeight")).call();
        ticker24h.setCurrencyPair(pair);
        return ticker24h;
    }

    public BinancePrice tickerPrice(CurrencyPair pair) throws IOException {
        return (BinancePrice)this.tickerAllPrices().stream().filter(p -> p.getCurrencyPair().equals(pair)).collect(StreamUtils.singletonCollector());
    }

    public List<BinancePrice> tickerAllPrices() throws IOException {
        return this.decorateApiCall(() -> this.binance.tickerAllPrices()).withRetry(this.retry("tickerAllPrices")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public List<BinancePriceQuantity> tickerAllBookTickers() throws IOException {
        return this.decorateApiCall(() -> this.binance.tickerAllBookTickers()).withRetry(this.retry("tickerAllBookTickers")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    protected int depthPermits(Integer limit) {
        if (limit == null || limit <= 100) {
            return 1;
        }
        if (limit <= 500) {
            return 5;
        }
        if (limit <= 1000) {
            return 10;
        }
        return 50;
    }

    protected int aggTradesPermits(Integer limit) {
        if (limit != null && limit > 500) {
            return 2;
        }
        return 1;
    }
}

