/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.account;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import org.knowm.xchange.instrument.Instrument;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OpenPosition
implements Serializable {
    private final Instrument instrument;
    private final Type type;
    private final BigDecimal size;
    @JsonIgnore
    private final BigDecimal price;
    @JsonIgnore
    private final BigDecimal liquidationPrice;
    @JsonIgnore
    private final BigDecimal unRealisedPnl;

    public OpenPosition(@JsonProperty(value="instrument") Instrument instrument, @JsonProperty(value="type") Type type, @JsonProperty(value="size") BigDecimal size, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="liquidationPrice") BigDecimal liquidationPrice, @JsonProperty(value="unRealisedPnl") BigDecimal unRealisedPnl) {
        this.instrument = instrument;
        this.type = type;
        this.size = size;
        this.price = price;
        this.liquidationPrice = liquidationPrice;
        this.unRealisedPnl = unRealisedPnl;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public Type getType() {
        return this.type;
    }

    public BigDecimal getSize() {
        return this.size;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getLiquidationPrice() {
        return this.liquidationPrice;
    }

    public BigDecimal getUnRealisedPnl() {
        return this.unRealisedPnl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenPosition that = (OpenPosition)o;
        return Objects.equals(this.instrument, that.instrument) && this.type == that.type && Objects.equals(this.size, that.size) && Objects.equals(this.price, that.price) && Objects.equals(this.liquidationPrice, that.liquidationPrice) && Objects.equals(this.unRealisedPnl, that.unRealisedPnl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.instrument, this.type, this.size, this.price, this.liquidationPrice, this.unRealisedPnl});
    }

    public String toString() {
        return "OpenPosition{instrument=" + this.instrument + ", type=" + (Object)((Object)this.type) + ", size=" + this.size + ", price=" + this.price + ", liquidationPrice=" + this.liquidationPrice + ", unRealisedPnl=" + this.unRealisedPnl + '}';
    }

    public static enum Type {
        LONG,
        SHORT;

    }

    public static class Builder {
        private Instrument instrument;
        private Type type;
        private BigDecimal size;
        private BigDecimal price;
        private BigDecimal liquidationPrice;
        private BigDecimal unRealisedPnl;

        public static Builder from(OpenPosition openPosition) {
            return new Builder().instrument(openPosition.getInstrument()).type(openPosition.getType()).size(openPosition.getSize()).liquidationPrice(openPosition.getLiquidationPrice()).unRealisedPnl(openPosition.getUnRealisedPnl()).price(openPosition.getPrice());
        }

        public Builder instrument(Instrument instrument) {
            this.instrument = instrument;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder size(BigDecimal size) {
            this.size = size;
            return this;
        }

        public Builder price(BigDecimal price) {
            this.price = price;
            return this;
        }

        public Builder liquidationPrice(BigDecimal liquidationPrice) {
            this.liquidationPrice = liquidationPrice;
            return this;
        }

        public Builder unRealisedPnl(BigDecimal unRealisedPnl) {
            this.unRealisedPnl = unRealisedPnl;
            return this;
        }

        public OpenPosition build() {
            return new OpenPosition(this.instrument, this.type, this.size, this.price, this.liquidationPrice, this.unRealisedPnl);
        }
    }
}

