/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.service.account;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.AddressWithTag;
import org.knowm.xchange.dto.account.Fee;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.service.BaseService;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;

public interface AccountService
extends BaseService {
    default public AccountInfo getAccountInfo() throws IOException {
        throw new NotYetImplementedForExchangeException("getAccountInfo");
    }

    default public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        return this.withdrawFunds(new DefaultWithdrawFundsParams(address, currency, amount));
    }

    default public String withdrawFunds(Currency currency, BigDecimal amount, AddressWithTag address) throws IOException {
        return this.withdrawFunds(new DefaultWithdrawFundsParams(address, currency, amount));
    }

    default public String withdrawFunds(WithdrawFundsParams params) throws IOException {
        throw new NotYetImplementedForExchangeException("withdrawFunds");
    }

    default public String requestDepositAddress(Currency currency, String ... args) throws IOException {
        throw new NotYetImplementedForExchangeException("requestDepositAddress");
    }

    default public AddressWithTag requestDepositAddressData(Currency currency, String ... args) throws IOException {
        throw new NotYetImplementedForExchangeException("requestDepositAddressData");
    }

    default public TradeHistoryParams createFundingHistoryParams() {
        throw new NotYetImplementedForExchangeException("createFundingHistoryParams");
    }

    default public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws IOException {
        throw new NotYetImplementedForExchangeException("getFundingHistory");
    }

    default public Map<Instrument, Fee> getDynamicTradingFeesByInstrument() throws IOException {
        throw new NotYetImplementedForExchangeException("getDynamicTradingFeesByInstrument");
    }

    default public Map<CurrencyPair, Fee> getDynamicTradingFees() throws IOException {
        throw new NotYetImplementedForExchangeException("getDynamicTradingFees");
    }
}

