/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ezmorph.Morpher;
import net.sf.ezmorph.array.ObjectArrayMorpher;
import net.sf.ezmorph.bean.BeanMorpher;
import net.sf.ezmorph.object.IdentityObjectMorpher;
import net.sf.json.AbstractJSON;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONFunction;
import net.sf.json.JSONNull;
import net.sf.json.JSONString;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonBeanProcessor;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.processors.JsonVerifier;
import net.sf.json.processors.PropertyNameProcessor;
import net.sf.json.regexp.RegexpUtils;
import net.sf.json.util.CycleDetectionStrategy;
import net.sf.json.util.EnumMorpher;
import net.sf.json.util.JSONTokener;
import net.sf.json.util.JSONUtils;
import net.sf.json.util.PropertyFilter;
import net.sf.json.util.PropertySetStrategy;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JSONObject
extends AbstractJSON
implements JSON,
Map,
Comparable {
    private static final Log log = LogFactory.getLog(JSONObject.class);
    private boolean nullObject;
    private Map properties = new ListOrderedMap();

    public static JSONObject fromObject(Object object) {
        return JSONObject.fromObject(object, new JsonConfig());
    }

    public static JSONObject fromObject(Object object, JsonConfig jsonConfig) {
        if (object == null || JSONUtils.isNull(object)) {
            return new JSONObject(true);
        }
        if (object instanceof Enum) {
            throw new JSONException("'object' is an Enum. Use JSONArray instead");
        }
        if (object instanceof Annotation || object != null && object.getClass().isAnnotation()) {
            throw new JSONException("'object' is an Annotation.");
        }
        if (object instanceof JSONObject) {
            return JSONObject._fromJSONObject((JSONObject)object, jsonConfig);
        }
        if (object instanceof DynaBean) {
            return JSONObject._fromDynaBean((DynaBean)object, jsonConfig);
        }
        if (object instanceof JSONTokener) {
            return JSONObject._fromJSONTokener((JSONTokener)object, jsonConfig);
        }
        if (object instanceof JSONString) {
            return JSONObject._fromJSONString((JSONString)object, jsonConfig);
        }
        if (object instanceof Map) {
            return JSONObject._fromMap((Map)object, jsonConfig);
        }
        if (object instanceof String) {
            return JSONObject._fromString((String)object, jsonConfig);
        }
        if (JSONUtils.isNumber(object) || JSONUtils.isBoolean(object) || JSONUtils.isString(object)) {
            return new JSONObject();
        }
        if (JSONUtils.isArray(object)) {
            throw new JSONException("'object' is an array. Use JSONArray instead");
        }
        return JSONObject._fromBean(object, jsonConfig);
    }

    public static Object toBean(JSONObject jsonObject) {
        if (jsonObject == null || jsonObject.isNullObject()) {
            return null;
        }
        DynaBean dynaBean = null;
        JsonConfig jsonConfig = new JsonConfig();
        Map props = JSONUtils.getProperties(jsonObject);
        dynaBean = JSONUtils.newDynaBean(jsonObject, jsonConfig);
        for (String name : jsonObject.names(jsonConfig)) {
            String key = JSONUtils.convertToJavaIdentifier(name, jsonConfig);
            Class type = (Class)props.get(name);
            Object value = jsonObject.get(name);
            try {
                if (!JSONUtils.isNull(value)) {
                    if (value instanceof JSONArray) {
                        dynaBean.set(key, JSONArray.toCollection((JSONArray)value));
                        continue;
                    }
                    if (String.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || JSONUtils.isNumber(type) || Character.class.isAssignableFrom(type) || JSONFunction.class.isAssignableFrom(type)) {
                        dynaBean.set(key, value);
                        continue;
                    }
                    dynaBean.set(key, JSONObject.toBean((JSONObject)value));
                    continue;
                }
                if (type.isPrimitive()) {
                    log.warn((Object)("Tried to assign null value to " + key + ":" + type.getName()));
                    dynaBean.set(key, JSONUtils.getMorpherRegistry().morph(type, null));
                    continue;
                }
                dynaBean.set(key, null);
            }
            catch (JSONException jsone) {
                throw jsone;
            }
            catch (Exception e) {
                throw new JSONException("Error while setting property=" + name + " type" + type, e);
            }
        }
        return dynaBean;
    }

    public static Object toBean(JSONObject jsonObject, Class beanClass) {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setRootClass(beanClass);
        return JSONObject.toBean(jsonObject, jsonConfig);
    }

    public static Object toBean(JSONObject jsonObject, Class beanClass, Map classMap) {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setRootClass(beanClass);
        jsonConfig.setClassMap(classMap);
        return JSONObject.toBean(jsonObject, jsonConfig);
    }

    public static Object toBean(JSONObject jsonObject, JsonConfig jsonConfig) {
        if (jsonObject == null || jsonObject.isNullObject()) {
            return null;
        }
        Class beanClass = jsonConfig.getRootClass();
        Map classMap = jsonConfig.getClassMap();
        if (beanClass == null) {
            return JSONObject.toBean(jsonObject);
        }
        if (classMap == null) {
            classMap = Collections.EMPTY_MAP;
        }
        HashMap bean = null;
        try {
            if (beanClass.isInterface()) {
                if (!Map.class.isAssignableFrom(beanClass)) {
                    throw new JSONException("beanClass is an interface. " + beanClass);
                }
                bean = new HashMap();
            } else {
                bean = jsonConfig.getNewBeanInstanceStrategy().newInstance(beanClass, jsonObject);
            }
        }
        catch (JSONException jsone) {
            throw jsone;
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
        Map props = JSONUtils.getProperties(jsonObject);
        PropertyFilter javaPropertyFilter = jsonConfig.getJavaPropertyFilter();
        for (String name : jsonObject.names(jsonConfig)) {
            Class type = (Class)props.get(name);
            Object value = jsonObject.get(name);
            if (javaPropertyFilter != null && javaPropertyFilter.apply(bean, name, value)) continue;
            String key = Map.class.isAssignableFrom(beanClass) && jsonConfig.isSkipJavaIdentifierTransformationInMapKeys() ? name : JSONUtils.convertToJavaIdentifier(name, jsonConfig);
            PropertyNameProcessor propertyNameProcessor = jsonConfig.findJavaPropertyNameProcessor(beanClass);
            if (propertyNameProcessor != null) {
                key = propertyNameProcessor.processPropertyName(beanClass, key);
            }
            try {
                JsonConfig jsc;
                if (Map.class.isAssignableFrom(beanClass)) {
                    if (JSONUtils.isNull(value)) {
                        JSONObject.setProperty(bean, key, value, jsonConfig);
                        continue;
                    }
                    if (value instanceof JSONArray) {
                        JSONObject.setProperty(bean, key, JSONObject.convertPropertyValueToCollection(key, value, jsonConfig, name, classMap, List.class), jsonConfig);
                        continue;
                    }
                    if (String.class.isAssignableFrom(type) || JSONUtils.isBoolean(type) || JSONUtils.isNumber(type) || JSONUtils.isString(type) || JSONFunction.class.isAssignableFrom(type)) {
                        if (jsonConfig.isHandleJettisonEmptyElement() && "".equals(value)) {
                            JSONObject.setProperty(bean, key, null, jsonConfig);
                            continue;
                        }
                        JSONObject.setProperty(bean, key, value, jsonConfig);
                        continue;
                    }
                    Class targetClass = JSONObject.resolveClass(classMap, key, name, type);
                    JsonConfig jsc2 = jsonConfig.copy();
                    jsc2.setRootClass(targetClass);
                    jsc2.setClassMap(classMap);
                    if (targetClass != null) {
                        JSONObject.setProperty(bean, key, JSONObject.toBean((JSONObject)value, jsc2), jsonConfig);
                        continue;
                    }
                    JSONObject.setProperty(bean, key, JSONObject.toBean((JSONObject)value), jsonConfig);
                    continue;
                }
                PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor(bean, key);
                if (pd != null && pd.getWriteMethod() == null) {
                    log.info((Object)("Property '" + key + "' of " + bean.getClass() + " has no write method. SKIPPED."));
                    continue;
                }
                if (pd != null) {
                    Class targetType = pd.getPropertyType();
                    if (!JSONUtils.isNull(value)) {
                        if (value instanceof JSONArray) {
                            if (List.class.isAssignableFrom(pd.getPropertyType())) {
                                JSONObject.setProperty(bean, key, JSONObject.convertPropertyValueToCollection(key, value, jsonConfig, name, classMap, pd.getPropertyType()), jsonConfig);
                                continue;
                            }
                            if (Set.class.isAssignableFrom(pd.getPropertyType())) {
                                JSONObject.setProperty(bean, key, JSONObject.convertPropertyValueToCollection(key, value, jsonConfig, name, classMap, pd.getPropertyType()), jsonConfig);
                                continue;
                            }
                            JSONObject.setProperty(bean, key, JSONObject.convertPropertyValueToArray(key, value, targetType, jsonConfig, classMap), jsonConfig);
                            continue;
                        }
                        if (String.class.isAssignableFrom(type) || JSONUtils.isBoolean(type) || JSONUtils.isNumber(type) || JSONUtils.isString(type) || JSONFunction.class.isAssignableFrom(type)) {
                            if (pd != null) {
                                if (jsonConfig.isHandleJettisonEmptyElement() && "".equals(value)) {
                                    JSONObject.setProperty(bean, key, null, jsonConfig);
                                    continue;
                                }
                                if (!targetType.isInstance(value)) {
                                    JSONObject.setProperty(bean, key, JSONObject.morphPropertyValue(key, value, type, targetType), jsonConfig);
                                    continue;
                                }
                                JSONObject.setProperty(bean, key, value, jsonConfig);
                                continue;
                            }
                            if (beanClass == null || bean instanceof Map) {
                                JSONObject.setProperty(bean, key, value, jsonConfig);
                                continue;
                            }
                            log.warn((Object)("Tried to assign property " + key + ":" + type.getName() + " to bean of class " + bean.getClass().getName()));
                            continue;
                        }
                        if (jsonConfig.isHandleJettisonSingleElementArray()) {
                            JSONArray array = new JSONArray().element(value, jsonConfig);
                            Class newTargetClass = JSONObject.resolveClass(classMap, key, name, type);
                            JsonConfig jsc3 = jsonConfig.copy();
                            jsc3.setRootClass(newTargetClass);
                            jsc3.setClassMap(classMap);
                            if (targetType.isArray()) {
                                JSONObject.setProperty(bean, key, JSONArray.toArray(array, jsc3), jsonConfig);
                                continue;
                            }
                            if (JSONArray.class.isAssignableFrom(targetType)) {
                                JSONObject.setProperty(bean, key, array, jsonConfig);
                                continue;
                            }
                            if (List.class.isAssignableFrom(targetType) || Set.class.isAssignableFrom(targetType)) {
                                jsc3.setCollectionType(targetType);
                                JSONObject.setProperty(bean, key, JSONArray.toCollection(array, jsc3), jsonConfig);
                                continue;
                            }
                            JSONObject.setProperty(bean, key, JSONObject.toBean((JSONObject)value, jsc3), jsonConfig);
                            continue;
                        }
                        if (targetType == Object.class || targetType.isInterface()) {
                            Class targetTypeCopy = targetType;
                            targetType = JSONObject.findTargetClass(key, classMap);
                            targetType = targetType == null ? JSONObject.findTargetClass(name, classMap) : targetType;
                            targetType = targetType == null && targetTypeCopy.isInterface() ? targetTypeCopy : targetType;
                        }
                        jsc = jsonConfig.copy();
                        jsc.setRootClass(targetType);
                        jsc.setClassMap(classMap);
                        JSONObject.setProperty(bean, key, JSONObject.toBean((JSONObject)value, jsc), jsonConfig);
                        continue;
                    }
                    if (type.isPrimitive()) {
                        log.warn((Object)("Tried to assign null value to " + key + ":" + type.getName()));
                        JSONObject.setProperty(bean, key, JSONUtils.getMorpherRegistry().morph(type, null), jsonConfig);
                        continue;
                    }
                    JSONObject.setProperty(bean, key, null, jsonConfig);
                    continue;
                }
                if (!JSONUtils.isNull(value)) {
                    if (value instanceof JSONArray) {
                        JSONObject.setProperty(bean, key, JSONObject.convertPropertyValueToCollection(key, value, jsonConfig, name, classMap, List.class), jsonConfig);
                        continue;
                    }
                    if (String.class.isAssignableFrom(type) || JSONUtils.isBoolean(type) || JSONUtils.isNumber(type) || JSONUtils.isString(type) || JSONFunction.class.isAssignableFrom(type)) {
                        if (beanClass == null || bean instanceof Map || jsonConfig.getPropertySetStrategy() != null || !jsonConfig.isIgnorePublicFields()) {
                            JSONObject.setProperty(bean, key, value, jsonConfig);
                            continue;
                        }
                        log.warn((Object)("Tried to assign property " + key + ":" + type.getName() + " to bean of class " + bean.getClass().getName()));
                        continue;
                    }
                    if (jsonConfig.isHandleJettisonSingleElementArray()) {
                        Class newTargetClass = JSONObject.resolveClass(classMap, key, name, type);
                        jsc = jsonConfig.copy();
                        jsc.setRootClass(newTargetClass);
                        jsc.setClassMap(classMap);
                        JSONObject.setProperty(bean, key, JSONObject.toBean((JSONObject)value, jsc), jsonConfig);
                        continue;
                    }
                    JSONObject.setProperty(bean, key, value, jsonConfig);
                    continue;
                }
                if (type.isPrimitive()) {
                    log.warn((Object)("Tried to assign null value to " + key + ":" + type.getName()));
                    JSONObject.setProperty(bean, key, JSONUtils.getMorpherRegistry().morph(type, null), jsonConfig);
                    continue;
                }
                JSONObject.setProperty(bean, key, null, jsonConfig);
            }
            catch (JSONException jsone) {
                throw jsone;
            }
            catch (Exception e) {
                throw new JSONException("Error while setting property=" + name + " type " + type, e);
            }
        }
        return bean;
    }

    public static Object toBean(JSONObject jsonObject, Object root, JsonConfig jsonConfig) {
        if (jsonObject == null || jsonObject.isNullObject() || root == null) {
            return root;
        }
        Class<?> rootClass = root.getClass();
        if (rootClass.isInterface()) {
            throw new JSONException("Root bean is an interface. " + rootClass);
        }
        Map classMap = jsonConfig.getClassMap();
        if (classMap == null) {
            classMap = Collections.EMPTY_MAP;
        }
        Map props = JSONUtils.getProperties(jsonObject);
        PropertyFilter javaPropertyFilter = jsonConfig.getJavaPropertyFilter();
        for (String name : jsonObject.names(jsonConfig)) {
            Class type = (Class)props.get(name);
            Object value = jsonObject.get(name);
            if (javaPropertyFilter != null && javaPropertyFilter.apply(root, name, value)) continue;
            String key = JSONUtils.convertToJavaIdentifier(name, jsonConfig);
            try {
                PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor(root, key);
                if (pd != null && pd.getWriteMethod() == null) {
                    log.info((Object)("Property '" + key + "' of " + root.getClass() + " has no write method. SKIPPED."));
                    continue;
                }
                if (!JSONUtils.isNull(value)) {
                    Object newRoot;
                    Class<Object> targetClass;
                    if (value instanceof JSONArray) {
                        if (pd == null || List.class.isAssignableFrom(pd.getPropertyType())) {
                            targetClass = JSONObject.resolveClass(classMap, key, name, type);
                            newRoot = jsonConfig.getNewBeanInstanceStrategy().newInstance(targetClass, null);
                            List list = JSONArray.toList((JSONArray)value, newRoot, jsonConfig);
                            JSONObject.setProperty(root, key, list, jsonConfig);
                            continue;
                        }
                        Class innerType = JSONUtils.getInnerComponentType(pd.getPropertyType());
                        Class targetInnerType = JSONObject.findTargetClass(key, classMap);
                        if (innerType.equals(Object.class) && targetInnerType != null && !targetInnerType.equals(Object.class)) {
                            innerType = targetInnerType;
                        }
                        Object newRoot2 = jsonConfig.getNewBeanInstanceStrategy().newInstance(innerType, null);
                        Object array = JSONArray.toArray((JSONArray)value, newRoot2, jsonConfig);
                        if (innerType.isPrimitive() || JSONUtils.isNumber(innerType) || Boolean.class.isAssignableFrom(innerType) || JSONUtils.isString(innerType)) {
                            array = JSONUtils.getMorpherRegistry().morph(Array.newInstance(innerType, 0).getClass(), array);
                        } else if (!array.getClass().equals(pd.getPropertyType()) && !pd.getPropertyType().equals(Object.class)) {
                            Morpher morpher = JSONUtils.getMorpherRegistry().getMorpherFor(Array.newInstance(innerType, 0).getClass());
                            if (IdentityObjectMorpher.getInstance().equals(morpher)) {
                                ObjectArrayMorpher beanMorpher = new ObjectArrayMorpher(new BeanMorpher(innerType, JSONUtils.getMorpherRegistry()));
                                JSONUtils.getMorpherRegistry().registerMorpher(beanMorpher);
                            }
                            array = JSONUtils.getMorpherRegistry().morph(Array.newInstance(innerType, 0).getClass(), array);
                        }
                        JSONObject.setProperty(root, key, array, jsonConfig);
                        continue;
                    }
                    if (String.class.isAssignableFrom(type) || JSONUtils.isBoolean(type) || JSONUtils.isNumber(type) || JSONUtils.isString(type) || JSONFunction.class.isAssignableFrom(type)) {
                        if (pd != null) {
                            if (jsonConfig.isHandleJettisonEmptyElement() && "".equals(value)) {
                                JSONObject.setProperty(root, key, null, jsonConfig);
                                continue;
                            }
                            if (!pd.getPropertyType().isInstance(value)) {
                                Morpher morpher = JSONUtils.getMorpherRegistry().getMorpherFor(pd.getPropertyType());
                                if (IdentityObjectMorpher.getInstance().equals(morpher)) {
                                    log.warn((Object)("Can't transform property '" + key + "' from " + type.getName() + " into " + pd.getPropertyType().getName() + ". Will register a default BeanMorpher"));
                                    JSONUtils.getMorpherRegistry().registerMorpher(new BeanMorpher(pd.getPropertyType(), JSONUtils.getMorpherRegistry()));
                                }
                                JSONObject.setProperty(root, key, JSONUtils.getMorpherRegistry().morph(pd.getPropertyType(), value), jsonConfig);
                                continue;
                            }
                            JSONObject.setProperty(root, key, value, jsonConfig);
                            continue;
                        }
                        if (root instanceof Map) {
                            JSONObject.setProperty(root, key, value, jsonConfig);
                            continue;
                        }
                        log.warn((Object)("Tried to assign property " + key + ":" + type.getName() + " to bean of class " + root.getClass().getName()));
                        continue;
                    }
                    if (pd != null) {
                        targetClass = pd.getPropertyType();
                        if (jsonConfig.isHandleJettisonSingleElementArray()) {
                            JSONArray array = new JSONArray().element(value, jsonConfig);
                            Class newTargetClass = JSONObject.resolveClass(classMap, key, name, type);
                            Object newRoot3 = jsonConfig.getNewBeanInstanceStrategy().newInstance(newTargetClass, (JSONObject)value);
                            if (targetClass.isArray()) {
                                JSONObject.setProperty(root, key, JSONArray.toArray(array, newRoot3, jsonConfig), jsonConfig);
                                continue;
                            }
                            if (Collection.class.isAssignableFrom(targetClass)) {
                                JSONObject.setProperty(root, key, JSONArray.toList(array, newRoot3, jsonConfig), jsonConfig);
                                continue;
                            }
                            if (JSONArray.class.isAssignableFrom(targetClass)) {
                                JSONObject.setProperty(root, key, array, jsonConfig);
                                continue;
                            }
                            JSONObject.setProperty(root, key, JSONObject.toBean((JSONObject)value, newRoot3, jsonConfig), jsonConfig);
                            continue;
                        }
                        if (targetClass == Object.class && (targetClass = JSONObject.resolveClass(classMap, key, name, type)) == null) {
                            targetClass = Object.class;
                        }
                        newRoot = jsonConfig.getNewBeanInstanceStrategy().newInstance(targetClass, (JSONObject)value);
                        JSONObject.setProperty(root, key, JSONObject.toBean((JSONObject)value, newRoot, jsonConfig), jsonConfig);
                        continue;
                    }
                    if (root instanceof Map) {
                        targetClass = JSONObject.findTargetClass(key, classMap);
                        targetClass = targetClass == null ? JSONObject.findTargetClass(name, classMap) : targetClass;
                        newRoot = jsonConfig.getNewBeanInstanceStrategy().newInstance(targetClass, null);
                        JSONObject.setProperty(root, key, JSONObject.toBean((JSONObject)value, newRoot, jsonConfig), jsonConfig);
                        continue;
                    }
                    log.warn((Object)("Tried to assign property " + key + ":" + type.getName() + " to bean of class " + rootClass.getName()));
                    continue;
                }
                if (type.isPrimitive()) {
                    log.warn((Object)("Tried to assign null value to " + key + ":" + type.getName()));
                    JSONObject.setProperty(root, key, JSONUtils.getMorpherRegistry().morph(type, null), jsonConfig);
                    continue;
                }
                JSONObject.setProperty(root, key, null, jsonConfig);
            }
            catch (JSONException jsone) {
                throw jsone;
            }
            catch (Exception e) {
                throw new JSONException("Error while setting property=" + name + " type " + type, e);
            }
        }
        return root;
    }

    private static JSONObject _fromBean(Object bean, JsonConfig jsonConfig) {
        if (!JSONObject.addInstance(bean)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsObject(bean);
            }
            catch (JSONException jsone) {
                JSONObject.removeInstance(bean);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONObject.removeInstance(bean);
                JSONException jsone = new JSONException(e);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
        }
        JSONObject.fireObjectStartEvent(jsonConfig);
        JsonBeanProcessor processor = jsonConfig.findJsonBeanProcessor(bean.getClass());
        if (processor != null) {
            JSONObject json = null;
            try {
                json = processor.processBean(bean, jsonConfig);
                if (json == null && (json = (JSONObject)jsonConfig.findDefaultValueProcessor(bean.getClass()).getDefaultValue(bean.getClass())) == null) {
                    json = new JSONObject(true);
                }
                JSONObject.removeInstance(bean);
                JSONObject.fireObjectEndEvent(jsonConfig);
            }
            catch (JSONException jsone) {
                JSONObject.removeInstance(bean);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONObject.removeInstance(bean);
                JSONException jsone = new JSONException(e);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            return json;
        }
        JSONObject jsonObject = JSONObject.defaultBeanProcessing(bean, jsonConfig);
        JSONObject.removeInstance(bean);
        JSONObject.fireObjectEndEvent(jsonConfig);
        return jsonObject;
    }

    private static JSONObject defaultBeanProcessing(Object bean, JsonConfig jsonConfig) {
        Class<?> beanClass = bean.getClass();
        PropertyNameProcessor propertyNameProcessor = jsonConfig.findJsonPropertyNameProcessor(beanClass);
        Collection exclusions = jsonConfig.getMergedExcludes(beanClass);
        JSONObject jsonObject = new JSONObject();
        try {
            PropertyDescriptor[] pds = PropertyUtils.getPropertyDescriptors(bean);
            PropertyFilter jsonPropertyFilter = jsonConfig.getJsonPropertyFilter();
            for (int i = 0; i < pds.length; ++i) {
                boolean bypass = false;
                String key = pds[i].getName();
                if (exclusions.contains(key) || jsonConfig.isIgnoreTransientFields() && JSONObject.isTransientField(key, beanClass, jsonConfig)) continue;
                Class<?> type = pds[i].getPropertyType();
                try {
                    pds[i].getReadMethod();
                }
                catch (Exception e) {
                    String warning = "Property '" + key + "' of " + beanClass + " has no read method. SKIPPED";
                    JSONObject.fireWarnEvent(warning, jsonConfig);
                    log.info((Object)warning);
                    continue;
                }
                if (pds[i].getReadMethod() != null) {
                    if (JSONObject.isTransient(pds[i].getReadMethod(), jsonConfig)) continue;
                    Object value = PropertyUtils.getProperty(bean, key);
                    if (jsonPropertyFilter != null && jsonPropertyFilter.apply(bean, key, value)) continue;
                    JsonValueProcessor jsonValueProcessor = jsonConfig.findJsonValueProcessor(beanClass, type, key);
                    if (jsonValueProcessor != null) {
                        value = jsonValueProcessor.processObjectValue(key, value, jsonConfig);
                        bypass = true;
                        if (!JsonVerifier.isValidJsonValue(value)) {
                            throw new JSONException("Value is not a valid JSON value. " + value);
                        }
                    }
                    if (propertyNameProcessor != null) {
                        key = propertyNameProcessor.processPropertyName(beanClass, key);
                    }
                    JSONObject.setValue(jsonObject, key, value, type, jsonConfig, bypass);
                    continue;
                }
                String warning = "Property '" + key + "' of " + beanClass + " has no read method. SKIPPED";
                JSONObject.fireWarnEvent(warning, jsonConfig);
                log.info((Object)warning);
            }
            try {
                if (!jsonConfig.isIgnorePublicFields()) {
                    Field[] fields = beanClass.getFields();
                    for (int i = 0; i < fields.length; ++i) {
                        boolean bypass = false;
                        Field field = fields[i];
                        String key = field.getName();
                        if (exclusions.contains(key) || jsonConfig.isIgnoreTransientFields() && JSONObject.isTransient(field, jsonConfig)) continue;
                        Class<?> type = field.getType();
                        Object value = field.get(bean);
                        if (jsonPropertyFilter != null && jsonPropertyFilter.apply(bean, key, value)) continue;
                        JsonValueProcessor jsonValueProcessor = jsonConfig.findJsonValueProcessor(beanClass, type, key);
                        if (jsonValueProcessor != null) {
                            value = jsonValueProcessor.processObjectValue(key, value, jsonConfig);
                            bypass = true;
                            if (!JsonVerifier.isValidJsonValue(value)) {
                                throw new JSONException("Value is not a valid JSON value. " + value);
                            }
                        }
                        if (propertyNameProcessor != null) {
                            key = propertyNameProcessor.processPropertyName(beanClass, key);
                        }
                        JSONObject.setValue(jsonObject, key, value, type, jsonConfig, bypass);
                    }
                }
            }
            catch (Exception e) {
                log.trace((Object)"Couldn't read public fields.", (Throwable)e);
            }
        }
        catch (JSONException jsone) {
            JSONObject.removeInstance(bean);
            JSONObject.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
        catch (Exception e) {
            JSONObject.removeInstance(bean);
            JSONException jsone = new JSONException(e);
            JSONObject.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
        return jsonObject;
    }

    private static JSONObject _fromDynaBean(DynaBean bean, JsonConfig jsonConfig) {
        if (bean == null) {
            JSONObject.fireObjectStartEvent(jsonConfig);
            JSONObject.fireObjectEndEvent(jsonConfig);
            return new JSONObject(true);
        }
        if (!JSONObject.addInstance(bean)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsObject(bean);
            }
            catch (JSONException jsone) {
                JSONObject.removeInstance(bean);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONObject.removeInstance(bean);
                JSONException jsone = new JSONException(e);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
        }
        JSONObject.fireObjectStartEvent(jsonConfig);
        JSONObject jsonObject = new JSONObject();
        try {
            DynaProperty[] props = bean.getDynaClass().getDynaProperties();
            Collection exclusions = jsonConfig.getMergedExcludes();
            PropertyFilter jsonPropertyFilter = jsonConfig.getJsonPropertyFilter();
            for (int i = 0; i < props.length; ++i) {
                boolean bypass = false;
                DynaProperty dynaProperty = props[i];
                String key = dynaProperty.getName();
                if (exclusions.contains(key)) continue;
                Class type = dynaProperty.getType();
                Object value = bean.get(dynaProperty.getName());
                if (jsonPropertyFilter != null && jsonPropertyFilter.apply(bean, key, value)) continue;
                JsonValueProcessor jsonValueProcessor = jsonConfig.findJsonValueProcessor(type, key);
                if (jsonValueProcessor != null) {
                    value = jsonValueProcessor.processObjectValue(key, value, jsonConfig);
                    bypass = true;
                    if (!JsonVerifier.isValidJsonValue(value)) {
                        throw new JSONException("Value is not a valid JSON value. " + value);
                    }
                }
                JSONObject.setValue(jsonObject, key, value, type, jsonConfig, bypass);
            }
        }
        catch (JSONException jsone) {
            JSONObject.removeInstance(bean);
            JSONObject.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
        catch (RuntimeException e) {
            JSONObject.removeInstance(bean);
            JSONException jsone = new JSONException(e);
            JSONObject.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
        JSONObject.removeInstance(bean);
        JSONObject.fireObjectEndEvent(jsonConfig);
        return jsonObject;
    }

    private static JSONObject _fromJSONObject(JSONObject object, JsonConfig jsonConfig) {
        if (object == null || object.isNullObject()) {
            JSONObject.fireObjectStartEvent(jsonConfig);
            JSONObject.fireObjectEndEvent(jsonConfig);
            return new JSONObject(true);
        }
        if (!JSONObject.addInstance(object)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsObject(object);
            }
            catch (JSONException jsone) {
                JSONObject.removeInstance(object);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONObject.removeInstance(object);
                JSONException jsone = new JSONException(e);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
        }
        JSONObject.fireObjectStartEvent(jsonConfig);
        JSONArray sa = object.names(jsonConfig);
        Collection exclusions = jsonConfig.getMergedExcludes();
        JSONObject jsonObject = new JSONObject();
        PropertyFilter jsonPropertyFilter = jsonConfig.getJsonPropertyFilter();
        for (Object k : sa) {
            if (k == null) {
                throw new JSONException("JSON keys cannot be null.");
            }
            if (!(k instanceof String) && !jsonConfig.isAllowNonStringKeys()) {
                throw new ClassCastException("JSON keys must be strings.");
            }
            String key = String.valueOf(k);
            if ("null".equals(key)) {
                throw new NullPointerException("JSON keys must not be null nor the 'null' string.");
            }
            if (exclusions.contains(key)) continue;
            Object value = object.opt(key);
            if (jsonPropertyFilter != null && jsonPropertyFilter.apply(object, key, value)) continue;
            if (jsonObject.properties.containsKey(key)) {
                jsonObject.accumulate(key, value, jsonConfig);
                JSONObject.firePropertySetEvent(key, value, true, jsonConfig);
                continue;
            }
            jsonObject.setInternal(key, value, jsonConfig);
            JSONObject.firePropertySetEvent(key, value, false, jsonConfig);
        }
        JSONObject.removeInstance(object);
        JSONObject.fireObjectEndEvent(jsonConfig);
        return jsonObject;
    }

    private static JSONObject _fromJSONString(JSONString string, JsonConfig jsonConfig) {
        return JSONObject._fromJSONTokener(new JSONTokener(string.toJSONString()), jsonConfig);
    }

    private static JSONObject _fromJSONTokener(JSONTokener tokener, JsonConfig jsonConfig) {
        try {
            if (tokener.matches("null.*")) {
                JSONObject.fireObjectStartEvent(jsonConfig);
                JSONObject.fireObjectEndEvent(jsonConfig);
                return new JSONObject(true);
            }
            if (tokener.nextClean() != '{') {
                throw tokener.syntaxError("A JSONObject text must begin with '{'");
            }
            JSONObject.fireObjectStartEvent(jsonConfig);
            Collection exclusions = jsonConfig.getMergedExcludes();
            PropertyFilter jsonPropertyFilter = jsonConfig.getJsonPropertyFilter();
            JSONObject jsonObject = new JSONObject();
            block14: while (true) {
                char peek;
                char c = tokener.nextClean();
                switch (c) {
                    case '\u0000': {
                        throw tokener.syntaxError("A JSONObject text must end with '}'");
                    }
                    case '}': {
                        JSONObject.fireObjectEndEvent(jsonConfig);
                        return jsonObject;
                    }
                }
                tokener.back();
                String key = tokener.nextValue(jsonConfig).toString();
                c = tokener.nextClean();
                if (c == '=') {
                    if (tokener.next() != '>') {
                        tokener.back();
                    }
                } else if (c != ':') {
                    throw tokener.syntaxError("Expected a ':' after a key");
                }
                boolean quoted = (peek = tokener.peek()) == '\"' || peek == '\'';
                Object v = tokener.nextValue(jsonConfig);
                if (quoted || !JSONUtils.isFunctionHeader(v)) {
                    if (exclusions.contains(key)) {
                        switch (tokener.nextClean()) {
                            case ',': 
                            case ';': {
                                if (tokener.nextClean() == '}') {
                                    JSONObject.fireObjectEndEvent(jsonConfig);
                                    return jsonObject;
                                }
                                tokener.back();
                                continue block14;
                            }
                            case '}': {
                                JSONObject.fireObjectEndEvent(jsonConfig);
                                return jsonObject;
                            }
                        }
                        throw tokener.syntaxError("Expected a ',' or '}'");
                    }
                    if (jsonPropertyFilter == null || !jsonPropertyFilter.apply(tokener, key, v)) {
                        if (quoted && v instanceof String && (JSONUtils.mayBeJSON((String)v) || JSONUtils.isFunction(v))) {
                            v = "\"" + v + "\"";
                        }
                        if (jsonObject.properties.containsKey(key)) {
                            jsonObject.accumulate(key, v, jsonConfig);
                            JSONObject.firePropertySetEvent(key, v, true, jsonConfig);
                        } else {
                            jsonObject.element(key, v, jsonConfig);
                            JSONObject.firePropertySetEvent(key, v, false, jsonConfig);
                        }
                    }
                } else {
                    char ch;
                    String params = JSONUtils.getFunctionParams((String)v);
                    int i = 0;
                    StringBuffer sb = new StringBuffer();
                    while ((ch = tokener.next()) != '\u0000') {
                        if (ch == '{') {
                            ++i;
                        }
                        if (ch == '}') {
                            --i;
                        }
                        sb.append(ch);
                        if (i != 0) continue;
                        break;
                    }
                    if (i != 0) {
                        throw tokener.syntaxError("Unbalanced '{' or '}' on prop: " + v);
                    }
                    String text = sb.toString();
                    text = text.substring(1, text.length() - 1).trim();
                    JSONFunction value = new JSONFunction(params != null ? StringUtils.split((String)params, (String)",") : null, text);
                    if (jsonPropertyFilter == null || !jsonPropertyFilter.apply(tokener, key, value)) {
                        if (jsonObject.properties.containsKey(key)) {
                            jsonObject.accumulate(key, value, jsonConfig);
                            JSONObject.firePropertySetEvent(key, value, true, jsonConfig);
                        } else {
                            jsonObject.element(key, value, jsonConfig);
                            JSONObject.firePropertySetEvent(key, value, false, jsonConfig);
                        }
                    }
                }
                switch (tokener.nextClean()) {
                    case ',': 
                    case ';': {
                        if (tokener.nextClean() == '}') {
                            JSONObject.fireObjectEndEvent(jsonConfig);
                            return jsonObject;
                        }
                        tokener.back();
                        continue block14;
                    }
                    case '}': {
                        JSONObject.fireObjectEndEvent(jsonConfig);
                        return jsonObject;
                    }
                }
                break;
            }
            throw tokener.syntaxError("Expected a ',' or '}'");
        }
        catch (JSONException jsone) {
            JSONObject.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
    }

    private static JSONObject _fromMap(Map map, JsonConfig jsonConfig) {
        if (map == null) {
            JSONObject.fireObjectStartEvent(jsonConfig);
            JSONObject.fireObjectEndEvent(jsonConfig);
            return new JSONObject(true);
        }
        if (!JSONObject.addInstance(map)) {
            try {
                return jsonConfig.getCycleDetectionStrategy().handleRepeatedReferenceAsObject(map);
            }
            catch (JSONException jsone) {
                JSONObject.removeInstance(map);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
            catch (RuntimeException e) {
                JSONObject.removeInstance(map);
                JSONException jsone = new JSONException(e);
                JSONObject.fireErrorEvent(jsone, jsonConfig);
                throw jsone;
            }
        }
        JSONObject.fireObjectStartEvent(jsonConfig);
        Collection exclusions = jsonConfig.getMergedExcludes();
        JSONObject jsonObject = new JSONObject();
        PropertyFilter jsonPropertyFilter = jsonConfig.getJsonPropertyFilter();
        try {
            Iterator entries = map.entrySet().iterator();
            while (entries.hasNext()) {
                boolean bypass = false;
                Map.Entry entry = entries.next();
                Object k = entry.getKey();
                if (k == null) {
                    throw new JSONException("JSON keys cannot be null.");
                }
                if (!(k instanceof String) && !jsonConfig.isAllowNonStringKeys()) {
                    throw new ClassCastException("JSON keys must be strings.");
                }
                String key = String.valueOf(k);
                if ("null".equals(key)) {
                    throw new NullPointerException("JSON keys must not be null nor the 'null' string.");
                }
                if (exclusions.contains(key)) continue;
                Object value = entry.getValue();
                if (jsonPropertyFilter != null && jsonPropertyFilter.apply(map, key, value)) continue;
                if (value != null) {
                    JsonValueProcessor jsonValueProcessor = jsonConfig.findJsonValueProcessor(value.getClass(), key);
                    if (jsonValueProcessor != null) {
                        value = jsonValueProcessor.processObjectValue(key, value, jsonConfig);
                        bypass = true;
                        if (!JsonVerifier.isValidJsonValue(value)) {
                            throw new JSONException("Value is not a valid JSON value. " + value);
                        }
                    }
                    JSONObject.setValue(jsonObject, key, value, value.getClass(), jsonConfig, bypass);
                    continue;
                }
                if (jsonObject.properties.containsKey(key)) {
                    jsonObject.accumulate(key, JSONNull.getInstance());
                    JSONObject.firePropertySetEvent(key, JSONNull.getInstance(), true, jsonConfig);
                    continue;
                }
                jsonObject.element(key, JSONNull.getInstance());
                JSONObject.firePropertySetEvent(key, JSONNull.getInstance(), false, jsonConfig);
            }
        }
        catch (JSONException jsone) {
            JSONObject.removeInstance(map);
            JSONObject.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
        catch (RuntimeException e) {
            JSONObject.removeInstance(map);
            JSONException jsone = new JSONException(e);
            JSONObject.fireErrorEvent(jsone, jsonConfig);
            throw jsone;
        }
        JSONObject.removeInstance(map);
        JSONObject.fireObjectEndEvent(jsonConfig);
        return jsonObject;
    }

    private static JSONObject _fromString(String str, JsonConfig jsonConfig) {
        if (str == null || "null".equals(str)) {
            JSONObject.fireObjectStartEvent(jsonConfig);
            JSONObject.fireObjectEndEvent(jsonConfig);
            return new JSONObject(true);
        }
        return JSONObject._fromJSONTokener(new JSONTokener(str), jsonConfig);
    }

    private static Object convertPropertyValueToArray(String key, Object value, Class targetType, JsonConfig jsonConfig, Map classMap) {
        Class innerType = JSONUtils.getInnerComponentType(targetType);
        Class targetInnerType = JSONObject.findTargetClass(key, classMap);
        if (innerType.equals(Object.class) && targetInnerType != null && !targetInnerType.equals(Object.class)) {
            innerType = targetInnerType;
        }
        JsonConfig jsc = jsonConfig.copy();
        jsc.setRootClass(innerType);
        jsc.setClassMap(classMap);
        Object array = JSONArray.toArray((JSONArray)value, jsc);
        if (innerType.isPrimitive() || JSONUtils.isNumber(innerType) || Boolean.class.isAssignableFrom(innerType) || JSONUtils.isString(innerType)) {
            array = JSONUtils.getMorpherRegistry().morph(Array.newInstance(innerType, 0).getClass(), array);
        } else if (!array.getClass().equals(targetType) && !targetType.equals(Object.class)) {
            Morpher morpher = JSONUtils.getMorpherRegistry().getMorpherFor(Array.newInstance(innerType, 0).getClass());
            if (IdentityObjectMorpher.getInstance().equals(morpher)) {
                ObjectArrayMorpher beanMorpher = new ObjectArrayMorpher(new BeanMorpher(innerType, JSONUtils.getMorpherRegistry()));
                JSONUtils.getMorpherRegistry().registerMorpher(beanMorpher);
            }
            array = JSONUtils.getMorpherRegistry().morph(Array.newInstance(innerType, 0).getClass(), array);
        }
        return array;
    }

    private static List convertPropertyValueToList(String key, Object value, JsonConfig jsonConfig, String name, Map classMap) {
        Class targetClass = JSONObject.findTargetClass(key, classMap);
        targetClass = targetClass == null ? JSONObject.findTargetClass(name, classMap) : targetClass;
        JsonConfig jsc = jsonConfig.copy();
        jsc.setRootClass(targetClass);
        jsc.setClassMap(classMap);
        List list = (List)JSONArray.toCollection((JSONArray)value, jsc);
        return list;
    }

    private static Collection convertPropertyValueToCollection(String key, Object value, JsonConfig jsonConfig, String name, Map classMap, Class collectionType) {
        Class targetClass = JSONObject.findTargetClass(key, classMap);
        targetClass = targetClass == null ? JSONObject.findTargetClass(name, classMap) : targetClass;
        JsonConfig jsc = jsonConfig.copy();
        jsc.setRootClass(targetClass);
        jsc.setClassMap(classMap);
        jsc.setCollectionType(collectionType);
        return JSONArray.toCollection((JSONArray)value, jsc);
    }

    private static Class resolveClass(Map classMap, String key, String name, Class type) {
        Class<ArrayList> targetClass = JSONObject.findTargetClass(key, classMap);
        if (targetClass == null) {
            targetClass = JSONObject.findTargetClass(name, classMap);
        }
        if (targetClass == null && type != null) {
            if (List.class.equals((Object)type)) {
                targetClass = ArrayList.class;
            } else if (Map.class.equals((Object)type)) {
                targetClass = LinkedHashMap.class;
            } else if (Set.class.equals((Object)type)) {
                targetClass = LinkedHashSet.class;
            } else if (!type.isInterface() && !Object.class.equals((Object)type)) {
                targetClass = type;
            }
        }
        return targetClass;
    }

    private static Class findTargetClass(String key, Map classMap) {
        Class targetClass = (Class)classMap.get(key);
        if (targetClass == null) {
            for (Map.Entry entry : classMap.entrySet()) {
                if (!RegexpUtils.getMatcher((String)entry.getKey()).matches(key)) continue;
                targetClass = (Class)entry.getValue();
                break;
            }
        }
        return targetClass;
    }

    private static boolean isTransientField(String name, Class beanClass, JsonConfig jsonConfig) {
        try {
            Field field = beanClass.getDeclaredField(name);
            if ((field.getModifiers() & 0x80) == 128) {
                return true;
            }
            return JSONObject.isTransient(field, jsonConfig);
        }
        catch (Exception e) {
            log.info((Object)("Error while inspecting field " + beanClass + "." + name + " for transient status."), (Throwable)e);
            return false;
        }
    }

    private static boolean isTransient(AnnotatedElement element, JsonConfig jsonConfig) {
        Iterator annotations = jsonConfig.getIgnoreFieldAnnotations().iterator();
        while (annotations.hasNext()) {
            try {
                String annotationClassName = (String)annotations.next();
                if (element.getAnnotation(Class.forName(annotationClassName)) == null) continue;
                return true;
            }
            catch (Exception e) {
                log.info((Object)("Error while inspecting " + element + " for transient status."), (Throwable)e);
            }
        }
        return false;
    }

    private static Object morphPropertyValue(String key, Object value, Class type, Class targetType) {
        Morpher morpher = JSONUtils.getMorpherRegistry().getMorpherFor(targetType);
        if (IdentityObjectMorpher.getInstance().equals(morpher)) {
            log.warn((Object)("Can't transform property '" + key + "' from " + type.getName() + " into " + targetType.getName() + ". Will register a default Morpher"));
            if (Enum.class.isAssignableFrom(targetType)) {
                JSONUtils.getMorpherRegistry().registerMorpher(new EnumMorpher(targetType));
            } else {
                JSONUtils.getMorpherRegistry().registerMorpher(new BeanMorpher(targetType, JSONUtils.getMorpherRegistry()));
            }
        }
        value = JSONUtils.getMorpherRegistry().morph(targetType, value);
        return value;
    }

    private static void setProperty(Object bean, String key, Object value, JsonConfig jsonConfig) throws Exception {
        PropertySetStrategy propertySetStrategy = jsonConfig.getPropertySetStrategy() != null ? jsonConfig.getPropertySetStrategy() : PropertySetStrategy.DEFAULT;
        propertySetStrategy.setProperty(bean, key, value, jsonConfig);
    }

    private static void setValue(JSONObject jsonObject, String key, Object value, Class type, JsonConfig jsonConfig, boolean bypass) {
        boolean accumulated = false;
        if (value == null && !JsonVerifier.isValidJsonValue(value = jsonConfig.findDefaultValueProcessor(type).getDefaultValue(type))) {
            throw new JSONException("Value is not a valid JSON value. " + value);
        }
        if (jsonObject.properties.containsKey(key)) {
            if (String.class.isAssignableFrom(type)) {
                Object o = jsonObject.opt(key);
                if (o instanceof JSONArray) {
                    ((JSONArray)o).addString((String)value);
                } else {
                    jsonObject.properties.put(key, new JSONArray().element(o).addString((String)value));
                }
            } else {
                jsonObject.accumulate(key, value, jsonConfig);
            }
            accumulated = true;
        } else if (bypass || String.class.isAssignableFrom(type)) {
            jsonObject.properties.put(key, value);
        } else {
            jsonObject.setInternal(key, value, jsonConfig);
        }
        value = jsonObject.opt(key);
        if (accumulated) {
            JSONArray array = (JSONArray)value;
            value = array.get(array.size() - 1);
        }
        JSONObject.firePropertySetEvent(key, value, accumulated, jsonConfig);
    }

    public JSONObject() {
    }

    public JSONObject(boolean isNull) {
        this();
        this.nullObject = isNull;
    }

    public JSONObject accumulate(String key, boolean value) {
        return this._accumulate(key, value ? Boolean.TRUE : Boolean.FALSE, new JsonConfig());
    }

    public JSONObject accumulate(String key, double value) {
        return this._accumulate(key, value, new JsonConfig());
    }

    public JSONObject accumulate(String key, int value) {
        return this._accumulate(key, value, new JsonConfig());
    }

    public JSONObject accumulate(String key, long value) {
        return this._accumulate(key, value, new JsonConfig());
    }

    public JSONObject accumulate(String key, Object value) {
        return this._accumulate(key, value, new JsonConfig());
    }

    public JSONObject accumulate(String key, Object value, JsonConfig jsonConfig) {
        return this._accumulate(key, value, jsonConfig);
    }

    public void accumulateAll(Map map) {
        this.accumulateAll(map, new JsonConfig());
    }

    public void accumulateAll(Map map, JsonConfig jsonConfig) {
        if (map instanceof JSONObject) {
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                this.accumulate(key, value, jsonConfig);
            }
        } else {
            for (Map.Entry entry : map.entrySet()) {
                String key = String.valueOf(entry.getKey());
                Object value = entry.getValue();
                this.accumulate(key, value, jsonConfig);
            }
        }
    }

    public void clear() {
        this.properties.clear();
    }

    public int compareTo(Object obj) {
        if (obj != null && obj instanceof JSONObject) {
            int size2;
            JSONObject other = (JSONObject)obj;
            int size1 = this.size();
            if (size1 < (size2 = other.size())) {
                return -1;
            }
            if (size1 > size2) {
                return 1;
            }
            if (this.equals(other)) {
                return 0;
            }
        }
        return -1;
    }

    public boolean containsKey(Object key) {
        return this.properties.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.containsValue(value, new JsonConfig());
    }

    public boolean containsValue(Object value, JsonConfig jsonConfig) {
        try {
            value = this.processValue(value, jsonConfig);
        }
        catch (JSONException e) {
            return false;
        }
        return this.properties.containsValue(value);
    }

    public JSONObject discard(String key) {
        this.verifyIsNull();
        this.properties.remove(key);
        return this;
    }

    public JSONObject element(String key, boolean value) {
        this.verifyIsNull();
        return this.element(key, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public JSONObject element(String key, Collection value) {
        return this.element(key, value, new JsonConfig());
    }

    public JSONObject element(String key, Collection value, JsonConfig jsonConfig) {
        if (!(value instanceof JSONArray)) {
            value = JSONArray.fromObject(value, jsonConfig);
        }
        return this.setInternal(key, value, jsonConfig);
    }

    public JSONObject element(String key, double value) {
        this.verifyIsNull();
        Double d = new Double(value);
        JSONUtils.testValidity(d);
        return this.element(key, d);
    }

    public JSONObject element(String key, int value) {
        this.verifyIsNull();
        return this.element(key, new Integer(value));
    }

    public JSONObject element(String key, long value) {
        this.verifyIsNull();
        return this.element(key, new Long(value));
    }

    public JSONObject element(String key, Map value) {
        return this.element(key, value, new JsonConfig());
    }

    public JSONObject element(String key, Map value, JsonConfig jsonConfig) {
        this.verifyIsNull();
        if (value instanceof JSONObject) {
            return this.setInternal(key, value, jsonConfig);
        }
        return this.element(key, JSONObject.fromObject(value, jsonConfig), jsonConfig);
    }

    public JSONObject element(String key, Object value) {
        return this.element(key, value, new JsonConfig());
    }

    public JSONObject element(String key, Object value, JsonConfig jsonConfig) {
        this.verifyIsNull();
        if (key == null) {
            throw new JSONException("Null key.");
        }
        if (value != null) {
            value = this.processValue(key, value, jsonConfig);
            this._setInternal(key, value, jsonConfig);
        } else {
            this.remove(key);
        }
        return this;
    }

    public JSONObject elementOpt(String key, Object value) {
        return this.elementOpt(key, value, new JsonConfig());
    }

    public JSONObject elementOpt(String key, Object value, JsonConfig jsonConfig) {
        this.verifyIsNull();
        if (key != null && value != null) {
            this.element(key, value, jsonConfig);
        }
        return this;
    }

    public Set entrySet() {
        return Collections.unmodifiableSet(this.properties.entrySet());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JSONObject)) {
            return false;
        }
        JSONObject other = (JSONObject)obj;
        if (this.isNullObject()) {
            return other.isNullObject();
        }
        if (other.isNullObject()) {
            return false;
        }
        if (other.size() != this.size()) {
            return false;
        }
        for (String key : this.properties.keySet()) {
            if (!other.properties.containsKey(key)) {
                return false;
            }
            Object o1 = this.properties.get(key);
            Object o2 = other.properties.get(key);
            if (JSONNull.getInstance().equals(o1)) {
                if (JSONNull.getInstance().equals(o2)) continue;
                return false;
            }
            if (JSONNull.getInstance().equals(o2)) {
                return false;
            }
            if (o1 instanceof String && o2 instanceof JSONFunction) {
                if (o1.equals(String.valueOf(o2))) continue;
                return false;
            }
            if (o1 instanceof JSONFunction && o2 instanceof String) {
                if (o2.equals(String.valueOf(o1))) continue;
                return false;
            }
            if (o1 instanceof JSONObject && o2 instanceof JSONObject) {
                if (o1.equals(o2)) continue;
                return false;
            }
            if (o1 instanceof JSONArray && o2 instanceof JSONArray) {
                if (o1.equals(o2)) continue;
                return false;
            }
            if (o1 instanceof JSONFunction && o2 instanceof JSONFunction) {
                if (o1.equals(o2)) continue;
                return false;
            }
            if (o1 instanceof String) {
                if (o1.equals(String.valueOf(o2))) continue;
                return false;
            }
            if (o2 instanceof String) {
                if (o2.equals(String.valueOf(o1))) continue;
                return false;
            }
            Morpher m1 = JSONUtils.getMorpherRegistry().getMorpherFor(o1.getClass());
            Morpher m2 = JSONUtils.getMorpherRegistry().getMorpherFor(o2.getClass());
            if (!(m1 != null && m1 != IdentityObjectMorpher.getInstance() ? !o1.equals(JSONUtils.getMorpherRegistry().morph(o1.getClass(), o2)) : (m2 != null && m2 != IdentityObjectMorpher.getInstance() ? !JSONUtils.getMorpherRegistry().morph(o1.getClass(), o1).equals(o2) : !o1.equals(o2)))) continue;
            return false;
        }
        return true;
    }

    public Object get(Object key) {
        if (key instanceof String) {
            return this.get((String)key);
        }
        return null;
    }

    public Object get(String key) {
        this.verifyIsNull();
        return this.properties.get(key);
    }

    public boolean getBoolean(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o != null) {
            if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
                return false;
            }
            if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
                return true;
            }
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a Boolean.");
    }

    public double getDouble(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o != null) {
            try {
                return o instanceof Number ? ((Number)o).doubleValue() : Double.parseDouble((String)o);
            }
            catch (Exception e) {
                throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a number.");
            }
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a number.");
    }

    public int getInt(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o != null) {
            return o instanceof Number ? ((Number)o).intValue() : (int)this.getDouble(key);
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a number.");
    }

    public JSONArray getJSONArray(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o != null && o instanceof JSONArray) {
            return (JSONArray)o;
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (JSONNull.getInstance().equals(o)) {
            return new JSONObject(true);
        }
        if (o instanceof JSONObject) {
            return (JSONObject)o;
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a JSONObject.");
    }

    public long getLong(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o != null) {
            return o instanceof Number ? ((Number)o).longValue() : (long)this.getDouble(key);
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] is not a number.");
    }

    public String getString(String key) {
        this.verifyIsNull();
        Object o = this.get(key);
        if (o != null) {
            return o.toString();
        }
        throw new JSONException("JSONObject[" + JSONUtils.quote(key) + "] not found.");
    }

    public boolean has(String key) {
        this.verifyIsNull();
        return this.properties.containsKey(key);
    }

    public int hashCode() {
        int hashcode = 19;
        if (this.isNullObject()) {
            return hashcode + JSONNull.getInstance().hashCode();
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            hashcode += key.hashCode() + JSONUtils.hashCode(value);
        }
        return hashcode;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public boolean isNullObject() {
        return this.nullObject;
    }

    public Iterator keys() {
        this.verifyIsNull();
        return this.keySet().iterator();
    }

    public Set keySet() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public JSONArray names() {
        this.verifyIsNull();
        JSONArray ja = new JSONArray();
        Iterator keys = this.keys();
        while (keys.hasNext()) {
            ja.element(keys.next());
        }
        return ja;
    }

    public JSONArray names(JsonConfig jsonConfig) {
        this.verifyIsNull();
        JSONArray ja = new JSONArray();
        Iterator keys = this.keys();
        while (keys.hasNext()) {
            ja.element(keys.next(), jsonConfig);
        }
        return ja;
    }

    public Object opt(String key) {
        this.verifyIsNull();
        return key == null ? null : this.properties.get(key);
    }

    public boolean optBoolean(String key) {
        this.verifyIsNull();
        return this.optBoolean(key, false);
    }

    public boolean optBoolean(String key, boolean defaultValue) {
        this.verifyIsNull();
        try {
            return this.getBoolean(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double optDouble(String key) {
        this.verifyIsNull();
        return this.optDouble(key, Double.NaN);
    }

    public double optDouble(String key, double defaultValue) {
        this.verifyIsNull();
        try {
            Object o = this.opt(key);
            return o instanceof Number ? ((Number)o).doubleValue() : new Double((String)o).doubleValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int optInt(String key) {
        this.verifyIsNull();
        return this.optInt(key, 0);
    }

    public int optInt(String key, int defaultValue) {
        this.verifyIsNull();
        try {
            return this.getInt(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public JSONArray optJSONArray(String key) {
        this.verifyIsNull();
        Object o = this.opt(key);
        return o instanceof JSONArray ? (JSONArray)o : null;
    }

    public JSONObject optJSONObject(String key) {
        this.verifyIsNull();
        Object o = this.opt(key);
        return o instanceof JSONObject ? (JSONObject)o : null;
    }

    public long optLong(String key) {
        this.verifyIsNull();
        return this.optLong(key, 0L);
    }

    public long optLong(String key, long defaultValue) {
        this.verifyIsNull();
        try {
            return this.getLong(key);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(String key) {
        this.verifyIsNull();
        return this.optString(key, "");
    }

    public String optString(String key, String defaultValue) {
        this.verifyIsNull();
        Object o = this.opt(key);
        return o != null ? o.toString() : defaultValue;
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key is null.");
        }
        Object previous = this.properties.get(key);
        this.element(String.valueOf(key), value);
        return previous;
    }

    public void putAll(Map map) {
        this.putAll(map, new JsonConfig());
    }

    public void putAll(Map map, JsonConfig jsonConfig) {
        if (map instanceof JSONObject) {
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                this.properties.put(key, value);
            }
        } else {
            for (Map.Entry entry : map.entrySet()) {
                String key = String.valueOf(entry.getKey());
                Object value = entry.getValue();
                this.element(key, value, jsonConfig);
            }
        }
    }

    public Object remove(Object key) {
        return this.properties.remove(key);
    }

    public Object remove(String key) {
        this.verifyIsNull();
        return this.properties.remove(key);
    }

    public int size() {
        return this.properties.size();
    }

    public JSONArray toJSONArray(JSONArray names) {
        this.verifyIsNull();
        if (names == null || names.size() == 0) {
            return null;
        }
        JSONArray ja = new JSONArray();
        for (int i = 0; i < names.size(); ++i) {
            ja.element(this.opt(names.getString(i)));
        }
        return ja;
    }

    public String toString() {
        if (this.isNullObject()) {
            return JSONNull.getInstance().toString();
        }
        try {
            Iterator keys = this.keys();
            StringBuffer sb = new StringBuffer("{");
            while (keys.hasNext()) {
                if (sb.length() > 1) {
                    sb.append(',');
                }
                Object o = keys.next();
                sb.append(JSONUtils.quote(o.toString()));
                sb.append(':');
                sb.append(JSONUtils.valueToString(this.properties.get(o)));
            }
            sb.append('}');
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString(int indentFactor) {
        if (this.isNullObject()) {
            return JSONNull.getInstance().toString();
        }
        if (indentFactor == 0) {
            return this.toString();
        }
        return this.toString(indentFactor, 0);
    }

    public String toString(int indentFactor, int indent) {
        if (this.isNullObject()) {
            return JSONNull.getInstance().toString();
        }
        int n = this.size();
        if (n == 0) {
            return "{}";
        }
        if (indentFactor == 0) {
            return this.toString();
        }
        Iterator keys = this.keys();
        StringBuffer sb = new StringBuffer("{");
        int newindent = indent + indentFactor;
        if (n == 1) {
            Object o = keys.next();
            sb.append(JSONUtils.quote(o.toString()));
            sb.append(": ");
            sb.append(JSONUtils.valueToString(this.properties.get(o), indentFactor, indent));
        } else {
            int i;
            while (keys.hasNext()) {
                Object o = keys.next();
                if (sb.length() > 1) {
                    sb.append(",\n");
                } else {
                    sb.append('\n');
                }
                for (i = 0; i < newindent; ++i) {
                    sb.append(' ');
                }
                sb.append(JSONUtils.quote(o.toString()));
                sb.append(": ");
                sb.append(JSONUtils.valueToString(this.properties.get(o), indentFactor, newindent));
            }
            if (sb.length() > 1) {
                sb.append('\n');
                for (i = 0; i < indent; ++i) {
                    sb.append(' ');
                }
            }
            for (i = 0; i < indent; ++i) {
                sb.insert(0, ' ');
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public Collection values() {
        return Collections.unmodifiableCollection(this.properties.values());
    }

    public Writer write(Writer writer) {
        try {
            if (this.isNullObject()) {
                writer.write(JSONNull.getInstance().toString());
                return writer;
            }
            boolean b = false;
            Iterator keys = this.keys();
            writer.write(123);
            while (keys.hasNext()) {
                if (b) {
                    writer.write(44);
                }
                Object k = keys.next();
                writer.write(JSONUtils.quote(k.toString()));
                writer.write(58);
                Object v = this.properties.get(k);
                if (v instanceof JSONObject) {
                    ((JSONObject)v).write(writer);
                } else if (v instanceof JSONArray) {
                    ((JSONArray)v).write(writer);
                } else {
                    writer.write(JSONUtils.valueToString(v));
                }
                b = true;
            }
            writer.write(125);
            return writer;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }

    private JSONObject _accumulate(String key, Object value, JsonConfig jsonConfig) {
        if (this.isNullObject()) {
            throw new JSONException("Can't accumulate on null object");
        }
        if (!this.has(key)) {
            this.setInternal(key, value, jsonConfig);
        } else {
            Object o = this.opt(key);
            if (o instanceof JSONArray) {
                ((JSONArray)o).element(value, jsonConfig);
            } else {
                this.setInternal(key, new JSONArray().element(o).element(value, jsonConfig), jsonConfig);
            }
        }
        return this;
    }

    protected Object _processValue(Object value, JsonConfig jsonConfig) {
        if (value instanceof JSONTokener) {
            return JSONObject._fromJSONTokener((JSONTokener)value, jsonConfig);
        }
        if (value != null && Enum.class.isAssignableFrom(value.getClass())) {
            return ((Enum)value).name();
        }
        return super._processValue(value, jsonConfig);
    }

    private JSONObject _setInternal(String key, Object value, JsonConfig jsonConfig) {
        this.verifyIsNull();
        if (key == null) {
            throw new JSONException("Null key.");
        }
        if (JSONUtils.isString(value) && JSONUtils.mayBeJSON(String.valueOf(value))) {
            this.properties.put(key, value);
        } else if (CycleDetectionStrategy.IGNORE_PROPERTY_OBJ != value && CycleDetectionStrategy.IGNORE_PROPERTY_ARR != value) {
            this.properties.put(key, value);
        }
        return this;
    }

    private Object processValue(Object value, JsonConfig jsonConfig) {
        JsonValueProcessor processor;
        if (value != null && (processor = jsonConfig.findJsonValueProcessor(value.getClass())) != null && !JsonVerifier.isValidJsonValue(value = processor.processObjectValue(null, value, jsonConfig))) {
            throw new JSONException("Value is not a valid JSON value. " + value);
        }
        return this._processValue(value, jsonConfig);
    }

    private Object processValue(String key, Object value, JsonConfig jsonConfig) {
        JsonValueProcessor processor;
        if (value != null && (processor = jsonConfig.findJsonValueProcessor(value.getClass(), key)) != null && !JsonVerifier.isValidJsonValue(value = processor.processObjectValue(null, value, jsonConfig))) {
            throw new JSONException("Value is not a valid JSON value. " + value);
        }
        return this._processValue(value, jsonConfig);
    }

    private JSONObject setInternal(String key, Object value, JsonConfig jsonConfig) {
        return this._setInternal(key, this.processValue(key, value, jsonConfig), jsonConfig);
    }

    private void verifyIsNull() {
        if (this.isNullObject()) {
            throw new JSONException("null object");
        }
    }
}

