/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlrpc;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.xmlrpc.XmlRpcRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlRpcAsyncCallback
implements org.apache.xmlrpc.client.AsyncCallback {
    private static final Logger LOG = LoggerFactory.getLogger(XmlRpcAsyncCallback.class);
    private final AsyncCallback camelAsyncCallback;
    private final Exchange camelExchange;

    public XmlRpcAsyncCallback(Exchange exchange, AsyncCallback callback) {
        this.camelAsyncCallback = callback;
        this.camelExchange = exchange;
    }

    @Override
    public void handleResult(XmlRpcRequest pRequest, Object pResult) {
        LOG.trace("Get the response {}", pResult);
        this.camelExchange.getOut().setHeaders(this.camelExchange.getIn().getHeaders());
        this.camelExchange.getOut().setBody(pResult);
        this.camelAsyncCallback.done(false);
    }

    @Override
    public void handleError(XmlRpcRequest pRequest, Throwable pError) {
        LOG.trace("Get the Error {}", pError);
        this.camelExchange.setException(pError);
        this.camelAsyncCallback.done(false);
    }
}

