/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.xmlrpc;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.apache.camel.Exchange;
import org.apache.camel.component.xmlrpc.XmlRpcRequestImpl;
import org.apache.camel.dataformat.xmlrpc.XmlRpcWriter;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.ws.commons.serialize.CharSetXMLWriter;
import org.apache.ws.commons.serialize.XMLWriter;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.common.TypeFactory;
import org.apache.xmlrpc.common.TypeFactoryImpl;
import org.apache.xmlrpc.common.XmlRpcHttpRequestConfigImpl;
import org.apache.xmlrpc.common.XmlRpcStreamRequestConfig;
import org.apache.xmlrpc.parser.XmlRpcRequestParser;
import org.apache.xmlrpc.parser.XmlRpcResponseParser;
import org.apache.xmlrpc.util.SAXParsers;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XmlRpcDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private XmlRpcStreamRequestConfig xmlRpcStreamRequestConfig = new XmlRpcHttpRequestConfigImpl();
    private TypeFactory typeFactory = new TypeFactoryImpl(null);
    private boolean isRequest;

    protected XMLWriter getXMLWriter(Exchange exchange, OutputStream outputStream) throws XmlRpcException {
        CharSetXMLWriter writer = new CharSetXMLWriter();
        String encoding = IOHelper.getCharsetName((Exchange)exchange);
        writer.setEncoding(encoding);
        writer.setIndenting(false);
        writer.setFlushing(true);
        try {
            writer.setWriter(new BufferedWriter(new OutputStreamWriter(outputStream, encoding)));
        }
        catch (UnsupportedEncodingException e) {
            throw new XmlRpcException("Unsupported encoding: " + encoding, e);
        }
        return writer;
    }

    public String getDataFormatName() {
        return "xmlrpc";
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        XMLWriter control = this.getXMLWriter(exchange, stream);
        XmlRpcWriter writer = new XmlRpcWriter(this.xmlRpcStreamRequestConfig, control, this.typeFactory);
        XmlRpcRequest request = null;
        if (this.isRequest || graph instanceof XmlRpcRequest) {
            request = (XmlRpcRequest)exchange.getContext().getTypeConverter().mandatoryConvertTo(XmlRpcRequest.class, exchange, graph);
        }
        if (request != null) {
            writer.writeRequest(this.xmlRpcStreamRequestConfig, request);
        } else {
            writer.write(this.xmlRpcStreamRequestConfig, graph);
        }
    }

    protected int getErrorCode(Exchange exchange) {
        return (Integer)exchange.getIn().getHeader("CamelXmlRpcErrorCode", Integer.TYPE);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        if (this.isRequest) {
            return this.unmarshalRequest(exchange, stream);
        }
        return this.unmarshalResponse(exchange, stream);
    }

    protected Object unmarshalResponse(Exchange exchange, InputStream stream) throws Exception {
        XmlRpcResponseParser xp;
        InputSource isource = new InputSource(stream);
        XMLReader xr = this.newXMLReader();
        try {
            xp = new XmlRpcResponseParser(this.xmlRpcStreamRequestConfig, this.typeFactory);
            xr.setContentHandler(xp);
            xr.parse(isource);
        }
        catch (SAXException e) {
            throw new XmlRpcClientException("Failed to parse server's response: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XmlRpcClientException("Failed to read server's response: " + e.getMessage(), e);
        }
        if (xp.isSuccess()) {
            return xp.getResult();
        }
        Throwable t = xp.getErrorCause();
        if (t == null) {
            throw new XmlRpcException(xp.getErrorCode(), xp.getErrorMessage());
        }
        if (t instanceof XmlRpcException) {
            throw (XmlRpcException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new XmlRpcException(xp.getErrorCode(), xp.getErrorMessage(), t);
    }

    protected Object unmarshalRequest(Exchange exchange, InputStream stream) throws Exception {
        XmlRpcRequestParser xp;
        InputSource isource = new InputSource(stream);
        XMLReader xr = this.newXMLReader();
        try {
            xp = new XmlRpcRequestParser(this.xmlRpcStreamRequestConfig, this.typeFactory);
            xr.setContentHandler(xp);
            xr.parse(isource);
        }
        catch (SAXException e) {
            throw new XmlRpcClientException("Failed to parse server's response: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XmlRpcClientException("Failed to read server's response: " + e.getMessage(), e);
        }
        return new XmlRpcRequestImpl(xp.getMethodName(), xp.getParams());
    }

    protected XMLReader newXMLReader() throws XmlRpcException {
        return SAXParsers.newXMLReader();
    }

    public boolean isRequest() {
        return this.isRequest;
    }

    public void setRequest(boolean isRequest) {
        this.isRequest = isRequest;
    }

    public void setXmlRpcStreamRequestConfig(XmlRpcStreamRequestConfig config) {
        this.xmlRpcStreamRequestConfig = config;
    }

    public XmlRpcStreamRequestConfig getXmlRpcStreamRequestConfig() {
        return this.xmlRpcStreamRequestConfig;
    }

    public void setTypeFactory(TypeFactory typeFactory) {
        this.typeFactory = typeFactory;
    }

    public TypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

