/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity.api;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.spec.ExcC14NParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilter2ParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.crypto.dsig.spec.XPathType;
import javax.xml.crypto.dsig.spec.XSLTTransformParameterSpec;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureTransform;
import org.apache.camel.util.IOHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public final class XmlSignatureHelper {
    private XmlSignatureHelper() {
    }

    public static AlgorithmMethod getCanonicalizationMethod(String algorithm) {
        return XmlSignatureHelper.getCanonicalizationMethod(algorithm, null);
    }

    public static AlgorithmMethod getCanonicalizationMethod(String algorithm, List<String> inclusiveNamespacePrefixes) {
        if (algorithm == null) {
            throw new IllegalArgumentException("algorithm is null");
        }
        XmlSignatureTransform canonicalizationMethod = new XmlSignatureTransform(algorithm);
        if (inclusiveNamespacePrefixes != null) {
            ExcC14NParameterSpec parameters = new ExcC14NParameterSpec(inclusiveNamespacePrefixes);
            canonicalizationMethod.setParameterSpec(parameters);
        }
        return canonicalizationMethod;
    }

    public static AlgorithmMethod getEnvelopedTransform() {
        return new XmlSignatureTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
    }

    public static AlgorithmMethod getBase64Transform() {
        return new XmlSignatureTransform("http://www.w3.org/2000/09/xmldsig#base64");
    }

    public static AlgorithmMethod getXPathTransform(String xpath) {
        return XmlSignatureHelper.getXPathTransform(xpath, null);
    }

    public static AlgorithmMethod getXPathTransform(String xpath, Map<String, String> namespaceMap) {
        if (xpath == null) {
            throw new IllegalArgumentException("xpath is null");
        }
        XmlSignatureTransform transformXPath = new XmlSignatureTransform();
        transformXPath.setAlgorithm("http://www.w3.org/TR/1999/REC-xpath-19991116");
        XPathFilterParameterSpec params = XmlSignatureHelper.getXpathFilter(xpath, namespaceMap);
        transformXPath.setParameterSpec(params);
        return transformXPath;
    }

    public static XPathFilterParameterSpec getXpathFilter(String xpath, Map<String, String> namespaceMap) {
        XPathFilterParameterSpec params = namespaceMap == null ? new XPathFilterParameterSpec(xpath) : new XPathFilterParameterSpec(xpath, namespaceMap);
        return params;
    }

    public static XPathFilterParameterSpec getXpathFilter(String xpath) {
        return XmlSignatureHelper.getXpathFilter(xpath, null);
    }

    public static XPathExpression getXPathExpression(XPathFilterParameterSpec xpathFilter) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        if (xpathFilter.getNamespaceMap() != null) {
            xpath.setNamespaceContext(new XPathNamespaceContext(xpathFilter.getNamespaceMap()));
        }
        return xpath.compile(xpathFilter.getXPath());
    }

    public static AlgorithmMethod getXPath2Transform(String xpath, String filter) {
        return XmlSignatureHelper.getXPath2Transform(xpath, filter, null);
    }

    public static AlgorithmMethod getXPath2Transform(String xpath, String filter, Map<String, String> namespaceMap) {
        XPathAndFilter xpathAndFilter = new XPathAndFilter();
        xpathAndFilter.setXpath(xpath);
        xpathAndFilter.setFilter(filter);
        ArrayList<XPathAndFilter> list = new ArrayList<XPathAndFilter>(1);
        list.add(xpathAndFilter);
        return XmlSignatureHelper.getXPath2Transform(list, namespaceMap);
    }

    public static AlgorithmMethod getXPath2Transform(List<XPathAndFilter> xpathAndFilterList, Map<String, String> namespaceMap) {
        if (xpathAndFilterList == null) {
            throw new IllegalArgumentException("xpathAndFilterList is null");
        }
        if (xpathAndFilterList.isEmpty()) {
            throw new IllegalArgumentException("XPath and filter list is empty");
        }
        List<XPathType> list = XmlSignatureHelper.getXPathTypeList(xpathAndFilterList, namespaceMap);
        XmlSignatureTransform transformXPath = new XmlSignatureTransform("http://www.w3.org/2002/06/xmldsig-filter2");
        transformXPath.setParameterSpec(new XPathFilter2ParameterSpec(list));
        return transformXPath;
    }

    private static List<XPathType> getXPathTypeList(List<XPathAndFilter> xpathAndFilterList, Map<String, String> namespaceMap) {
        ArrayList<XPathType> list = new ArrayList<XPathType>(xpathAndFilterList.size());
        for (XPathAndFilter xpathAndFilter : xpathAndFilterList) {
            XPathType.Filter xpathFilter;
            if (XPathType.Filter.INTERSECT.toString().equals(xpathAndFilter.getFilter())) {
                xpathFilter = XPathType.Filter.INTERSECT;
            } else if (XPathType.Filter.SUBTRACT.toString().equals(xpathAndFilter.getFilter())) {
                xpathFilter = XPathType.Filter.SUBTRACT;
            } else if (XPathType.Filter.UNION.toString().equals(xpathAndFilter.getFilter())) {
                xpathFilter = XPathType.Filter.UNION;
            } else {
                throw new IllegalStateException(String.format("XPATH %s has a filter %s not supported", xpathAndFilter.getXpath(), xpathAndFilter.getFilter()));
            }
            XPathType xpathtype = namespaceMap == null ? new XPathType(xpathAndFilter.getXpath(), xpathFilter) : new XPathType(xpathAndFilter.getXpath(), xpathFilter, namespaceMap);
            list.add(xpathtype);
        }
        return list;
    }

    public static AlgorithmMethod getXPath2Transform(List<XPathAndFilter> xpathAndFilterList) {
        return XmlSignatureHelper.getXPath2Transform(xpathAndFilterList, null);
    }

    public static AlgorithmMethod getXslTransform(String path) throws Exception {
        InputStream is = XmlSignatureHelper.readXslTransform(path);
        if (is == null) {
            throw new IllegalStateException(String.format("XSL file %s not found", path));
        }
        try {
            AlgorithmMethod algorithmMethod = XmlSignatureHelper.getXslTranform(is);
            return algorithmMethod;
        }
        finally {
            IOHelper.close((Closeable)is);
        }
    }

    public static AlgorithmMethod getXslTranform(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        if (is == null) {
            throw new IllegalArgumentException("is must not be null");
        }
        Document doc = XmlSignatureHelper.parseInput(is);
        DOMStructure stylesheet = new DOMStructure(doc.getDocumentElement());
        XSLTTransformParameterSpec spec = new XSLTTransformParameterSpec(stylesheet);
        XmlSignatureTransform transformXslt = new XmlSignatureTransform();
        transformXslt.setAlgorithm("http://www.w3.org/TR/1999/REC-xslt-19991116");
        transformXslt.setParameterSpec(spec);
        return transformXslt;
    }

    protected static InputStream readXslTransform(String path) throws Exception {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        return XmlSignatureHelper.class.getResourceAsStream(path);
    }

    public static List<AlgorithmMethod> getTransforms(List<AlgorithmMethod> list) {
        return list;
    }

    private static Document parseInput(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        return XmlSignatureHelper.newDocumentBuilder(Boolean.TRUE).parse(is);
    }

    public static List<Node> getTextAndElementChildren(Node node) {
        LinkedList<Node> result = new LinkedList<Node>();
        NodeList children = node.getChildNodes();
        if (children == null) {
            return result;
        }
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (1 != child.getNodeType() && 3 != child.getNodeType()) continue;
            result.add(child);
        }
        return result;
    }

    public static DocumentBuilder newDocumentBuilder(Boolean disallowDoctypeDecl) throws ParserConfigurationException {
        return XmlSignatureHelper.newDocumentBuilder(disallowDoctypeDecl, null);
    }

    public static DocumentBuilder newDocumentBuilder(Boolean disallowDoctypeDecl, Schema schema) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        boolean isDissalowDoctypeDecl = disallowDoctypeDecl == null ? true : disallowDoctypeDecl;
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", isDissalowDoctypeDecl);
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        if (schema != null) {
            dbf.setSchema(schema);
        }
        return dbf.newDocumentBuilder();
    }

    public static void transformToOutputStream(Node node, OutputStream os, boolean omitXmlDeclaration, String encoding) throws Exception {
        if (node.getNodeType() == 3) {
            byte[] bytes = XmlSignatureHelper.tranformTextNodeToByteArray(node, encoding);
            os.write(bytes);
        } else {
            XmlSignatureHelper.transformNonTextNodeToOutputStream(node, os, omitXmlDeclaration, encoding);
        }
    }

    @Deprecated
    public static void transformToOutputStream(Node node, OutputStream os, boolean omitXmlDeclaration) throws Exception {
        if (node.getNodeType() == 3) {
            byte[] bytes = XmlSignatureHelper.tranformTextNodeToByteArray(node);
            os.write(bytes);
        } else {
            XmlSignatureHelper.transformNonTextNodeToOutputStream(node, os, omitXmlDeclaration);
        }
    }

    @Deprecated
    public static void transformNonTextNodeToOutputStream(Node node, OutputStream os, boolean omitXmlDeclaration) throws Exception {
        XmlSignatureHelper.transformNonTextNodeToOutputStream(node, os, omitXmlDeclaration, null);
    }

    public static void transformNonTextNodeToOutputStream(Node node, OutputStream os, boolean omitXmlDeclaration, String encoding) throws Exception {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        DOMImplementationRegistry domImplementationRegistry = DOMImplementationRegistry.newInstance();
        DOMImplementationLS domImplementationLS = (DOMImplementationLS)((Object)domImplementationRegistry.getDOMImplementation("LS"));
        LSOutput lsOutput = domImplementationLS.createLSOutput();
        lsOutput.setEncoding(encoding);
        lsOutput.setByteStream(os);
        LSSerializer lss = domImplementationLS.createLSSerializer();
        lss.getDomConfig().setParameter("xml-declaration", !omitXmlDeclaration);
        lss.write(node, lsOutput);
    }

    @Deprecated
    public static byte[] tranformTextNodeToByteArray(Node node) {
        return XmlSignatureHelper.tranformTextNodeToByteArray(node, null);
    }

    public static byte[] tranformTextNodeToByteArray(Node node, String encoding) {
        String text;
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if ((text = node.getTextContent()) != null) {
            try {
                return text.getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    public static Document getDocument(Node node) {
        if (node.getNodeType() == 9) {
            return (Document)node;
        }
        return node.getOwnerDocument();
    }

    public static class XPathAndFilter {
        private String xpath;
        private String filter;

        public XPathAndFilter(String xpath, String filter) {
            this.xpath = xpath;
            this.filter = filter;
        }

        public XPathAndFilter() {
        }

        public String getXpath() {
            return this.xpath;
        }

        public void setXpath(String xpath) {
            this.xpath = xpath;
        }

        public String getFilter() {
            return this.filter;
        }

        public void setFilter(String filter) {
            this.filter = filter;
        }
    }

    private static class XPathNamespaceContext
    implements NamespaceContext {
        private final Map<String, String> prefix2Namespace;

        XPathNamespaceContext(Map<String, String> prefix2Namespace) {
            this.prefix2Namespace = prefix2Namespace;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix == null) {
                throw new NullPointerException("Null prefix");
            }
            if ("xml".equals(prefix)) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            String ns = this.prefix2Namespace.get(prefix);
            if (ns != null) {
                return ns;
            }
            return "";
        }

        @Override
        public String getPrefix(String uri) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator getPrefixes(String uri) {
            throw new UnsupportedOperationException();
        }
    }
}

