/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jivesoftware.smack.RosterStore;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.util.DNSUtil;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.dns.HostAddress;

public class ConnectionConfiguration
implements Cloneable {
    private String serviceName;
    protected List<HostAddress> hostAddresses;
    private String keystorePath;
    private String keystoreType;
    private String pkcs11Library;
    private SSLContext customSSLContext;
    private boolean compressionEnabled = false;
    private CallbackHandler callbackHandler;
    private boolean debuggerEnabled = SmackConfiguration.DEBUG_ENABLED;
    private boolean reconnectionAllowed = true;
    private SocketFactory socketFactory;
    private String username;
    private String password;
    private String resource;
    private boolean sendPresence = true;
    private boolean rosterLoadedAtLogin = true;
    private boolean legacySessionDisabled = false;
    private boolean useDnsSrvRr = true;
    private SecurityMode securityMode = SecurityMode.enabled;
    private HostnameVerifier hostnameVerifier;
    private RosterStore rosterStore;
    protected ProxyInfo proxy;

    public ConnectionConfiguration(String serviceName) {
        this.init(serviceName, ProxyInfo.forDefaultProxy());
    }

    public ConnectionConfiguration(String serviceName, ProxyInfo proxy) {
        this.init(serviceName, proxy);
    }

    public ConnectionConfiguration(String host, int port, String serviceName) {
        this.initHostAddresses(host, port);
        this.init(serviceName, ProxyInfo.forDefaultProxy());
    }

    public ConnectionConfiguration(String host, int port, String serviceName, ProxyInfo proxy) {
        this.initHostAddresses(host, port);
        this.init(serviceName, proxy);
    }

    public ConnectionConfiguration(String host, int port) {
        this.initHostAddresses(host, port);
        this.init(host, ProxyInfo.forDefaultProxy());
    }

    public ConnectionConfiguration(String host, int port, ProxyInfo proxy) {
        this.initHostAddresses(host, port);
        this.init(host, proxy);
    }

    protected void init(String serviceName, ProxyInfo proxy) {
        if (StringUtils.isEmpty(serviceName)) {
            throw new IllegalArgumentException("serviceName must not be the empty String");
        }
        this.serviceName = serviceName;
        this.proxy = proxy;
        this.keystorePath = System.getProperty("javax.net.ssl.keyStore");
        this.keystoreType = "jks";
        this.pkcs11Library = "pkcs11.config";
        this.socketFactory = proxy.getSocketFactory();
    }

    void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public SecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public void setSecurityMode(SecurityMode securityMode) {
        this.securityMode = securityMode;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public void setKeystorePath(String keystorePath) {
        this.keystorePath = keystorePath;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public String getPKCS11Library() {
        return this.pkcs11Library;
    }

    public void setPKCS11Library(String pkcs11Library) {
        this.pkcs11Library = pkcs11Library;
    }

    public SSLContext getCustomSSLContext() {
        return this.customSSLContext;
    }

    public void setCustomSSLContext(SSLContext context) {
        this.customSSLContext = context;
    }

    public void setHostnameVerifier(HostnameVerifier verifier) {
        this.hostnameVerifier = verifier;
    }

    public HostnameVerifier getHostnameVerifier() {
        if (this.hostnameVerifier != null) {
            return this.hostnameVerifier;
        }
        return SmackConfiguration.getDefaultHostnameVerifier();
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public void setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
    }

    public boolean isDebuggerEnabled() {
        return this.debuggerEnabled;
    }

    public void setDebuggerEnabled(boolean debuggerEnabled) {
        this.debuggerEnabled = debuggerEnabled;
    }

    public void setReconnectionAllowed(boolean isAllowed) {
        this.reconnectionAllowed = isAllowed;
    }

    public boolean isReconnectionAllowed() {
        return this.reconnectionAllowed;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public void setSendPresence(boolean sendPresence) {
        this.sendPresence = sendPresence;
    }

    public boolean isRosterLoadedAtLogin() {
        return this.rosterLoadedAtLogin;
    }

    public void setRosterLoadedAtLogin(boolean rosterLoadedAtLogin) {
        this.rosterLoadedAtLogin = rosterLoadedAtLogin;
    }

    public boolean isLegacySessionDisabled() {
        return this.legacySessionDisabled;
    }

    public void setLegacySessionDisabled(boolean legacySessionDisabled) {
        this.legacySessionDisabled = legacySessionDisabled;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public List<HostAddress> getHostAddresses() {
        return Collections.unmodifiableList(this.hostAddresses);
    }

    public void setRosterStore(RosterStore store) {
        this.rosterStore = store;
    }

    public RosterStore getRosterStore() {
        return this.rosterStore;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getResource() {
        return this.resource;
    }

    public boolean isSendPresence() {
        return this.sendPresence;
    }

    void setLoginInfo(String username, String password, String resource) {
        this.username = username;
        this.password = password;
        this.resource = resource;
    }

    void maybeResolveDns() throws Exception {
        if (!this.useDnsSrvRr) {
            return;
        }
        this.hostAddresses = DNSUtil.resolveXMPPDomain(this.serviceName);
    }

    private void initHostAddresses(String host, int port) {
        if (StringUtils.isEmpty(host)) {
            throw new IllegalArgumentException("host must not be the empty String");
        }
        this.hostAddresses = new ArrayList<HostAddress>(1);
        HostAddress hostAddress = new HostAddress(host, port);
        this.hostAddresses.add(hostAddress);
        this.useDnsSrvRr = false;
    }

    public static enum SecurityMode {
        required,
        enabled,
        disabled;

    }
}

