/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp;

import java.io.IOException;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.parsing.ParsingExceptionCallback;
import org.jivesoftware.smack.parsing.UnparsablePacket;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class PacketReader {
    private Thread readerThread;
    private XMPPTCPConnection connection;
    private XmlPullParser parser;
    private volatile boolean lastFeaturesParsed;
    volatile boolean done;

    protected PacketReader(XMPPTCPConnection connection) throws SmackException {
        this.connection = connection;
        this.init();
    }

    protected void init() throws SmackException {
        this.done = false;
        this.lastFeaturesParsed = false;
        this.readerThread = new Thread(){

            @Override
            public void run() {
                PacketReader.this.parsePackets(this);
            }
        };
        this.readerThread.setName("Smack Packet Reader (" + this.connection.getConnectionCounter() + ")");
        this.readerThread.setDaemon(true);
        this.resetParser();
    }

    public synchronized void startup() throws SmackException.NoResponseException, IOException {
        this.readerThread.start();
        try {
            this.wait(this.connection.getPacketReplyTimeout());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.lastFeaturesParsed) {
            this.connection.throwConnectionExceptionOrNoResponse();
        }
    }

    public void shutdown() {
        this.done = true;
    }

    private void resetParser() throws SmackException {
        try {
            this.parser = PacketParserUtils.newXmppParser();
            this.parser.setInput(this.connection.getReader());
        }
        catch (XmlPullParserException e) {
            throw new SmackException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePackets(Thread thread) {
        block43: {
            try {
                int eventType = this.parser.getEventType();
                do {
                    if (eventType == 2) {
                        UnparsablePacket message;
                        String content;
                        int parserDepth = this.parser.getDepth();
                        ParsingExceptionCallback callback = this.connection.getParsingExceptionCallback();
                        if (this.parser.getName().equals("message")) {
                            Message packet;
                            try {
                                packet = PacketParserUtils.parseMessage(this.parser);
                            }
                            catch (Exception e) {
                                content = PacketParserUtils.parseContentDepth(this.parser, parserDepth);
                                message = new UnparsablePacket(content, e);
                                if (callback != null) {
                                    callback.handleUnparsablePacket(message);
                                }
                                eventType = this.parser.next();
                                continue;
                            }
                            this.connection.processPacket(packet);
                        } else if (this.parser.getName().equals("iq")) {
                            IQ iq;
                            try {
                                iq = PacketParserUtils.parseIQ(this.parser, this.connection);
                            }
                            catch (Exception e) {
                                content = PacketParserUtils.parseContentDepth(this.parser, parserDepth);
                                message = new UnparsablePacket(content, e);
                                if (callback != null) {
                                    callback.handleUnparsablePacket(message);
                                }
                                eventType = this.parser.next();
                                continue;
                            }
                            this.connection.processPacket(iq);
                        } else if (this.parser.getName().equals("presence")) {
                            Presence presence;
                            try {
                                presence = PacketParserUtils.parsePresence(this.parser);
                            }
                            catch (Exception e) {
                                content = PacketParserUtils.parseContentDepth(this.parser, parserDepth);
                                message = new UnparsablePacket(content, e);
                                if (callback != null) {
                                    callback.handleUnparsablePacket(message);
                                }
                                eventType = this.parser.next();
                                continue;
                            }
                            this.connection.processPacket(presence);
                        } else if (this.parser.getName().equals("stream")) {
                            if ("jabber:client".equals(this.parser.getNamespace(null))) {
                                for (int i = 0; i < this.parser.getAttributeCount(); ++i) {
                                    if (!this.parser.getAttributeName(i).equals("id")) continue;
                                    this.connection.connectionID = this.parser.getAttributeValue(i);
                                }
                            }
                        } else {
                            if (this.parser.getName().equals("error")) {
                                throw new XMPPException.StreamErrorException(PacketParserUtils.parseStreamError(this.parser));
                            }
                            if (this.parser.getName().equals("features")) {
                                this.parseFeatures(this.parser);
                            } else if (this.parser.getName().equals("proceed")) {
                                this.connection.proceedTLSReceived();
                                this.resetParser();
                            } else if (this.parser.getName().equals("failure")) {
                                String namespace = this.parser.getNamespace(null);
                                if ("urn:ietf:params:xml:ns:xmpp-tls".equals(namespace)) {
                                    throw new Exception("TLS negotiation has failed");
                                }
                                if ("http://jabber.org/protocol/compress".equals(namespace)) {
                                    this.connection.streamCompressionNegotiationDone();
                                } else {
                                    SASLMechanism.SASLFailure failure = PacketParserUtils.parseSASLFailure(this.parser);
                                    this.connection.processPacket(failure);
                                    this.connection.getSASLAuthentication().authenticationFailed(failure);
                                }
                            } else if (this.parser.getName().equals("challenge")) {
                                String challengeData = this.parser.nextText();
                                this.connection.processPacket(new SASLMechanism.Challenge(challengeData));
                                this.connection.getSASLAuthentication().challengeReceived(challengeData);
                            } else if (this.parser.getName().equals("success")) {
                                this.connection.processPacket(new SASLMechanism.Success(this.parser.nextText()));
                                this.connection.packetWriter.openStream();
                                this.resetParser();
                                this.connection.getSASLAuthentication().authenticated();
                            } else if (this.parser.getName().equals("compressed")) {
                                this.connection.startStreamCompression();
                                this.resetParser();
                            }
                        }
                    } else if (eventType == 3 && this.parser.getName().equals("stream")) {
                        this.connection.disconnect();
                    }
                    eventType = this.parser.next();
                } while (!this.done && eventType != 1 && thread == this.readerThread);
            }
            catch (Exception e) {
                if (this.done || this.connection.isSocketClosed()) break block43;
                PacketReader packetReader = this;
                synchronized (packetReader) {
                    this.notify();
                }
                this.connection.notifyConnectionError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFeatures(XmlPullParser parser) throws Exception {
        boolean startTLSReceived = false;
        boolean startTLSRequired = false;
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("starttls")) {
                    startTLSReceived = true;
                    continue;
                }
                if (parser.getName().equals("mechanisms")) {
                    this.connection.getSASLAuthentication().setAvailableSASLMethods(PacketParserUtils.parseMechanisms(parser));
                    continue;
                }
                if (parser.getName().equals("bind")) {
                    this.connection.serverRequiresBinding();
                    continue;
                }
                if (parser.getName().equals("c")) {
                    String node = parser.getAttributeValue(null, "node");
                    String ver = parser.getAttributeValue(null, "ver");
                    if (ver == null || node == null) continue;
                    String capsNode = node + "#" + ver;
                    this.connection.setServiceCapsNode(capsNode);
                    continue;
                }
                if (parser.getName().equals("session")) {
                    this.connection.serverSupportsSession();
                    continue;
                }
                if (parser.getName().equals("ver")) {
                    if (!parser.getNamespace().equals("urn:xmpp:features:rosterver")) continue;
                    this.connection.setRosterVersioningSupported();
                    continue;
                }
                if (parser.getName().equals("compression")) {
                    this.connection.setAvailableCompressionMethods(PacketParserUtils.parseCompressionMethods(parser));
                    continue;
                }
                if (!parser.getName().equals("register")) continue;
                this.connection.serverSupportsAccountCreation();
                continue;
            }
            if (eventType != 3) continue;
            if (parser.getName().equals("starttls")) {
                this.connection.startTLSReceived(startTLSRequired);
                continue;
            }
            if (parser.getName().equals("required") && startTLSReceived) {
                startTLSRequired = true;
                continue;
            }
            if (!parser.getName().equals("features")) continue;
            done = true;
        }
        if (!this.connection.isSecureConnection() && !startTLSReceived && this.connection.getConfiguration().getSecurityMode() == ConnectionConfiguration.SecurityMode.required) {
            throw new SmackException.SecurityRequiredException();
        }
        if (!startTLSReceived || this.connection.getConfiguration().getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
            this.lastFeaturesParsed = true;
            PacketReader packetReader = this;
            synchronized (packetReader) {
                this.notify();
            }
        }
    }
}

