/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.util.dns.DNSResolver;
import org.jivesoftware.smack.util.dns.HostAddress;
import org.jivesoftware.smack.util.dns.SRVRecord;

public class DNSUtil {
    private static final Logger LOGGER = Logger.getLogger(DNSUtil.class.getName());
    private static DNSResolver dnsResolver = null;

    public static void init() {
        String[] RESOLVERS;
        for (String resolver : RESOLVERS = new String[]{"javax.JavaxResolver", "minidns.MiniDnsResolver", "dnsjava.DNSJavaResolver"}) {
            DNSResolver availableResolver = null;
            String resolverFull = "org.jivesoftware.smack.util.dns." + resolver;
            try {
                Class<?> resolverClass = Class.forName(resolverFull);
                Method getInstanceMethod = resolverClass.getMethod("getInstance", new Class[0]);
                availableResolver = (DNSResolver)getInstanceMethod.invoke(null, new Object[0]);
                if (availableResolver == null) continue;
                DNSUtil.setDNSResolver(availableResolver);
                break;
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOGGER.log(Level.FINE, "Exception on init", e);
            }
        }
    }

    public static void setDNSResolver(DNSResolver resolver) {
        dnsResolver = resolver;
    }

    public static DNSResolver getDNSResolver() {
        return dnsResolver;
    }

    public static List<HostAddress> resolveXMPPDomain(String domain) {
        if (dnsResolver == null) {
            ArrayList<HostAddress> addresses = new ArrayList<HostAddress>(1);
            addresses.add(new HostAddress(domain, 5222));
            return addresses;
        }
        return DNSUtil.resolveDomain(domain, 'c');
    }

    public static List<HostAddress> resolveXMPPServerDomain(String domain) {
        if (dnsResolver == null) {
            ArrayList<HostAddress> addresses = new ArrayList<HostAddress>(1);
            addresses.add(new HostAddress(domain, 5269));
            return addresses;
        }
        return DNSUtil.resolveDomain(domain, 's');
    }

    private static List<HostAddress> resolveDomain(String domain, char keyPrefix) {
        ArrayList<HostAddress> addresses = new ArrayList<HostAddress>();
        String srvDomain = keyPrefix == 's' ? "_xmpp-server._tcp." + domain : (keyPrefix == 'c' ? "_xmpp-client._tcp." + domain : domain);
        try {
            List<SRVRecord> srvRecords = dnsResolver.lookupSRVRecords(srvDomain);
            if (LOGGER.isLoggable(Level.FINE)) {
                String logMessage = "Resolved SRV RR for " + srvDomain + ":";
                for (SRVRecord r : srvRecords) {
                    logMessage = logMessage + " " + r;
                }
                LOGGER.fine(logMessage);
            }
            List<HostAddress> sortedRecords = DNSUtil.sortSRVRecords(srvRecords);
            addresses.addAll(sortedRecords);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Exception while resovling SRV records for " + domain + ". Consider adding '_xmpp-(server|client)._tcp' DNS SRV Records");
        }
        addresses.add(new HostAddress(domain));
        return addresses;
    }

    private static List<HostAddress> sortSRVRecords(List<SRVRecord> records) {
        List bucket;
        if (records.size() == 1 && records.get(0).getFQDN().equals(".")) {
            return Collections.emptyList();
        }
        Collections.sort(records);
        TreeMap<Integer, LinkedList<SRVRecord>> buckets = new TreeMap<Integer, LinkedList<SRVRecord>>();
        for (SRVRecord r : records) {
            Integer priority = r.getPriority();
            bucket = (LinkedList<SRVRecord>)buckets.get(priority);
            if (bucket == null) {
                bucket = new LinkedList<SRVRecord>();
                buckets.put(priority, (LinkedList<SRVRecord>)bucket);
            }
            bucket.add(r);
        }
        ArrayList<HostAddress> res = new ArrayList<HostAddress>(records.size());
        for (Integer priority : buckets.keySet()) {
            int bucketSize;
            bucket = (List)buckets.get(priority);
            while ((bucketSize = bucket.size()) > 0) {
                int selectedPos;
                int[] totals = new int[bucket.size()];
                int running_total = 0;
                int count = 0;
                int zeroWeight = 1;
                for (SRVRecord r : bucket) {
                    if (r.getWeight() <= 0) continue;
                    zeroWeight = 0;
                }
                for (SRVRecord r : bucket) {
                    totals[count] = running_total += r.getWeight() + zeroWeight;
                    ++count;
                }
                if (running_total == 0) {
                    selectedPos = (int)(Math.random() * (double)bucketSize);
                } else {
                    double rnd = Math.random() * (double)running_total;
                    selectedPos = DNSUtil.bisect(totals, rnd);
                }
                SRVRecord chosenSRVRecord = (SRVRecord)bucket.remove(selectedPos);
                res.add(chosenSRVRecord);
            }
        }
        return res;
    }

    private static int bisect(int[] array, double value) {
        int pos = 0;
        for (int element : array) {
            if (value < (double)element) break;
            ++pos;
        }
        return pos;
    }
}

