/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.amp;

import java.util.Date;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.XmppDateTime;
import org.jivesoftware.smackx.amp.AMPManager;
import org.jivesoftware.smackx.amp.packet.AMPExtension;

public class AMPExpireAtCondition
implements AMPExtension.Condition {
    public static final String NAME = "expire-at";
    private final String value;

    public static boolean isSupported(XMPPConnection connection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return AMPManager.isConditionSupported(connection, NAME);
    }

    public AMPExpireAtCondition(Date utcDateTime) {
        if (utcDateTime == null) {
            throw new NullPointerException("Can't create AMPExpireAtCondition with null value");
        }
        this.value = XmppDateTime.formatXEP0082Date(utcDateTime);
    }

    public AMPExpireAtCondition(String utcDateTime) {
        if (utcDateTime == null) {
            throw new NullPointerException("Can't create AMPExpireAtCondition with null value");
        }
        this.value = utcDateTime;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getValue() {
        return this.value;
    }
}

