/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.TimeoutException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Client;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Proxy;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;

class Socks5ClientForInitiator
extends Socks5Client {
    private XMPPConnection connection;
    private String sessionID;
    private String target;

    public Socks5ClientForInitiator(Bytestream.StreamHost streamHost, String digest, XMPPConnection connection, String sessionID, String target) {
        super(streamHost, digest);
        this.connection = connection;
        this.sessionID = sessionID;
        this.target = target;
    }

    @Override
    public Socket getSocket(int timeout) throws IOException, InterruptedException, TimeoutException, XMPPException, SmackException {
        Socket socket = null;
        if (this.streamHost.getJID().equals(this.connection.getUser())) {
            Socks5Proxy socks5Server = Socks5Proxy.getSocks5Proxy();
            socket = socks5Server.getSocket(this.digest);
            if (socket == null) {
                throw new SmackException("target is not connected to SOCKS5 proxy");
            }
        } else {
            socket = super.getSocket(timeout);
            try {
                this.activate();
            }
            catch (XMPPException e1) {
                socket.close();
                throw e1;
            }
            catch (SmackException.NoResponseException e2) {
                socket.close();
                throw e2;
            }
        }
        return socket;
    }

    private void activate() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Bytestream activate = this.createStreamHostActivation();
        this.connection.createPacketCollectorAndSend(activate).nextResultOrThrow();
    }

    private Bytestream createStreamHostActivation() {
        Bytestream activate = new Bytestream(this.sessionID);
        activate.setMode(null);
        activate.setType(IQ.Type.SET);
        activate.setTo(this.streamHost.getJID());
        activate.setToActivate(this.target);
        return activate;
    }
}

