/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.chatstates;

import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ChatManagerListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.chatstates.ChatState;
import org.jivesoftware.smackx.chatstates.ChatStateListener;
import org.jivesoftware.smackx.chatstates.packet.ChatStateExtension;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;

public class ChatStateManager
extends Manager {
    public static final String NAMESPACE = "http://jabber.org/protocol/chatstates";
    private static final Map<XMPPConnection, ChatStateManager> INSTANCES = new WeakHashMap<XMPPConnection, ChatStateManager>();
    private static final PacketFilter filter = new NotFilter(new PacketExtensionFilter("http://jabber.org/protocol/chatstates"));
    private final OutgoingMessageInterceptor outgoingInterceptor = new OutgoingMessageInterceptor();
    private final IncomingMessageInterceptor incomingInterceptor = new IncomingMessageInterceptor();
    private final Map<Chat, ChatState> chatStates = new WeakHashMap<Chat, ChatState>();
    private final ChatManager chatManager;

    public static synchronized ChatStateManager getInstance(XMPPConnection connection) {
        ChatStateManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new ChatStateManager(connection);
        }
        return manager;
    }

    private ChatStateManager(XMPPConnection connection) {
        super(connection);
        this.chatManager = ChatManager.getInstanceFor(connection);
        this.chatManager.addOutgoingMessageInterceptor(this.outgoingInterceptor, filter);
        this.chatManager.addChatListener(this.incomingInterceptor);
        ServiceDiscoveryManager.getInstanceFor(connection).addFeature(NAMESPACE);
        INSTANCES.put(connection, this);
    }

    public void setCurrentState(ChatState newState, Chat chat) throws SmackException.NotConnectedException {
        if (chat == null || newState == null) {
            throw new IllegalArgumentException("Arguments cannot be null.");
        }
        if (!this.updateChatState(chat, newState)) {
            return;
        }
        Message message = new Message();
        ChatStateExtension extension = new ChatStateExtension(newState);
        message.addExtension(extension);
        chat.sendMessage(message);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChatStateManager that = (ChatStateManager)o;
        return this.connection().equals(that.connection());
    }

    public int hashCode() {
        return this.connection().hashCode();
    }

    private synchronized boolean updateChatState(Chat chat, ChatState newState) {
        ChatState lastChatState = this.chatStates.get(chat);
        if (lastChatState != newState) {
            this.chatStates.put(chat, newState);
            return true;
        }
        return false;
    }

    private void fireNewChatState(Chat chat, ChatState state) {
        for (MessageListener listener : chat.getListeners()) {
            if (!(listener instanceof ChatStateListener)) continue;
            ((ChatStateListener)listener).stateChanged(chat, state);
        }
    }

    private class IncomingMessageInterceptor
    implements ChatManagerListener,
    MessageListener {
        private IncomingMessageInterceptor() {
        }

        @Override
        public void chatCreated(Chat chat, boolean createdLocally) {
            chat.addMessageListener(this);
        }

        @Override
        public void processMessage(Chat chat, Message message) {
            ChatState state;
            PacketExtension extension = message.getExtension(ChatStateManager.NAMESPACE);
            if (extension == null) {
                return;
            }
            try {
                state = ChatState.valueOf(extension.getElementName());
            }
            catch (Exception ex) {
                return;
            }
            ChatStateManager.this.fireNewChatState(chat, state);
        }
    }

    private class OutgoingMessageInterceptor
    implements PacketInterceptor {
        private OutgoingMessageInterceptor() {
        }

        @Override
        public void interceptPacket(Packet packet) {
            Message message = (Message)packet;
            Chat chat = ChatStateManager.this.chatManager.getThreadChat(message.getThread());
            if (chat == null) {
                return;
            }
            if (ChatStateManager.this.updateChatState(chat, ChatState.active)) {
                message.addExtension(new ChatStateExtension(ChatState.active));
            }
        }
    }
}

