/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.commands.AdHocCommand;
import org.jivesoftware.smackx.commands.LocalCommand;
import org.jivesoftware.smackx.commands.LocalCommandFactory;
import org.jivesoftware.smackx.commands.RemoteCommand;
import org.jivesoftware.smackx.commands.packet.AdHocCommandData;
import org.jivesoftware.smackx.disco.NodeInformationProvider;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.xdata.Form;

public class AdHocCommandManager
extends Manager {
    public static final String NAMESPACE = "http://jabber.org/protocol/commands";
    private static final int SESSION_TIMEOUT = 120;
    private static Map<XMPPConnection, AdHocCommandManager> instances = Collections.synchronizedMap(new WeakHashMap());
    private final Map<String, AdHocCommandInfo> commands = new ConcurrentHashMap<String, AdHocCommandInfo>();
    private final Map<String, LocalCommand> executingCommands = new ConcurrentHashMap<String, LocalCommand>();
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private Thread sessionsSweeper;

    public static synchronized AdHocCommandManager getAddHocCommandsManager(XMPPConnection connection) {
        AdHocCommandManager ahcm = instances.get(connection);
        if (ahcm == null) {
            ahcm = new AdHocCommandManager(connection);
        }
        return ahcm;
    }

    private AdHocCommandManager(XMPPConnection connection) {
        super(connection);
        this.serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
        instances.put(connection, this);
        ServiceDiscoveryManager.getInstanceFor(connection).addFeature(NAMESPACE);
        ServiceDiscoveryManager.getInstanceFor(connection).setNodeInformationProvider(NAMESPACE, new NodeInformationProvider(){

            @Override
            public List<DiscoverItems.Item> getNodeItems() {
                ArrayList<DiscoverItems.Item> answer = new ArrayList<DiscoverItems.Item>();
                Collection commandsList = AdHocCommandManager.this.getRegisteredCommands();
                for (AdHocCommandInfo info : commandsList) {
                    DiscoverItems.Item item = new DiscoverItems.Item(info.getOwnerJID());
                    item.setName(info.getName());
                    item.setNode(info.getNode());
                    answer.add(item);
                }
                return answer;
            }

            @Override
            public List<String> getNodeFeatures() {
                return null;
            }

            @Override
            public List<DiscoverInfo.Identity> getNodeIdentities() {
                return null;
            }

            @Override
            public List<PacketExtension> getNodePacketExtensions() {
                return null;
            }
        });
        PacketListener listener = new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                AdHocCommandData requestData = (AdHocCommandData)packet;
                try {
                    AdHocCommandManager.this.processAdHocCommand(requestData);
                }
                catch (SmackException e) {
                    return;
                }
            }
        };
        PacketTypeFilter filter = new PacketTypeFilter(AdHocCommandData.class);
        connection.addPacketListener(listener, filter);
        this.sessionsSweeper = null;
    }

    public void registerCommand(String node, String name, final Class<? extends LocalCommand> clazz) {
        this.registerCommand(node, name, new LocalCommandFactory(){

            @Override
            public LocalCommand getInstance() throws InstantiationException, IllegalAccessException {
                return (LocalCommand)clazz.newInstance();
            }
        });
    }

    public void registerCommand(String node, final String name, LocalCommandFactory factory) {
        AdHocCommandInfo commandInfo = new AdHocCommandInfo(node, name, this.connection().getUser(), factory);
        this.commands.put(node, commandInfo);
        this.serviceDiscoveryManager.setNodeInformationProvider(node, new NodeInformationProvider(){

            @Override
            public List<DiscoverItems.Item> getNodeItems() {
                return null;
            }

            @Override
            public List<String> getNodeFeatures() {
                ArrayList<String> answer = new ArrayList<String>();
                answer.add(AdHocCommandManager.NAMESPACE);
                answer.add("jabber:x:data");
                return answer;
            }

            @Override
            public List<DiscoverInfo.Identity> getNodeIdentities() {
                ArrayList<DiscoverInfo.Identity> answer = new ArrayList<DiscoverInfo.Identity>();
                DiscoverInfo.Identity identity = new DiscoverInfo.Identity("automation", name, "command-node");
                answer.add(identity);
                return answer;
            }

            @Override
            public List<PacketExtension> getNodePacketExtensions() {
                return null;
            }
        });
    }

    public DiscoverItems discoverCommands(String jid) throws XMPPException, SmackException {
        return this.serviceDiscoveryManager.discoverItems(jid, NAMESPACE);
    }

    public void publishCommands(String jid) throws XMPPException, SmackException {
        DiscoverItems discoverItems = new DiscoverItems();
        Collection<AdHocCommandInfo> xCommandsList = this.getRegisteredCommands();
        for (AdHocCommandInfo info : xCommandsList) {
            DiscoverItems.Item item = new DiscoverItems.Item(info.getOwnerJID());
            item.setName(info.getName());
            item.setNode(info.getNode());
            discoverItems.addItem(item);
        }
        this.serviceDiscoveryManager.publishItems(jid, NAMESPACE, discoverItems);
    }

    public RemoteCommand getRemoteCommand(String jid, String node) {
        return new RemoteCommand(this.connection(), node, jid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAdHocCommand(AdHocCommandData requestData) throws SmackException {
        if (requestData.getType() != IQ.Type.SET) {
            return;
        }
        AdHocCommandData response = new AdHocCommandData();
        response.setTo(requestData.getFrom());
        response.setPacketID(requestData.getPacketID());
        response.setNode(requestData.getNode());
        response.setId(requestData.getTo());
        String sessionId = requestData.getSessionID();
        String commandNode = requestData.getNode();
        if (sessionId == null) {
            if (!this.commands.containsKey(commandNode)) {
                this.respondError(response, XMPPError.Condition.item_not_found);
                return;
            }
            sessionId = StringUtils.randomString(15);
            try {
                LocalCommand command = this.newInstanceOfCmd(commandNode, sessionId);
                response.setType(IQ.Type.RESULT);
                command.setData(response);
                if (!command.hasPermission(requestData.getFrom())) {
                    this.respondError(response, XMPPError.Condition.forbidden);
                    return;
                }
                AdHocCommand.Action action = requestData.getAction();
                if (action != null && action.equals((Object)AdHocCommand.Action.unknown)) {
                    this.respondError(response, XMPPError.Condition.bad_request, AdHocCommand.SpecificErrorCondition.malformedAction);
                    return;
                }
                if (action != null && !action.equals((Object)AdHocCommand.Action.execute)) {
                    this.respondError(response, XMPPError.Condition.bad_request, AdHocCommand.SpecificErrorCondition.badAction);
                    return;
                }
                command.incrementStage();
                command.execute();
                if (command.isLastStage()) {
                    response.setStatus(AdHocCommand.Status.completed);
                } else {
                    response.setStatus(AdHocCommand.Status.executing);
                    this.executingCommands.put(sessionId, command);
                    if (this.sessionsSweeper == null) {
                        this.sessionsSweeper = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                while (true) {
                                    for (String sessionId : AdHocCommandManager.this.executingCommands.keySet()) {
                                        LocalCommand command = (LocalCommand)AdHocCommandManager.this.executingCommands.get(sessionId);
                                        if (command == null) continue;
                                        long creationStamp = command.getCreationDate();
                                        if (System.currentTimeMillis() - creationStamp <= 240000L) continue;
                                        AdHocCommandManager.this.executingCommands.remove(sessionId);
                                    }
                                    try {
                                        Thread.sleep(1000L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                    }
                                }
                            }
                        });
                        this.sessionsSweeper.setDaemon(true);
                        this.sessionsSweeper.start();
                    }
                }
                this.connection().sendPacket(response);
            }
            catch (XMPPException.XMPPErrorException e) {
                XMPPError error = e.getXMPPError();
                if (XMPPError.Type.CANCEL.equals((Object)error.getType())) {
                    response.setStatus(AdHocCommand.Status.canceled);
                    this.executingCommands.remove(sessionId);
                }
                this.respondError(response, error);
            }
        } else {
            LocalCommand command = this.executingCommands.get(sessionId);
            if (command == null) {
                this.respondError(response, XMPPError.Condition.bad_request, AdHocCommand.SpecificErrorCondition.badSessionid);
                return;
            }
            long creationStamp = command.getCreationDate();
            if (System.currentTimeMillis() - creationStamp > 120000L) {
                this.executingCommands.remove(sessionId);
                this.respondError(response, XMPPError.Condition.not_allowed, AdHocCommand.SpecificErrorCondition.sessionExpired);
                return;
            }
            LocalCommand localCommand = command;
            synchronized (localCommand) {
                AdHocCommand.Action action = requestData.getAction();
                if (action != null && action.equals((Object)AdHocCommand.Action.unknown)) {
                    this.respondError(response, XMPPError.Condition.bad_request, AdHocCommand.SpecificErrorCondition.malformedAction);
                    return;
                }
                if (action == null || AdHocCommand.Action.execute.equals((Object)action)) {
                    action = command.getExecuteAction();
                }
                if (!command.isValidAction(action)) {
                    this.respondError(response, XMPPError.Condition.bad_request, AdHocCommand.SpecificErrorCondition.badAction);
                    return;
                }
                try {
                    response.setType(IQ.Type.RESULT);
                    command.setData(response);
                    if (AdHocCommand.Action.next.equals((Object)action)) {
                        command.incrementStage();
                        command.next(new Form(requestData.getForm()));
                        if (command.isLastStage()) {
                            response.setStatus(AdHocCommand.Status.completed);
                        } else {
                            response.setStatus(AdHocCommand.Status.executing);
                        }
                    } else if (AdHocCommand.Action.complete.equals((Object)action)) {
                        command.incrementStage();
                        command.complete(new Form(requestData.getForm()));
                        response.setStatus(AdHocCommand.Status.completed);
                        this.executingCommands.remove(sessionId);
                    } else if (AdHocCommand.Action.prev.equals((Object)action)) {
                        command.decrementStage();
                        command.prev();
                    } else if (AdHocCommand.Action.cancel.equals((Object)action)) {
                        command.cancel();
                        response.setStatus(AdHocCommand.Status.canceled);
                        this.executingCommands.remove(sessionId);
                    }
                    this.connection().sendPacket(response);
                }
                catch (XMPPException.XMPPErrorException e) {
                    XMPPError error = e.getXMPPError();
                    if (XMPPError.Type.CANCEL.equals((Object)error.getType())) {
                        response.setStatus(AdHocCommand.Status.canceled);
                        this.executingCommands.remove(sessionId);
                    }
                    this.respondError(response, error);
                }
            }
        }
    }

    private void respondError(AdHocCommandData response, XMPPError.Condition condition) throws SmackException.NotConnectedException {
        this.respondError(response, new XMPPError(condition));
    }

    private void respondError(AdHocCommandData response, XMPPError.Condition condition, AdHocCommand.SpecificErrorCondition specificCondition) throws SmackException.NotConnectedException {
        XMPPError error = new XMPPError(condition);
        error.addExtension(new AdHocCommandData.SpecificError(specificCondition));
        this.respondError(response, error);
    }

    private void respondError(AdHocCommandData response, XMPPError error) throws SmackException.NotConnectedException {
        response.setType(IQ.Type.ERROR);
        response.setError(error);
        this.connection().sendPacket(response);
    }

    private LocalCommand newInstanceOfCmd(String commandNode, String sessionID) throws XMPPException.XMPPErrorException {
        LocalCommand command;
        AdHocCommandInfo commandInfo = this.commands.get(commandNode);
        try {
            command = commandInfo.getCommandInstance();
            command.setSessionID(sessionID);
            command.setName(commandInfo.getName());
            command.setNode(commandInfo.getNode());
        }
        catch (InstantiationException e) {
            throw new XMPPException.XMPPErrorException(new XMPPError(XMPPError.Condition.internal_server_error));
        }
        catch (IllegalAccessException e) {
            throw new XMPPException.XMPPErrorException(new XMPPError(XMPPError.Condition.internal_server_error));
        }
        return command;
    }

    private Collection<AdHocCommandInfo> getRegisteredCommands() {
        return this.commands.values();
    }

    static {
        XMPPConnection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection connection) {
                AdHocCommandManager.getAddHocCommandsManager(connection);
            }
        });
    }

    private static class AdHocCommandInfo {
        private String node;
        private String name;
        private String ownerJID;
        private LocalCommandFactory factory;

        public AdHocCommandInfo(String node, String name, String ownerJID, LocalCommandFactory factory) {
            this.node = node;
            this.name = name;
            this.ownerJID = ownerJID;
            this.factory = factory;
        }

        public LocalCommand getCommandInstance() throws InstantiationException, IllegalAccessException {
            return this.factory.getInstance();
        }

        public String getName() {
            return this.name;
        }

        public String getNode() {
            return this.node;
        }

        public String getOwnerJID() {
            return this.ownerJID;
        }
    }
}

