/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.delay.packet;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.jivesoftware.smack.packet.PacketExtension;

public class DelayInformation
implements PacketExtension {
    public static final DateFormat XEP_0091_UTC_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    private Date stamp;
    private String from;
    private String reason;

    public DelayInformation(Date stamp) {
        this.stamp = stamp;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public Date getStamp() {
        return this.stamp;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public String getElementName() {
        return "x";
    }

    @Override
    public String getNamespace() {
        return "jabber:x:delay";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<").append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\"");
        buf.append(" stamp=\"");
        DateFormat dateFormat = XEP_0091_UTC_FORMAT;
        synchronized (dateFormat) {
            buf.append(XEP_0091_UTC_FORMAT.format(this.stamp));
        }
        buf.append("\"");
        if (this.from != null && this.from.length() > 0) {
            buf.append(" from=\"").append(this.from).append("\"");
        }
        buf.append(">");
        if (this.reason != null && this.reason.length() > 0) {
            buf.append(this.reason);
        }
        buf.append("</").append(this.getElementName()).append(">");
        return buf.toString();
    }

    static {
        XEP_0091_UTC_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

