/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.disco;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.caps.EntityCapsManager;
import org.jivesoftware.smackx.disco.NodeInformationProvider;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class ServiceDiscoveryManager
extends Manager {
    private static final String DEFAULT_IDENTITY_NAME = "Smack";
    private static final String DEFAULT_IDENTITY_CATEGORY = "client";
    private static final String DEFAULT_IDENTITY_TYPE = "pc";
    private static DiscoverInfo.Identity defaultIdentity = new DiscoverInfo.Identity("client", "Smack", "pc");
    private Set<DiscoverInfo.Identity> identities = new HashSet<DiscoverInfo.Identity>();
    private DiscoverInfo.Identity identity = defaultIdentity;
    private EntityCapsManager capsManager;
    private static Map<XMPPConnection, ServiceDiscoveryManager> instances = Collections.synchronizedMap(new WeakHashMap());
    private final Set<String> features = new HashSet<String>();
    private DataForm extendedInfo = null;
    private Map<String, NodeInformationProvider> nodeInformationProviders = new ConcurrentHashMap<String, NodeInformationProvider>();

    public static void setDefaultIdentity(DiscoverInfo.Identity identity) {
        defaultIdentity = identity;
    }

    private ServiceDiscoveryManager(XMPPConnection connection) {
        super(connection);
        instances.put(connection, this);
        this.addFeature("http://jabber.org/protocol/disco#info");
        this.addFeature("http://jabber.org/protocol/disco#items");
        PacketTypeFilter packetFilter = new PacketTypeFilter(DiscoverItems.class);
        PacketListener packetListener = new PacketListener(){

            @Override
            public void processPacket(Packet packet) throws SmackException.NotConnectedException {
                XMPPConnection connection = ServiceDiscoveryManager.this.connection();
                if (connection == null) {
                    return;
                }
                DiscoverItems discoverItems = (DiscoverItems)packet;
                if (discoverItems != null && discoverItems.getType() == IQ.Type.GET) {
                    DiscoverItems response = new DiscoverItems();
                    response.setType(IQ.Type.RESULT);
                    response.setTo(discoverItems.getFrom());
                    response.setPacketID(discoverItems.getPacketID());
                    response.setNode(discoverItems.getNode());
                    NodeInformationProvider nodeInformationProvider = ServiceDiscoveryManager.this.getNodeInformationProvider(discoverItems.getNode());
                    if (nodeInformationProvider != null) {
                        response.addItems(nodeInformationProvider.getNodeItems());
                        response.addExtensions(nodeInformationProvider.getNodePacketExtensions());
                    } else if (discoverItems.getNode() != null) {
                        response.setType(IQ.Type.ERROR);
                        response.setError(new XMPPError(XMPPError.Condition.item_not_found));
                    }
                    connection.sendPacket(response);
                }
            }
        };
        connection.addPacketListener(packetListener, packetFilter);
        packetFilter = new PacketTypeFilter(DiscoverInfo.class);
        packetListener = new PacketListener(){

            @Override
            public void processPacket(Packet packet) throws SmackException.NotConnectedException {
                XMPPConnection connection = ServiceDiscoveryManager.this.connection();
                if (connection == null) {
                    return;
                }
                DiscoverInfo discoverInfo = (DiscoverInfo)packet;
                if (discoverInfo != null && discoverInfo.getType() == IQ.Type.GET) {
                    DiscoverInfo response = new DiscoverInfo();
                    response.setType(IQ.Type.RESULT);
                    response.setTo(discoverInfo.getFrom());
                    response.setPacketID(discoverInfo.getPacketID());
                    response.setNode(discoverInfo.getNode());
                    if (discoverInfo.getNode() == null) {
                        ServiceDiscoveryManager.this.addDiscoverInfoTo(response);
                    } else {
                        NodeInformationProvider nodeInformationProvider = ServiceDiscoveryManager.this.getNodeInformationProvider(discoverInfo.getNode());
                        if (nodeInformationProvider != null) {
                            response.addFeatures(nodeInformationProvider.getNodeFeatures());
                            response.addIdentities(nodeInformationProvider.getNodeIdentities());
                            response.addExtensions(nodeInformationProvider.getNodePacketExtensions());
                        } else {
                            response.setType(IQ.Type.ERROR);
                            response.setError(new XMPPError(XMPPError.Condition.item_not_found));
                        }
                    }
                    connection.sendPacket(response);
                }
            }
        };
        connection.addPacketListener(packetListener, packetFilter);
    }

    public String getIdentityName() {
        return this.identity.getName();
    }

    public void setIdentityName(String name) {
        this.identity.setName(name);
        this.renewEntityCapsVersion();
    }

    public void setIdentity(DiscoverInfo.Identity identity) {
        if (identity == null) {
            throw new IllegalArgumentException("Identity can not be null");
        }
        this.identity = identity;
        this.renewEntityCapsVersion();
    }

    public DiscoverInfo.Identity getIdentity() {
        return this.identity;
    }

    public String getIdentityType() {
        return this.identity.getType();
    }

    public void addIdentity(DiscoverInfo.Identity identity) {
        this.identities.add(identity);
        this.renewEntityCapsVersion();
    }

    public boolean removeIdentity(DiscoverInfo.Identity identity) {
        if (identity.equals(this.identity)) {
            return false;
        }
        this.identities.remove(identity);
        this.renewEntityCapsVersion();
        return true;
    }

    public Set<DiscoverInfo.Identity> getIdentities() {
        HashSet<DiscoverInfo.Identity> res = new HashSet<DiscoverInfo.Identity>(this.identities);
        res.add(defaultIdentity);
        return Collections.unmodifiableSet(res);
    }

    public static synchronized ServiceDiscoveryManager getInstanceFor(XMPPConnection connection) {
        ServiceDiscoveryManager sdm = instances.get(connection);
        if (sdm == null) {
            sdm = new ServiceDiscoveryManager(connection);
        }
        return sdm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiscoverInfoTo(DiscoverInfo response) {
        response.addIdentities(this.getIdentities());
        Set<String> set = this.features;
        synchronized (set) {
            for (String feature : this.getFeatures()) {
                response.addFeature(feature);
            }
            response.addExtension(this.extendedInfo);
        }
    }

    private NodeInformationProvider getNodeInformationProvider(String node) {
        if (node == null) {
            return null;
        }
        return this.nodeInformationProviders.get(node);
    }

    public void setNodeInformationProvider(String node, NodeInformationProvider listener) {
        this.nodeInformationProviders.put(node, listener);
    }

    public void removeNodeInformationProvider(String node) {
        this.nodeInformationProviders.remove(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFeatures() {
        Set<String> set = this.features;
        synchronized (set) {
            return Collections.unmodifiableList(new ArrayList<String>(this.features));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getFeaturesList() {
        Set<String> set = this.features;
        synchronized (set) {
            return new LinkedList<String>(this.features);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeature(String feature) {
        Set<String> set = this.features;
        synchronized (set) {
            this.features.add(feature);
            this.renewEntityCapsVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFeature(String feature) {
        Set<String> set = this.features;
        synchronized (set) {
            this.features.remove(feature);
            this.renewEntityCapsVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean includesFeature(String feature) {
        Set<String> set = this.features;
        synchronized (set) {
            return this.features.contains(feature);
        }
    }

    public void setExtendedInfo(DataForm info) {
        this.extendedInfo = info;
        this.renewEntityCapsVersion();
    }

    public DataForm getExtendedInfo() {
        return this.extendedInfo;
    }

    public List<PacketExtension> getExtendedInfoAsList() {
        ArrayList<DataForm> res = null;
        if (this.extendedInfo != null) {
            res = new ArrayList<DataForm>(1);
            res.add(this.extendedInfo);
        }
        return res;
    }

    public void removeExtendedInfo() {
        this.extendedInfo = null;
        this.renewEntityCapsVersion();
    }

    public DiscoverInfo discoverInfo(String entityID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (entityID == null) {
            return this.discoverInfo(null, null);
        }
        DiscoverInfo info = EntityCapsManager.getDiscoverInfoByUser(entityID);
        if (info != null) {
            return info;
        }
        EntityCapsManager.NodeVerHash nvh = EntityCapsManager.getNodeVerHashByJid(entityID);
        info = this.discoverInfo(entityID, nvh != null ? nvh.getNodeVer() : null);
        if (nvh != null && EntityCapsManager.verifyDiscoverInfoVersion(nvh.getVer(), nvh.getHash(), info)) {
            EntityCapsManager.addDiscoverInfoByNode(nvh.getNodeVer(), info);
        }
        return info;
    }

    public DiscoverInfo discoverInfo(String entityID, String node) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        DiscoverInfo disco = new DiscoverInfo();
        disco.setType(IQ.Type.GET);
        disco.setTo(entityID);
        disco.setNode(node);
        Packet result = this.connection().createPacketCollectorAndSend(disco).nextResultOrThrow();
        return (DiscoverInfo)result;
    }

    public DiscoverItems discoverItems(String entityID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.discoverItems(entityID, null);
    }

    public DiscoverItems discoverItems(String entityID, String node) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        DiscoverItems disco = new DiscoverItems();
        disco.setType(IQ.Type.GET);
        disco.setTo(entityID);
        disco.setNode(node);
        Packet result = this.connection().createPacketCollectorAndSend(disco).nextResultOrThrow();
        return (DiscoverItems)result;
    }

    public boolean canPublishItems(String entityID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        DiscoverInfo info = this.discoverInfo(entityID);
        return ServiceDiscoveryManager.canPublishItems(info);
    }

    public static boolean canPublishItems(DiscoverInfo info) {
        return info.containsFeature("http://jabber.org/protocol/disco#publish");
    }

    public void publishItems(String entityID, DiscoverItems discoverItems) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.publishItems(entityID, null, discoverItems);
    }

    public void publishItems(String entityID, String node, DiscoverItems discoverItems) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        discoverItems.setType(IQ.Type.SET);
        discoverItems.setTo(entityID);
        discoverItems.setNode(node);
        this.connection().createPacketCollectorAndSend(discoverItems).nextResultOrThrow();
    }

    public boolean supportsFeature(String jid, String feature) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        DiscoverInfo result = this.discoverInfo(jid);
        return result.containsFeature(feature);
    }

    public void setEntityCapsManager(EntityCapsManager manager) {
        this.capsManager = manager;
    }

    private void renewEntityCapsVersion() {
        if (this.capsManager != null && this.capsManager.entityCapsEnabled()) {
            this.capsManager.updateLocalEntityCaps();
        }
    }

    static {
        XMPPConnection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection connection) {
                ServiceDiscoveryManager.getInstanceFor(connection);
            }
        });
    }
}

