/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iqlast;

import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.iqlast.packet.LastActivity;

public class LastActivityManager
extends Manager {
    private static final Map<XMPPConnection, LastActivityManager> instances = new WeakHashMap<XMPPConnection, LastActivityManager>();
    private static final PacketFilter IQ_GET_LAST_FILTER = new AndFilter(new IQTypeFilter(IQ.Type.GET), new PacketTypeFilter(LastActivity.class));
    private static boolean enabledPerDefault = true;
    private volatile long lastMessageSent;
    private boolean enabled = false;

    public static void setEnabledPerDefault(boolean enabledPerDefault) {
        LastActivityManager.enabledPerDefault = enabledPerDefault;
    }

    public static synchronized LastActivityManager getInstanceFor(XMPPConnection connection) {
        LastActivityManager lastActivityManager = instances.get(connection);
        if (lastActivityManager == null) {
            lastActivityManager = new LastActivityManager(connection);
        }
        return lastActivityManager;
    }

    private LastActivityManager(XMPPConnection connection) {
        super(connection);
        connection.addPacketSendingListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                Presence presence = (Presence)packet;
                Presence.Mode mode = presence.getMode();
                if (mode == null) {
                    return;
                }
                switch (mode) {
                    case available: 
                    case chat: {
                        LastActivityManager.this.resetIdleTime();
                    }
                }
            }
        }, PacketTypeFilter.PRESENCE);
        connection.addPacketSendingListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                Message message = (Message)packet;
                if (message.getType() == Message.Type.error) {
                    return;
                }
                LastActivityManager.this.resetIdleTime();
            }
        }, PacketTypeFilter.MESSAGE);
        connection.addPacketListener(new PacketListener(){

            @Override
            public void processPacket(Packet packet) throws SmackException.NotConnectedException {
                if (!LastActivityManager.this.enabled) {
                    return;
                }
                LastActivity message = new LastActivity();
                message.setType(IQ.Type.RESULT);
                message.setTo(packet.getFrom());
                message.setFrom(packet.getTo());
                message.setPacketID(packet.getPacketID());
                message.setLastActivity(LastActivityManager.this.getIdleTime());
                LastActivityManager.this.connection().sendPacket(message);
            }
        }, IQ_GET_LAST_FILTER);
        if (enabledPerDefault) {
            this.enable();
        }
        this.resetIdleTime();
        instances.put(connection, this);
    }

    public synchronized void enable() {
        ServiceDiscoveryManager.getInstanceFor(this.connection()).addFeature("jabber:iq:last");
        this.enabled = true;
    }

    public synchronized void disable() {
        ServiceDiscoveryManager.getInstanceFor(this.connection()).removeFeature("jabber:iq:last");
        this.enabled = false;
    }

    private void resetIdleTime() {
        this.lastMessageSent = System.currentTimeMillis();
    }

    private long getIdleTime() {
        long lms = this.lastMessageSent;
        long now = System.currentTimeMillis();
        return (now - lms) / 1000L;
    }

    public LastActivity getLastActivity(String jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        LastActivity activity = new LastActivity(jid);
        return (LastActivity)this.connection().createPacketCollectorAndSend(activity).nextResultOrThrow();
    }

    public boolean isLastActivitySupported(String jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection()).supportsFeature(jid, "jabber:iq:last");
    }

    static {
        XMPPConnection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection connection) {
                LastActivityManager.getInstanceFor(connection);
            }
        });
    }
}

