/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Registration;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.disco.NodeInformationProvider;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.muc.Affiliate;
import org.jivesoftware.smackx.muc.ConnectionDetachedPacketCollector;
import org.jivesoftware.smackx.muc.DiscussionHistory;
import org.jivesoftware.smackx.muc.HostedRoom;
import org.jivesoftware.smackx.muc.InvitationListener;
import org.jivesoftware.smackx.muc.InvitationRejectionListener;
import org.jivesoftware.smackx.muc.Occupant;
import org.jivesoftware.smackx.muc.PacketMultiplexListener;
import org.jivesoftware.smackx.muc.ParticipantStatusListener;
import org.jivesoftware.smackx.muc.RoomInfo;
import org.jivesoftware.smackx.muc.RoomListenerMultiplexor;
import org.jivesoftware.smackx.muc.SubjectUpdatedListener;
import org.jivesoftware.smackx.muc.UserStatusListener;
import org.jivesoftware.smackx.muc.packet.MUCAdmin;
import org.jivesoftware.smackx.muc.packet.MUCInitialPresence;
import org.jivesoftware.smackx.muc.packet.MUCOwner;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.jivesoftware.smackx.xdata.Form;

public class MultiUserChat {
    private static final Logger LOGGER = Logger.getLogger(MultiUserChat.class.getName());
    private static final String discoNamespace = "http://jabber.org/protocol/muc";
    private static final String discoNode = "http://jabber.org/protocol/muc#rooms";
    private static Map<XMPPConnection, List<String>> joinedRooms = new WeakHashMap<XMPPConnection, List<String>>();
    private XMPPConnection connection;
    private String room;
    private String subject;
    private String nickname = null;
    private boolean joined = false;
    private Map<String, Presence> occupantsMap = new ConcurrentHashMap<String, Presence>();
    private final List<InvitationRejectionListener> invitationRejectionListeners = new ArrayList<InvitationRejectionListener>();
    private final List<SubjectUpdatedListener> subjectUpdatedListeners = new ArrayList<SubjectUpdatedListener>();
    private final List<UserStatusListener> userStatusListeners = new ArrayList<UserStatusListener>();
    private final List<ParticipantStatusListener> participantStatusListeners = new ArrayList<ParticipantStatusListener>();
    private PacketFilter presenceFilter;
    private List<PacketInterceptor> presenceInterceptors = new ArrayList<PacketInterceptor>();
    private PacketFilter messageFilter;
    private RoomListenerMultiplexor roomListenerMultiplexor;
    private ConnectionDetachedPacketCollector messageCollector;
    private List<PacketListener> connectionListeners = new ArrayList<PacketListener>();

    public MultiUserChat(XMPPConnection connection, String room) {
        this.connection = connection;
        this.room = room.toLowerCase(Locale.US);
        this.init();
    }

    public static boolean isServiceEnabled(XMPPConnection connection, String user) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return ServiceDiscoveryManager.getInstanceFor(connection).supportsFeature(user, discoNamespace);
    }

    private static List<String> getJoinedRooms(XMPPConnection connection) {
        List<String> rooms = joinedRooms.get(connection);
        if (rooms != null) {
            return rooms;
        }
        return Collections.emptyList();
    }

    public static List<String> getJoinedRooms(XMPPConnection connection, String user) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ArrayList<String> answer = new ArrayList<String>();
        DiscoverItems result = ServiceDiscoveryManager.getInstanceFor(connection).discoverItems(user, discoNode);
        for (DiscoverItems.Item item : result.getItems()) {
            answer.add(item.getEntityID());
        }
        return answer;
    }

    public static RoomInfo getRoomInfo(XMPPConnection connection, String room) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        DiscoverInfo info = ServiceDiscoveryManager.getInstanceFor(connection).discoverInfo(room);
        return new RoomInfo(info);
    }

    public static Collection<String> getServiceNames(XMPPConnection connection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ArrayList<String> answer = new ArrayList<String>();
        ServiceDiscoveryManager discoManager = ServiceDiscoveryManager.getInstanceFor(connection);
        DiscoverItems items = discoManager.discoverItems(connection.getServiceName());
        for (DiscoverItems.Item item : items.getItems()) {
            DiscoverInfo info = discoManager.discoverInfo(item.getEntityID());
            if (!info.containsFeature(discoNamespace)) continue;
            answer.add(item.getEntityID());
        }
        return answer;
    }

    public static Collection<HostedRoom> getHostedRooms(XMPPConnection connection, String serviceName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ArrayList<HostedRoom> answer = new ArrayList<HostedRoom>();
        ServiceDiscoveryManager discoManager = ServiceDiscoveryManager.getInstanceFor(connection);
        DiscoverItems items = discoManager.discoverItems(serviceName);
        for (DiscoverItems.Item item : items.getItems()) {
            answer.add(new HostedRoom(item));
        }
        return answer;
    }

    public String getRoom() {
        return this.room;
    }

    private Presence enter(String nickname, String password, DiscussionHistory history, long timeout) throws SmackException.NotConnectedException, SmackException.NoResponseException, XMPPException.XMPPErrorException {
        if (StringUtils.isNullOrEmpty(nickname)) {
            throw new IllegalArgumentException("Nickname must not be null or blank.");
        }
        Presence joinPresence = new Presence(Presence.Type.available);
        joinPresence.setTo(this.room + "/" + nickname);
        MUCInitialPresence mucInitialPresence = new MUCInitialPresence();
        if (password != null) {
            mucInitialPresence.setPassword(password);
        }
        if (history != null) {
            mucInitialPresence.setHistory(history.getMUCHistory());
        }
        joinPresence.addExtension(mucInitialPresence);
        for (PacketInterceptor packetInterceptor : this.presenceInterceptors) {
            packetInterceptor.interceptPacket(joinPresence);
        }
        AndFilter responseFilter = new AndFilter(FromMatchesFilter.createFull(this.room + "/" + nickname), new PacketTypeFilter(Presence.class));
        PacketCollector response = null;
        response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(joinPresence);
        Presence presence = (Presence)response.nextResultOrThrow(timeout);
        this.nickname = nickname;
        this.joined = true;
        List<String> rooms = joinedRooms.get(this.connection);
        if (rooms == null) {
            rooms = new ArrayList<String>();
            joinedRooms.put(this.connection, rooms);
        }
        rooms.add(this.room);
        return presence;
    }

    public synchronized void create(String nickname) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException {
        if (this.joined) {
            throw new IllegalStateException("Creation failed - User already joined the room.");
        }
        if (this.createOrJoin(nickname)) {
            return;
        }
        this.leave();
        throw new SmackException("Creation failed - Missing acknowledge of room creation.");
    }

    public synchronized boolean createOrJoin(String nickname) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException {
        if (this.joined) {
            throw new IllegalStateException("Creation failed - User already joined the room.");
        }
        Presence presence = this.enter(nickname, null, null, this.connection.getPacketReplyTimeout());
        MUCUser mucUser = this.getMUCUserExtension(presence);
        return mucUser != null && mucUser.getStatus() != null && "201".equals(mucUser.getStatus().getCode());
    }

    public void join(String nickname) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.join(nickname, null, null, this.connection.getPacketReplyTimeout());
    }

    public void join(String nickname, String password) throws XMPPException.XMPPErrorException, SmackException {
        this.join(nickname, password, null, this.connection.getPacketReplyTimeout());
    }

    public synchronized void join(String nickname, String password, DiscussionHistory history, long timeout) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        if (this.joined) {
            this.leave();
        }
        this.enter(nickname, password, history, timeout);
    }

    public boolean isJoined() {
        return this.joined;
    }

    public synchronized void leave() throws SmackException.NotConnectedException {
        if (!this.joined) {
            return;
        }
        Presence leavePresence = new Presence(Presence.Type.unavailable);
        leavePresence.setTo(this.room + "/" + this.nickname);
        for (PacketInterceptor packetInterceptor : this.presenceInterceptors) {
            packetInterceptor.interceptPacket(leavePresence);
        }
        this.connection.sendPacket(leavePresence);
        this.occupantsMap.clear();
        this.nickname = null;
        this.joined = false;
        this.userHasLeft();
    }

    public Form getConfigurationForm() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.GET);
        IQ answer = (IQ)this.connection.createPacketCollectorAndSend(iq).nextResultOrThrow();
        return Form.getFormFrom(answer);
    }

    public void sendConfigurationForm(Form form) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.SET);
        iq.addExtension(form.getDataFormToSend());
        this.connection.createPacketCollectorAndSend(iq).nextResultOrThrow();
    }

    public Form getRegistrationForm() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Registration reg = new Registration();
        reg.setType(IQ.Type.GET);
        reg.setTo(this.room);
        IQ result = (IQ)this.connection.createPacketCollectorAndSend(reg).nextResultOrThrow();
        return Form.getFormFrom(result);
    }

    public void sendRegistrationForm(Form form) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Registration reg = new Registration();
        reg.setType(IQ.Type.SET);
        reg.setTo(this.room);
        reg.addExtension(form.getDataFormToSend());
        this.connection.createPacketCollectorAndSend(reg).nextResultOrThrow();
    }

    public void destroy(String reason, String alternateJID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.SET);
        MUCOwner.Destroy destroy = new MUCOwner.Destroy();
        destroy.setReason(reason);
        destroy.setJid(alternateJID);
        iq.setDestroy(destroy);
        this.connection.createPacketCollectorAndSend(iq).nextResultOrThrow();
        this.occupantsMap.clear();
        this.nickname = null;
        this.joined = false;
        this.userHasLeft();
    }

    public void invite(String user, String reason) throws SmackException.NotConnectedException {
        this.invite(new Message(), user, reason);
    }

    public void invite(Message message, String user, String reason) throws SmackException.NotConnectedException {
        message.setTo(this.room);
        MUCUser mucUser = new MUCUser();
        MUCUser.Invite invite = new MUCUser.Invite();
        invite.setTo(user);
        invite.setReason(reason);
        mucUser.setInvite(invite);
        message.addExtension(mucUser);
        this.connection.sendPacket(message);
    }

    public static void decline(XMPPConnection conn, String room, String inviter, String reason) throws SmackException.NotConnectedException {
        Message message = new Message(room);
        MUCUser mucUser = new MUCUser();
        MUCUser.Decline decline = new MUCUser.Decline();
        decline.setTo(inviter);
        decline.setReason(reason);
        mucUser.setDecline(decline);
        message.addExtension(mucUser);
        conn.sendPacket(message);
    }

    public static void addInvitationListener(XMPPConnection conn, InvitationListener listener) {
        InvitationsMonitor.getInvitationsMonitor(conn).addInvitationListener(listener);
    }

    public static void removeInvitationListener(XMPPConnection conn, InvitationListener listener) {
        InvitationsMonitor.getInvitationsMonitor(conn).removeInvitationListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvitationRejectionListener(InvitationRejectionListener listener) {
        List<InvitationRejectionListener> list = this.invitationRejectionListeners;
        synchronized (list) {
            if (!this.invitationRejectionListeners.contains(listener)) {
                this.invitationRejectionListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInvitationRejectionListener(InvitationRejectionListener listener) {
        List<InvitationRejectionListener> list = this.invitationRejectionListeners;
        synchronized (list) {
            this.invitationRejectionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInvitationRejectionListeners(String invitee, String reason) {
        InvitationRejectionListener[] listeners;
        List<InvitationRejectionListener> list = this.invitationRejectionListeners;
        synchronized (list) {
            listeners = new InvitationRejectionListener[this.invitationRejectionListeners.size()];
            this.invitationRejectionListeners.toArray(listeners);
        }
        for (InvitationRejectionListener listener : listeners) {
            listener.invitationDeclined(invitee, reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubjectUpdatedListener(SubjectUpdatedListener listener) {
        List<SubjectUpdatedListener> list = this.subjectUpdatedListeners;
        synchronized (list) {
            if (!this.subjectUpdatedListeners.contains(listener)) {
                this.subjectUpdatedListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubjectUpdatedListener(SubjectUpdatedListener listener) {
        List<SubjectUpdatedListener> list = this.subjectUpdatedListeners;
        synchronized (list) {
            this.subjectUpdatedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSubjectUpdatedListeners(String subject, String from) {
        SubjectUpdatedListener[] listeners;
        List<SubjectUpdatedListener> list = this.subjectUpdatedListeners;
        synchronized (list) {
            listeners = new SubjectUpdatedListener[this.subjectUpdatedListeners.size()];
            this.subjectUpdatedListeners.toArray(listeners);
        }
        for (SubjectUpdatedListener listener : listeners) {
            listener.subjectUpdated(subject, from);
        }
    }

    public void addPresenceInterceptor(PacketInterceptor presenceInterceptor) {
        this.presenceInterceptors.add(presenceInterceptor);
    }

    public void removePresenceInterceptor(PacketInterceptor presenceInterceptor) {
        this.presenceInterceptors.remove(presenceInterceptor);
    }

    public String getSubject() {
        return this.subject;
    }

    public String getReservedNickname() throws SmackException {
        try {
            DiscoverInfo result = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverInfo(this.room, "x-roomuser-item");
            Iterator<DiscoverInfo.Identity> i$ = result.getIdentities().iterator();
            if (i$.hasNext()) {
                DiscoverInfo.Identity identity = i$.next();
                return identity.getName();
            }
        }
        catch (XMPPException e) {
            LOGGER.log(Level.SEVERE, "Error retrieving room nickname", e);
        }
        return null;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void changeNickname(String nickname) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (StringUtils.isNullOrEmpty(nickname)) {
            throw new IllegalArgumentException("Nickname must not be null or blank.");
        }
        if (!this.joined) {
            throw new IllegalStateException("Must be logged into the room to change nickname.");
        }
        Presence joinPresence = new Presence(Presence.Type.available);
        joinPresence.setTo(this.room + "/" + nickname);
        for (PacketInterceptor packetInterceptor : this.presenceInterceptors) {
            packetInterceptor.interceptPacket(joinPresence);
        }
        AndFilter responseFilter = new AndFilter(FromMatchesFilter.createFull(this.room + "/" + nickname), new PacketTypeFilter(Presence.class));
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(joinPresence);
        response.nextResultOrThrow();
        this.nickname = nickname;
    }

    public void changeAvailabilityStatus(String status, Presence.Mode mode) throws SmackException.NotConnectedException {
        if (StringUtils.isNullOrEmpty(this.nickname)) {
            throw new IllegalArgumentException("Nickname must not be null or blank.");
        }
        if (!this.joined) {
            throw new IllegalStateException("Must be logged into the room to change the availability status.");
        }
        Presence joinPresence = new Presence(Presence.Type.available);
        joinPresence.setStatus(status);
        joinPresence.setMode(mode);
        joinPresence.setTo(this.room + "/" + this.nickname);
        for (PacketInterceptor packetInterceptor : this.presenceInterceptors) {
            packetInterceptor.interceptPacket(joinPresence);
        }
        this.connection.sendPacket(joinPresence);
    }

    public void kickParticipant(String nickname, String reason) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(nickname, "none", reason);
    }

    public void grantVoice(Collection<String> nicknames) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(nicknames, "participant");
    }

    public void grantVoice(String nickname) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(nickname, "participant", null);
    }

    public void revokeVoice(Collection<String> nicknames) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(nicknames, "visitor");
    }

    public void revokeVoice(String nickname) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(nickname, "visitor", null);
    }

    public void banUsers(Collection<String> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(jids, "outcast");
    }

    public void banUser(String jid, String reason) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(jid, "outcast", reason);
    }

    public void grantMembership(Collection<String> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(jids, "member");
    }

    public void grantMembership(String jid) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(jid, "member", null);
    }

    public void revokeMembership(Collection<String> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(jids, "none");
    }

    public void revokeMembership(String jid) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(jid, "none", null);
    }

    public void grantModerator(Collection<String> nicknames) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(nicknames, "moderator");
    }

    public void grantModerator(String nickname) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(nickname, "moderator", null);
    }

    public void revokeModerator(Collection<String> nicknames) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(nicknames, "participant");
    }

    public void revokeModerator(String nickname) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeRole(nickname, "participant", null);
    }

    public void grantOwnership(Collection<String> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(jids, "owner");
    }

    public void grantOwnership(String jid) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(jid, "owner", null);
    }

    public void revokeOwnership(Collection<String> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(jids, "admin");
    }

    public void revokeOwnership(String jid) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByAdmin(jid, "admin", null);
    }

    public void grantAdmin(Collection<String> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByOwner(jids, "admin");
    }

    public void grantAdmin(String jid) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByOwner(jid, "admin");
    }

    public void revokeAdmin(Collection<String> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByOwner(jids, "member");
    }

    public void revokeAdmin(String jid) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        this.changeAffiliationByOwner(jid, "member");
    }

    private void changeAffiliationByOwner(String jid, String affiliation) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException {
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.SET);
        MUCOwner.Item item = new MUCOwner.Item(affiliation);
        item.setJid(jid);
        iq.addItem(item);
        this.connection.createPacketCollectorAndSend(iq).nextResultOrThrow();
    }

    private void changeAffiliationByOwner(Collection<String> jids, String affiliation) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.SET);
        for (String jid : jids) {
            MUCOwner.Item item = new MUCOwner.Item(affiliation);
            item.setJid(jid);
            iq.addItem(item);
        }
        this.connection.createPacketCollectorAndSend(iq).nextResultOrThrow();
    }

    private void changeAffiliationByAdmin(String jid, String affiliation, String reason) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.SET);
        MUCAdmin.Item item = new MUCAdmin.Item(affiliation, null);
        item.setJid(jid);
        item.setReason(reason);
        iq.addItem(item);
        this.connection.createPacketCollectorAndSend(iq).nextResultOrThrow();
    }

    private void changeAffiliationByAdmin(Collection<String> jids, String affiliation) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.SET);
        for (String jid : jids) {
            MUCAdmin.Item item = new MUCAdmin.Item(affiliation, null);
            item.setJid(jid);
            iq.addItem(item);
        }
        this.connection.createPacketCollectorAndSend(iq).nextResultOrThrow();
    }

    private void changeRole(String nickname, String role, String reason) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.SET);
        MUCAdmin.Item item = new MUCAdmin.Item(null, role);
        item.setNick(nickname);
        item.setReason(reason);
        iq.addItem(item);
        this.connection.createPacketCollectorAndSend(iq).nextResultOrThrow();
    }

    private void changeRole(Collection<String> nicknames, String role) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.SET);
        for (String nickname : nicknames) {
            MUCAdmin.Item item = new MUCAdmin.Item(null, role);
            item.setNick(nickname);
            iq.addItem(item);
        }
        this.connection.createPacketCollectorAndSend(iq).nextResultOrThrow();
    }

    public int getOccupantsCount() {
        return this.occupantsMap.size();
    }

    public List<String> getOccupants() {
        return Collections.unmodifiableList(new ArrayList<String>(this.occupantsMap.keySet()));
    }

    public Presence getOccupantPresence(String user) {
        return this.occupantsMap.get(user);
    }

    public Occupant getOccupant(String user) {
        Presence presence = this.occupantsMap.get(user);
        if (presence != null) {
            return new Occupant(presence);
        }
        return null;
    }

    public void addParticipantListener(PacketListener listener) {
        this.connection.addPacketListener(listener, this.presenceFilter);
        this.connectionListeners.add(listener);
    }

    public void removeParticipantListener(PacketListener listener) {
        this.connection.removePacketListener(listener);
        this.connectionListeners.remove(listener);
    }

    public Collection<Affiliate> getOwners() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.getAffiliatesByAdmin("owner");
    }

    public Collection<Affiliate> getAdmins() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.getAffiliatesByAdmin("admin");
    }

    public Collection<Affiliate> getMembers() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.getAffiliatesByAdmin("member");
    }

    public Collection<Affiliate> getOutcasts() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.getAffiliatesByAdmin("outcast");
    }

    private Collection<Affiliate> getAffiliatesByAdmin(String affiliation) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.GET);
        MUCAdmin.Item item = new MUCAdmin.Item(affiliation, null);
        iq.addItem(item);
        MUCAdmin answer = (MUCAdmin)this.connection.createPacketCollectorAndSend(iq).nextResultOrThrow();
        ArrayList<Affiliate> affiliates = new ArrayList<Affiliate>();
        for (MUCAdmin.Item mucadminItem : answer.getItems()) {
            affiliates.add(new Affiliate(mucadminItem));
        }
        return affiliates;
    }

    public Collection<Occupant> getModerators() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.getOccupants("moderator");
    }

    public Collection<Occupant> getParticipants() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return this.getOccupants("participant");
    }

    private Collection<Occupant> getOccupants(String role) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.GET);
        MUCAdmin.Item item = new MUCAdmin.Item(null, role);
        iq.addItem(item);
        MUCAdmin answer = (MUCAdmin)this.connection.createPacketCollectorAndSend(iq).nextResultOrThrow();
        ArrayList<Occupant> participants = new ArrayList<Occupant>();
        for (MUCAdmin.Item mucadminItem : answer.getItems()) {
            participants.add(new Occupant(mucadminItem));
        }
        return participants;
    }

    public void sendMessage(String text) throws XMPPException, SmackException.NotConnectedException {
        Message message = new Message(this.room, Message.Type.groupchat);
        message.setBody(text);
        this.connection.sendPacket(message);
    }

    public Chat createPrivateChat(String occupant, MessageListener listener) {
        return ChatManager.getInstanceFor(this.connection).createChat(occupant, listener);
    }

    public Message createMessage() {
        return new Message(this.room, Message.Type.groupchat);
    }

    public void sendMessage(Message message) throws XMPPException, SmackException.NotConnectedException {
        this.connection.sendPacket(message);
    }

    public Message pollMessage() {
        return (Message)this.messageCollector.pollResult();
    }

    public Message nextMessage() {
        return (Message)this.messageCollector.nextResult();
    }

    public Message nextMessage(long timeout) {
        return (Message)this.messageCollector.nextResult(timeout);
    }

    public void addMessageListener(PacketListener listener) {
        this.connection.addPacketListener(listener, this.messageFilter);
        this.connectionListeners.add(listener);
    }

    public void removeMessageListener(PacketListener listener) {
        this.connection.removePacketListener(listener);
        this.connectionListeners.remove(listener);
    }

    public void changeSubject(final String subject) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Message message = new Message(this.room, Message.Type.groupchat);
        message.setSubject(subject);
        AndFilter responseFilter = new AndFilter(FromMatchesFilter.create(this.room), new PacketTypeFilter(Message.class));
        responseFilter = new AndFilter(responseFilter, new PacketFilter(){

            @Override
            public boolean accept(Packet packet) {
                Message msg = (Message)packet;
                return subject.equals(msg.getSubject());
            }
        });
        PacketCollector response = this.connection.createPacketCollector(responseFilter);
        this.connection.sendPacket(message);
        response.nextResultOrThrow();
    }

    private synchronized void userHasLeft() {
        List<String> rooms = joinedRooms.get(this.connection);
        if (rooms == null) {
            return;
        }
        rooms.remove(this.room);
        this.cleanup();
    }

    private MUCUser getMUCUserExtension(Packet packet) {
        if (packet != null) {
            return (MUCUser)packet.getExtension("x", "http://jabber.org/protocol/muc#user");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserStatusListener(UserStatusListener listener) {
        List<UserStatusListener> list = this.userStatusListeners;
        synchronized (list) {
            if (!this.userStatusListeners.contains(listener)) {
                this.userStatusListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserStatusListener(UserStatusListener listener) {
        List<UserStatusListener> list = this.userStatusListeners;
        synchronized (list) {
            this.userStatusListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireUserStatusListeners(String methodName, Object[] params) {
        UserStatusListener[] listeners;
        List<UserStatusListener> list = this.userStatusListeners;
        synchronized (list) {
            listeners = new UserStatusListener[this.userStatusListeners.size()];
            this.userStatusListeners.toArray(listeners);
        }
        Class[] paramClasses = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramClasses[i] = params[i].getClass();
        }
        try {
            Method method = UserStatusListener.class.getDeclaredMethod(methodName, paramClasses);
            for (UserStatusListener listener : listeners) {
                method.invoke((Object)listener, params);
            }
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(Level.SEVERE, "Failed to invoke method on UserStatusListener", e);
        }
        catch (InvocationTargetException e) {
            LOGGER.log(Level.SEVERE, "Failed to invoke method on UserStatusListener", e);
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.SEVERE, "Failed to invoke method on UserStatusListener", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParticipantStatusListener(ParticipantStatusListener listener) {
        List<ParticipantStatusListener> list = this.participantStatusListeners;
        synchronized (list) {
            if (!this.participantStatusListeners.contains(listener)) {
                this.participantStatusListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeParticipantStatusListener(ParticipantStatusListener listener) {
        List<ParticipantStatusListener> list = this.participantStatusListeners;
        synchronized (list) {
            this.participantStatusListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireParticipantStatusListeners(String methodName, List<String> params) {
        ParticipantStatusListener[] listeners;
        List<ParticipantStatusListener> list = this.participantStatusListeners;
        synchronized (list) {
            listeners = new ParticipantStatusListener[this.participantStatusListeners.size()];
            this.participantStatusListeners.toArray(listeners);
        }
        try {
            Class[] classes = new Class[params.size()];
            for (int i = 0; i < params.size(); ++i) {
                classes[i] = String.class;
            }
            Method method = ParticipantStatusListener.class.getDeclaredMethod(methodName, classes);
            for (ParticipantStatusListener listener : listeners) {
                method.invoke((Object)listener, params.toArray());
            }
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(Level.SEVERE, "Failed to invoke method on ParticipantStatusListener", e);
        }
        catch (InvocationTargetException e) {
            LOGGER.log(Level.SEVERE, "Failed to invoke method on ParticipantStatusListener", e);
        }
        catch (IllegalAccessException e) {
            LOGGER.log(Level.SEVERE, "Failed to invoke method on ParticipantStatusListener", e);
        }
    }

    private void init() {
        this.messageFilter = new AndFilter(FromMatchesFilter.create(this.room), new MessageTypeFilter(Message.Type.groupchat));
        this.presenceFilter = new AndFilter(FromMatchesFilter.create(this.room), new PacketTypeFilter(Presence.class));
        this.messageCollector = new ConnectionDetachedPacketCollector();
        PacketListener subjectListener = new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                Message msg = (Message)packet;
                MultiUserChat.this.subject = msg.getSubject();
                MultiUserChat.this.fireSubjectUpdatedListeners(msg.getSubject(), msg.getFrom());
            }
        };
        PacketListener presenceListener = new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                Presence presence = (Presence)packet;
                String from = presence.getFrom();
                String myRoomJID = MultiUserChat.this.room + "/" + MultiUserChat.this.nickname;
                boolean isUserStatusModification = presence.getFrom().equals(myRoomJID);
                if (presence.getType() == Presence.Type.available) {
                    Presence oldPresence = MultiUserChat.this.occupantsMap.put(from, presence);
                    if (oldPresence != null) {
                        MUCUser mucExtension = MultiUserChat.this.getMUCUserExtension(oldPresence);
                        String oldAffiliation = mucExtension.getItem().getAffiliation();
                        String oldRole = mucExtension.getItem().getRole();
                        mucExtension = MultiUserChat.this.getMUCUserExtension(presence);
                        String newAffiliation = mucExtension.getItem().getAffiliation();
                        String newRole = mucExtension.getItem().getRole();
                        MultiUserChat.this.checkRoleModifications(oldRole, newRole, isUserStatusModification, from);
                        MultiUserChat.this.checkAffiliationModifications(oldAffiliation, newAffiliation, isUserStatusModification, from);
                    } else if (!isUserStatusModification) {
                        ArrayList<String> params = new ArrayList<String>();
                        params.add(from);
                        MultiUserChat.this.fireParticipantStatusListeners("joined", params);
                    }
                } else if (presence.getType() == Presence.Type.unavailable) {
                    MultiUserChat.this.occupantsMap.remove(from);
                    MUCUser mucUser = MultiUserChat.this.getMUCUserExtension(presence);
                    if (mucUser != null && mucUser.getStatus() != null) {
                        MultiUserChat.this.checkPresenceCode(mucUser.getStatus().getCode(), presence.getFrom().equals(myRoomJID), mucUser, from);
                    } else if (!isUserStatusModification) {
                        ArrayList<String> params = new ArrayList<String>();
                        params.add(from);
                        MultiUserChat.this.fireParticipantStatusListeners("left", params);
                    }
                }
            }
        };
        PacketListener declinesListener = new PacketListener(){

            @Override
            public void processPacket(Packet packet) {
                MUCUser mucUser = MultiUserChat.this.getMUCUserExtension(packet);
                if (mucUser.getDecline() != null && ((Message)packet).getType() != Message.Type.error) {
                    MultiUserChat.this.fireInvitationRejectionListeners(mucUser.getDecline().getFrom(), mucUser.getDecline().getReason());
                }
            }
        };
        PacketMultiplexListener packetMultiplexor = new PacketMultiplexListener(this.messageCollector, presenceListener, subjectListener, declinesListener);
        this.roomListenerMultiplexor = RoomListenerMultiplexor.getRoomMultiplexor(this.connection);
        this.roomListenerMultiplexor.addRoom(this.room, packetMultiplexor);
    }

    private void checkRoleModifications(String oldRole, String newRole, boolean isUserModification, String from) {
        ArrayList<String> params;
        if (("visitor".equals(oldRole) || "none".equals(oldRole)) && "participant".equals(newRole)) {
            if (isUserModification) {
                this.fireUserStatusListeners("voiceGranted", new Object[0]);
            } else {
                params = new ArrayList<String>();
                params.add(from);
                this.fireParticipantStatusListeners("voiceGranted", params);
            }
        } else if ("participant".equals(oldRole) && ("visitor".equals(newRole) || "none".equals(newRole))) {
            if (isUserModification) {
                this.fireUserStatusListeners("voiceRevoked", new Object[0]);
            } else {
                params = new ArrayList();
                params.add(from);
                this.fireParticipantStatusListeners("voiceRevoked", params);
            }
        }
        if (!"moderator".equals(oldRole) && "moderator".equals(newRole)) {
            if ("visitor".equals(oldRole) || "none".equals(oldRole)) {
                if (isUserModification) {
                    this.fireUserStatusListeners("voiceGranted", new Object[0]);
                } else {
                    params = new ArrayList();
                    params.add(from);
                    this.fireParticipantStatusListeners("voiceGranted", params);
                }
            }
            if (isUserModification) {
                this.fireUserStatusListeners("moderatorGranted", new Object[0]);
            } else {
                params = new ArrayList();
                params.add(from);
                this.fireParticipantStatusListeners("moderatorGranted", params);
            }
        } else if ("moderator".equals(oldRole) && !"moderator".equals(newRole)) {
            if ("visitor".equals(newRole) || "none".equals(newRole)) {
                if (isUserModification) {
                    this.fireUserStatusListeners("voiceRevoked", new Object[0]);
                } else {
                    params = new ArrayList();
                    params.add(from);
                    this.fireParticipantStatusListeners("voiceRevoked", params);
                }
            }
            if (isUserModification) {
                this.fireUserStatusListeners("moderatorRevoked", new Object[0]);
            } else {
                params = new ArrayList();
                params.add(from);
                this.fireParticipantStatusListeners("moderatorRevoked", params);
            }
        }
    }

    private void checkAffiliationModifications(String oldAffiliation, String newAffiliation, boolean isUserModification, String from) {
        ArrayList<String> params;
        if ("owner".equals(oldAffiliation) && !"owner".equals(newAffiliation)) {
            if (isUserModification) {
                this.fireUserStatusListeners("ownershipRevoked", new Object[0]);
            } else {
                params = new ArrayList<String>();
                params.add(from);
                this.fireParticipantStatusListeners("ownershipRevoked", params);
            }
        } else if ("admin".equals(oldAffiliation) && !"admin".equals(newAffiliation)) {
            if (isUserModification) {
                this.fireUserStatusListeners("adminRevoked", new Object[0]);
            } else {
                params = new ArrayList();
                params.add(from);
                this.fireParticipantStatusListeners("adminRevoked", params);
            }
        } else if ("member".equals(oldAffiliation) && !"member".equals(newAffiliation)) {
            if (isUserModification) {
                this.fireUserStatusListeners("membershipRevoked", new Object[0]);
            } else {
                params = new ArrayList();
                params.add(from);
                this.fireParticipantStatusListeners("membershipRevoked", params);
            }
        }
        if (!"owner".equals(oldAffiliation) && "owner".equals(newAffiliation)) {
            if (isUserModification) {
                this.fireUserStatusListeners("ownershipGranted", new Object[0]);
            } else {
                params = new ArrayList();
                params.add(from);
                this.fireParticipantStatusListeners("ownershipGranted", params);
            }
        } else if (!"admin".equals(oldAffiliation) && "admin".equals(newAffiliation)) {
            if (isUserModification) {
                this.fireUserStatusListeners("adminGranted", new Object[0]);
            } else {
                params = new ArrayList();
                params.add(from);
                this.fireParticipantStatusListeners("adminGranted", params);
            }
        } else if (!"member".equals(oldAffiliation) && "member".equals(newAffiliation)) {
            if (isUserModification) {
                this.fireUserStatusListeners("membershipGranted", new Object[0]);
            } else {
                params = new ArrayList();
                params.add(from);
                this.fireParticipantStatusListeners("membershipGranted", params);
            }
        }
    }

    private void checkPresenceCode(String code, boolean isUserModification, MUCUser mucUser, String from) {
        if ("307".equals(code)) {
            if (isUserModification) {
                this.joined = false;
                this.fireUserStatusListeners("kicked", new Object[]{mucUser.getItem().getActor(), mucUser.getItem().getReason()});
                this.occupantsMap.clear();
                this.nickname = null;
                this.userHasLeft();
            } else {
                ArrayList<String> params = new ArrayList<String>();
                params.add(from);
                params.add(mucUser.getItem().getActor());
                params.add(mucUser.getItem().getReason());
                this.fireParticipantStatusListeners("kicked", params);
            }
        } else if ("301".equals(code)) {
            if (isUserModification) {
                this.joined = false;
                this.fireUserStatusListeners("banned", new Object[]{mucUser.getItem().getActor(), mucUser.getItem().getReason()});
                this.occupantsMap.clear();
                this.nickname = null;
                this.userHasLeft();
            } else {
                ArrayList<String> params = new ArrayList<String>();
                params.add(from);
                params.add(mucUser.getItem().getActor());
                params.add(mucUser.getItem().getReason());
                this.fireParticipantStatusListeners("banned", params);
            }
        } else if ("321".equals(code)) {
            if (isUserModification) {
                this.joined = false;
                this.fireUserStatusListeners("membershipRevoked", new Object[0]);
                this.occupantsMap.clear();
                this.nickname = null;
                this.userHasLeft();
            }
        } else if ("303".equals(code)) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(from);
            params.add(mucUser.getItem().getNick());
            this.fireParticipantStatusListeners("nicknameChanged", params);
        }
    }

    private void cleanup() {
        try {
            if (this.connection != null) {
                this.roomListenerMultiplexor.removeRoom(this.room);
                for (PacketListener connectionListener : this.connectionListeners) {
                    this.connection.removePacketListener(connectionListener);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.cleanup();
        super.finalize();
    }

    static {
        XMPPConnection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection connection) {
                ServiceDiscoveryManager.getInstanceFor(connection).addFeature(MultiUserChat.discoNamespace);
                final WeakReference<XMPPConnection> weakRefConnection = new WeakReference<XMPPConnection>(connection);
                ServiceDiscoveryManager.getInstanceFor(connection).setNodeInformationProvider(MultiUserChat.discoNode, new NodeInformationProvider(){

                    @Override
                    public List<DiscoverItems.Item> getNodeItems() {
                        XMPPConnection connection = (XMPPConnection)weakRefConnection.get();
                        if (connection == null) {
                            return new LinkedList<DiscoverItems.Item>();
                        }
                        ArrayList<DiscoverItems.Item> answer = new ArrayList<DiscoverItems.Item>();
                        for (String room : MultiUserChat.getJoinedRooms(connection)) {
                            answer.add(new DiscoverItems.Item(room));
                        }
                        return answer;
                    }

                    @Override
                    public List<String> getNodeFeatures() {
                        return null;
                    }

                    @Override
                    public List<DiscoverInfo.Identity> getNodeIdentities() {
                        return null;
                    }

                    @Override
                    public List<PacketExtension> getNodePacketExtensions() {
                        return null;
                    }
                });
            }
        });
    }

    private static class InvitationsMonitor
    extends AbstractConnectionListener {
        private static final Map<XMPPConnection, WeakReference<InvitationsMonitor>> monitors = new WeakHashMap<XMPPConnection, WeakReference<InvitationsMonitor>>();
        private final List<InvitationListener> invitationsListeners = new ArrayList<InvitationListener>();
        private XMPPConnection connection;
        private PacketFilter invitationFilter;
        private PacketListener invitationPacketListener;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static InvitationsMonitor getInvitationsMonitor(XMPPConnection conn) {
            Map<XMPPConnection, WeakReference<InvitationsMonitor>> map = monitors;
            synchronized (map) {
                if (!monitors.containsKey(conn) || monitors.get(conn).get() == null) {
                    InvitationsMonitor ivm = new InvitationsMonitor(conn);
                    monitors.put(conn, new WeakReference<InvitationsMonitor>(ivm));
                    return ivm;
                }
                return (InvitationsMonitor)monitors.get(conn).get();
            }
        }

        private InvitationsMonitor(XMPPConnection connection) {
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addInvitationListener(InvitationListener listener) {
            List<InvitationListener> list = this.invitationsListeners;
            synchronized (list) {
                if (this.invitationsListeners.size() == 0) {
                    this.init();
                }
                if (!this.invitationsListeners.contains(listener)) {
                    this.invitationsListeners.add(listener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeInvitationListener(InvitationListener listener) {
            List<InvitationListener> list = this.invitationsListeners;
            synchronized (list) {
                if (this.invitationsListeners.contains(listener)) {
                    this.invitationsListeners.remove(listener);
                }
                if (this.invitationsListeners.size() == 0) {
                    this.cancel();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireInvitationListeners(String room, String inviter, String reason, String password, Message message) {
            InvitationListener[] listeners;
            List<InvitationListener> list = this.invitationsListeners;
            synchronized (list) {
                listeners = new InvitationListener[this.invitationsListeners.size()];
                this.invitationsListeners.toArray(listeners);
            }
            for (InvitationListener listener : listeners) {
                listener.invitationReceived(this.connection, room, inviter, reason, password, message);
            }
        }

        @Override
        public void connectionClosed() {
            this.cancel();
        }

        private void init() {
            this.invitationFilter = new PacketExtensionFilter("x", "http://jabber.org/protocol/muc#user");
            this.invitationPacketListener = new PacketListener(){

                @Override
                public void processPacket(Packet packet) {
                    MUCUser mucUser = (MUCUser)packet.getExtension("x", "http://jabber.org/protocol/muc#user");
                    if (mucUser.getInvite() != null && ((Message)packet).getType() != Message.Type.error) {
                        InvitationsMonitor.this.fireInvitationListeners(packet.getFrom(), mucUser.getInvite().getFrom(), mucUser.getInvite().getReason(), mucUser.getPassword(), (Message)packet);
                    }
                }
            };
            this.connection.addPacketListener(this.invitationPacketListener, this.invitationFilter);
            this.connection.addConnectionListener(this);
        }

        private void cancel() {
            this.connection.removePacketListener(this.invitationPacketListener);
            this.connection.removeConnectionListener(this);
        }
    }
}

