/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc.provider;

import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.muc.packet.MUCOwner;
import org.xmlpull.v1.XmlPullParser;

public class MUCOwnerProvider
implements IQProvider {
    @Override
    public IQ parseIQ(XmlPullParser parser) throws Exception {
        MUCOwner mucOwner = new MUCOwner();
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("item")) {
                    mucOwner.addItem(this.parseItem(parser));
                    continue;
                }
                if (parser.getName().equals("destroy")) {
                    mucOwner.setDestroy(this.parseDestroy(parser));
                    continue;
                }
                mucOwner.addExtension(PacketParserUtils.parsePacketExtension(parser.getName(), parser.getNamespace(), parser));
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("query")) continue;
            done = true;
        }
        return mucOwner;
    }

    private MUCOwner.Item parseItem(XmlPullParser parser) throws Exception {
        boolean done = false;
        MUCOwner.Item item = new MUCOwner.Item(parser.getAttributeValue("", "affiliation"));
        item.setNick(parser.getAttributeValue("", "nick"));
        item.setRole(parser.getAttributeValue("", "role"));
        item.setJid(parser.getAttributeValue("", "jid"));
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (parser.getName().equals("actor")) {
                    item.setActor(parser.getAttributeValue("", "jid"));
                }
                if (!parser.getName().equals("reason")) continue;
                item.setReason(parser.nextText());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("item")) continue;
            done = true;
        }
        return item;
    }

    private MUCOwner.Destroy parseDestroy(XmlPullParser parser) throws Exception {
        boolean done = false;
        MUCOwner.Destroy destroy = new MUCOwner.Destroy();
        destroy.setJid(parser.getAttributeValue("", "jid"));
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                if (!parser.getName().equals("reason")) continue;
                destroy.setReason(parser.nextText());
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("destroy")) continue;
            done = true;
        }
        return destroy;
    }
}

