/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.offline.packet;

import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.xmlpull.v1.XmlPullParser;

public class OfflineMessageInfo
implements PacketExtension {
    private String node = null;

    @Override
    public String getElementName() {
        return "offline";
    }

    @Override
    public String getNamespace() {
        return "http://jabber.org/protocol/offline";
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    @Override
    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<").append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\">");
        if (this.getNode() != null) {
            buf.append("<item node=\"").append(this.getNode()).append("\"/>");
        }
        buf.append("</").append(this.getElementName()).append(">");
        return buf.toString();
    }

    public static class Provider
    implements PacketExtensionProvider {
        @Override
        public PacketExtension parseExtension(XmlPullParser parser) throws Exception {
            OfflineMessageInfo info = new OfflineMessageInfo();
            boolean done = false;
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2) {
                    if (!parser.getName().equals("item")) continue;
                    info.setNode(parser.getAttributeValue("", "node"));
                    continue;
                }
                if (eventType != 3 || !parser.getName().equals("offline")) continue;
                done = true;
            }
            return info;
        }
    }
}

