/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.search;

import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.search.ReportedData;
import org.jivesoftware.smackx.search.SimpleUserSearch;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.xmlpull.v1.XmlPullParser;

public class UserSearch
extends IQ {
    @Override
    public String getChildElementXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<query xmlns=\"jabber:iq:search\">");
        buf.append(this.getExtensionsXML());
        buf.append("</query>");
        return buf.toString();
    }

    public Form getSearchForm(XMPPConnection con, String searchService) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        UserSearch search = new UserSearch();
        search.setType(IQ.Type.GET);
        search.setTo(searchService);
        IQ response = (IQ)con.createPacketCollectorAndSend(search).nextResultOrThrow();
        return Form.getFormFrom(response);
    }

    public ReportedData sendSearchForm(XMPPConnection con, Form searchForm, String searchService) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        UserSearch search = new UserSearch();
        search.setType(IQ.Type.SET);
        search.setTo(searchService);
        search.addExtension(searchForm.getDataFormToSend());
        IQ response = (IQ)con.createPacketCollectorAndSend(search).nextResultOrThrow();
        return ReportedData.getReportedDataFrom(response);
    }

    public ReportedData sendSimpleSearchForm(XMPPConnection con, Form searchForm, String searchService) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        SimpleUserSearch search = new SimpleUserSearch();
        search.setForm(searchForm);
        search.setType(IQ.Type.SET);
        search.setTo(searchService);
        SimpleUserSearch response = (SimpleUserSearch)con.createPacketCollectorAndSend(search).nextResultOrThrow();
        return response.getReportedData();
    }

    private static void buildDataForm(SimpleUserSearch search, String instructions, XmlPullParser parser) throws Exception {
        DataForm dataForm = new DataForm("form");
        boolean done = false;
        dataForm.setTitle("User Search");
        dataForm.addInstruction(instructions);
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2 && !parser.getNamespace().equals("jabber:x:data")) {
                String name = parser.getName();
                FormField field = new FormField(name);
                if (name.equals("first")) {
                    field.setLabel("First Name");
                } else if (name.equals("last")) {
                    field.setLabel("Last Name");
                } else if (name.equals("email")) {
                    field.setLabel("Email Address");
                } else if (name.equals("nick")) {
                    field.setLabel("Nickname");
                }
                field.setType("text-single");
                dataForm.addField(field);
                continue;
            }
            if (eventType == 3) {
                if (!parser.getName().equals("query")) continue;
                done = true;
                continue;
            }
            if (eventType != 2 || !parser.getNamespace().equals("jabber:x:data")) continue;
            search.addExtension(PacketParserUtils.parsePacketExtension(parser.getName(), parser.getNamespace(), parser));
            done = true;
        }
        if (search.getExtension("x", "jabber:x:data") == null) {
            search.addExtension(dataForm);
        }
    }

    public static class Provider
    implements IQProvider {
        @Override
        public IQ parseIQ(XmlPullParser parser) throws Exception {
            UserSearch search = null;
            SimpleUserSearch simpleUserSearch = new SimpleUserSearch();
            boolean done = false;
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2 && parser.getName().equals("instructions")) {
                    UserSearch.buildDataForm(simpleUserSearch, parser.nextText(), parser);
                    return simpleUserSearch;
                }
                if (eventType == 2 && parser.getName().equals("item")) {
                    simpleUserSearch.parseItems(parser);
                    return simpleUserSearch;
                }
                if (eventType == 2 && parser.getNamespace().equals("jabber:x:data")) {
                    search = new UserSearch();
                    search.addExtension(PacketParserUtils.parsePacketExtension(parser.getName(), parser.getNamespace(), parser));
                    continue;
                }
                if (eventType != 3 || !parser.getName().equals("query")) continue;
                done = true;
            }
            if (search != null) {
                return search;
            }
            return simpleUserSearch;
        }
    }
}

