/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.vcardtemp.packet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.StringUtils;

public class VCard
extends IQ {
    private static final Logger LOGGER = Logger.getLogger(VCard.class.getName());
    private static final String DEFAULT_MIME_TYPE = "image/jpeg";
    private Map<String, String> homePhones = new HashMap<String, String>();
    private Map<String, String> workPhones = new HashMap<String, String>();
    private Map<String, String> homeAddr = new HashMap<String, String>();
    private Map<String, String> workAddr = new HashMap<String, String>();
    private String firstName;
    private String lastName;
    private String middleName;
    private String emailHome;
    private String emailWork;
    private String organization;
    private String organizationUnit;
    private String photoMimeType;
    private String photoBinval;
    private Map<String, String> otherSimpleFields = new HashMap<String, String>();
    private Map<String, String> otherUnescapableFields = new HashMap<String, String>();

    public String getField(String field) {
        return this.otherSimpleFields.get(field);
    }

    public void setField(String field, String value) {
        this.setField(field, value, false);
    }

    public void setField(String field, String value, boolean isUnescapable) {
        if (!isUnescapable) {
            this.otherSimpleFields.put(field, value);
        } else {
            this.otherUnescapableFields.put(field, value);
        }
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
        this.updateFN();
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
        this.updateFN();
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
        this.updateFN();
    }

    public String getNickName() {
        return this.otherSimpleFields.get("NICKNAME");
    }

    public void setNickName(String nickName) {
        this.otherSimpleFields.put("NICKNAME", nickName);
    }

    public String getEmailHome() {
        return this.emailHome;
    }

    public void setEmailHome(String email) {
        this.emailHome = email;
    }

    public String getEmailWork() {
        return this.emailWork;
    }

    public void setEmailWork(String emailWork) {
        this.emailWork = emailWork;
    }

    public String getJabberId() {
        return this.otherSimpleFields.get("JABBERID");
    }

    public void setJabberId(String jabberId) {
        this.otherSimpleFields.put("JABBERID", jabberId);
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getOrganizationUnit() {
        return this.organizationUnit;
    }

    public void setOrganizationUnit(String organizationUnit) {
        this.organizationUnit = organizationUnit;
    }

    public String getAddressFieldHome(String addrField) {
        return this.homeAddr.get(addrField);
    }

    public void setAddressFieldHome(String addrField, String value) {
        this.homeAddr.put(addrField, value);
    }

    public String getAddressFieldWork(String addrField) {
        return this.workAddr.get(addrField);
    }

    public void setAddressFieldWork(String addrField, String value) {
        this.workAddr.put(addrField, value);
    }

    public void setPhoneHome(String phoneType, String phoneNum) {
        this.homePhones.put(phoneType, phoneNum);
    }

    public String getPhoneHome(String phoneType) {
        return this.homePhones.get(phoneType);
    }

    public void setPhoneWork(String phoneType, String phoneNum) {
        this.workPhones.put(phoneType, phoneNum);
    }

    public String getPhoneWork(String phoneType) {
        return this.workPhones.get(phoneType);
    }

    public void setAvatar(URL avatarURL) {
        byte[] bytes = new byte[]{};
        try {
            bytes = VCard.getBytes(avatarURL);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error getting bytes from URL: " + avatarURL, e);
        }
        this.setAvatar(bytes);
    }

    public void removeAvatar() {
        this.photoBinval = null;
        this.photoMimeType = null;
    }

    public void setAvatar(byte[] bytes) {
        this.setAvatar(bytes, DEFAULT_MIME_TYPE);
    }

    public void setAvatar(byte[] bytes, String mimeType) {
        if (bytes == null) {
            this.removeAvatar();
            return;
        }
        String encodedImage = StringUtils.encodeBase64(bytes);
        this.setAvatar(encodedImage, mimeType);
    }

    public void setAvatar(String encodedImage, String mimeType) {
        this.photoBinval = encodedImage;
        this.photoMimeType = mimeType;
    }

    public void setEncodedImage(String encodedAvatar) {
        this.setAvatar(encodedAvatar, DEFAULT_MIME_TYPE);
    }

    public byte[] getAvatar() {
        if (this.photoBinval == null) {
            return null;
        }
        return StringUtils.decodeBase64(this.photoBinval);
    }

    public String getAvatarMimeType() {
        return this.photoMimeType;
    }

    public static byte[] getBytes(URL url) throws IOException {
        String path = url.getPath();
        File file = new File(path);
        if (file.exists()) {
            return VCard.getFileBytes(file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getFileBytes(File file) throws IOException {
        try (BufferedInputStream bis = null;){
            bis = new BufferedInputStream(new FileInputStream(file));
            int bytes = (int)file.length();
            byte[] buffer = new byte[bytes];
            int readBytes = bis.read(buffer);
            if (readBytes != buffer.length) {
                throw new IOException("Entire file not read");
            }
            byte[] byArray = buffer;
            return byArray;
        }
    }

    public String getAvatarHash() {
        MessageDigest digest;
        byte[] bytes = this.getAvatar();
        if (bytes == null) {
            return null;
        }
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.log(Level.SEVERE, "Failed to get message digest", e);
            return null;
        }
        digest.update(bytes);
        return StringUtils.encodeHex(digest.digest());
    }

    private void updateFN() {
        StringBuilder sb = new StringBuilder();
        if (this.firstName != null) {
            sb.append(StringUtils.escapeForXML(this.firstName)).append(' ');
        }
        if (this.middleName != null) {
            sb.append(StringUtils.escapeForXML(this.middleName)).append(' ');
        }
        if (this.lastName != null) {
            sb.append(StringUtils.escapeForXML(this.lastName));
        }
        this.setField("FN", sb.toString());
    }

    public void save(XMPPConnection connection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.checkAuthenticated(connection, true);
        this.setType(IQ.Type.SET);
        this.setFrom(connection.getUser());
        connection.createPacketCollectorAndSend(this).nextResultOrThrow();
    }

    public void load(XMPPConnection connection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.checkAuthenticated(connection, true);
        this.setFrom(connection.getUser());
        this.doLoad(connection, connection.getUser());
    }

    public void load(XMPPConnection connection, String user) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.checkAuthenticated(connection, false);
        this.setTo(user);
        this.doLoad(connection, user);
    }

    private void doLoad(XMPPConnection connection, String user) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        this.setType(IQ.Type.GET);
        VCard result = (VCard)connection.createPacketCollectorAndSend(this).nextResultOrThrow();
        this.copyFieldsFrom(result);
    }

    @Override
    public String getChildElementXML() {
        StringBuilder sb = new StringBuilder();
        new VCardWriter(sb).write();
        return sb.toString();
    }

    private void copyFieldsFrom(VCard from) {
        Field[] fields;
        for (Field field : fields = VCard.class.getDeclaredFields()) {
            if (field.getDeclaringClass() != VCard.class || Modifier.isFinal(field.getModifiers())) continue;
            try {
                field.setAccessible(true);
                field.set(this, field.get(from));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("This cannot happen:" + field, e);
            }
        }
    }

    private void checkAuthenticated(XMPPConnection connection, boolean checkForAnonymous) {
        if (connection == null) {
            throw new IllegalArgumentException("No connection was provided");
        }
        if (!connection.isAuthenticated()) {
            throw new IllegalArgumentException("XMPPConnection is not authenticated");
        }
        if (checkForAnonymous && connection.isAnonymous()) {
            throw new IllegalArgumentException("XMPPConnection cannot be anonymous");
        }
    }

    private boolean hasContent() {
        return this.hasNameField() || this.hasOrganizationFields() || this.emailHome != null || this.emailWork != null || this.otherSimpleFields.size() > 0 || this.otherUnescapableFields.size() > 0 || this.homeAddr.size() > 0 || this.homePhones.size() > 0 || this.workAddr.size() > 0 || this.workPhones.size() > 0 || this.photoBinval != null;
    }

    private boolean hasNameField() {
        return this.firstName != null || this.lastName != null || this.middleName != null;
    }

    private boolean hasOrganizationFields() {
        return this.organization != null || this.organizationUnit != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VCard vCard = (VCard)o;
        if (this.emailHome != null ? !this.emailHome.equals(vCard.emailHome) : vCard.emailHome != null) {
            return false;
        }
        if (this.emailWork != null ? !this.emailWork.equals(vCard.emailWork) : vCard.emailWork != null) {
            return false;
        }
        if (this.firstName != null ? !this.firstName.equals(vCard.firstName) : vCard.firstName != null) {
            return false;
        }
        if (!this.homeAddr.equals(vCard.homeAddr)) {
            return false;
        }
        if (!this.homePhones.equals(vCard.homePhones)) {
            return false;
        }
        if (this.lastName != null ? !this.lastName.equals(vCard.lastName) : vCard.lastName != null) {
            return false;
        }
        if (this.middleName != null ? !this.middleName.equals(vCard.middleName) : vCard.middleName != null) {
            return false;
        }
        if (this.organization != null ? !this.organization.equals(vCard.organization) : vCard.organization != null) {
            return false;
        }
        if (this.organizationUnit != null ? !this.organizationUnit.equals(vCard.organizationUnit) : vCard.organizationUnit != null) {
            return false;
        }
        if (!this.otherSimpleFields.equals(vCard.otherSimpleFields)) {
            return false;
        }
        if (!this.workAddr.equals(vCard.workAddr)) {
            return false;
        }
        if (this.photoBinval != null ? !this.photoBinval.equals(vCard.photoBinval) : vCard.photoBinval != null) {
            return false;
        }
        return this.workPhones.equals(vCard.workPhones);
    }

    @Override
    public int hashCode() {
        int result = this.homePhones.hashCode();
        result = 29 * result + this.workPhones.hashCode();
        result = 29 * result + this.homeAddr.hashCode();
        result = 29 * result + this.workAddr.hashCode();
        result = 29 * result + (this.firstName != null ? this.firstName.hashCode() : 0);
        result = 29 * result + (this.lastName != null ? this.lastName.hashCode() : 0);
        result = 29 * result + (this.middleName != null ? this.middleName.hashCode() : 0);
        result = 29 * result + (this.emailHome != null ? this.emailHome.hashCode() : 0);
        result = 29 * result + (this.emailWork != null ? this.emailWork.hashCode() : 0);
        result = 29 * result + (this.organization != null ? this.organization.hashCode() : 0);
        result = 29 * result + (this.organizationUnit != null ? this.organizationUnit.hashCode() : 0);
        result = 29 * result + this.otherSimpleFields.hashCode();
        result = 29 * result + (this.photoBinval != null ? this.photoBinval.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return this.getChildElementXML();
    }

    private static interface ContentBuilder {
        public void addTagContent();
    }

    private class VCardWriter {
        private final StringBuilder sb;

        VCardWriter(StringBuilder sb) {
            this.sb = sb;
        }

        public void write() {
            this.appendTag("vCard", "xmlns", "vcard-temp", VCard.this.hasContent(), new ContentBuilder(){

                @Override
                public void addTagContent() {
                    VCardWriter.this.buildActualContent();
                }
            });
        }

        private void buildActualContent() {
            if (VCard.this.hasNameField()) {
                this.appendN();
            }
            this.appendOrganization();
            this.appendGenericFields();
            this.appendPhoto();
            this.appendEmail(VCard.this.emailWork, "WORK");
            this.appendEmail(VCard.this.emailHome, "HOME");
            this.appendPhones(VCard.this.workPhones, "WORK");
            this.appendPhones(VCard.this.homePhones, "HOME");
            this.appendAddress(VCard.this.workAddr, "WORK");
            this.appendAddress(VCard.this.homeAddr, "HOME");
        }

        private void appendPhoto() {
            if (VCard.this.photoBinval == null) {
                return;
            }
            this.appendTag("PHOTO", true, new ContentBuilder(){

                @Override
                public void addTagContent() {
                    VCardWriter.this.appendTag("BINVAL", VCard.this.photoBinval);
                    VCardWriter.this.appendTag("TYPE", StringUtils.escapeForXML(VCard.this.photoMimeType));
                }
            });
        }

        private void appendEmail(final String email, final String type) {
            if (email != null) {
                this.appendTag("EMAIL", true, new ContentBuilder(){

                    @Override
                    public void addTagContent() {
                        VCardWriter.this.appendEmptyTag(type);
                        VCardWriter.this.appendEmptyTag("INTERNET");
                        VCardWriter.this.appendEmptyTag("PREF");
                        VCardWriter.this.appendTag("USERID", StringUtils.escapeForXML(email));
                    }
                });
            }
        }

        private void appendPhones(Map<String, String> phones, final String code) {
            for (final Map.Entry<String, String> entry : phones.entrySet()) {
                this.appendTag("TEL", true, new ContentBuilder(){

                    @Override
                    public void addTagContent() {
                        VCardWriter.this.appendEmptyTag(entry.getKey());
                        VCardWriter.this.appendEmptyTag(code);
                        VCardWriter.this.appendTag("NUMBER", StringUtils.escapeForXML((String)entry.getValue()));
                    }
                });
            }
        }

        private void appendAddress(final Map<String, String> addr, final String code) {
            if (addr.size() > 0) {
                this.appendTag("ADR", true, new ContentBuilder(){

                    @Override
                    public void addTagContent() {
                        VCardWriter.this.appendEmptyTag(code);
                        for (Map.Entry entry : addr.entrySet()) {
                            VCardWriter.this.appendTag((String)entry.getKey(), StringUtils.escapeForXML((String)entry.getValue()));
                        }
                    }
                });
            }
        }

        private void appendEmptyTag(Object tag) {
            this.sb.append('<').append(tag).append("/>");
        }

        private void appendGenericFields() {
            for (Map.Entry entry : VCard.this.otherSimpleFields.entrySet()) {
                this.appendTag(((String)entry.getKey()).toString(), StringUtils.escapeForXML((String)entry.getValue()));
            }
            for (Map.Entry entry : VCard.this.otherUnescapableFields.entrySet()) {
                this.appendTag(((String)entry.getKey()).toString(), (CharSequence)entry.getValue());
            }
        }

        private void appendOrganization() {
            if (VCard.this.hasOrganizationFields()) {
                this.appendTag("ORG", true, new ContentBuilder(){

                    @Override
                    public void addTagContent() {
                        VCardWriter.this.appendTag("ORGNAME", StringUtils.escapeForXML(VCard.this.organization));
                        VCardWriter.this.appendTag("ORGUNIT", StringUtils.escapeForXML(VCard.this.organizationUnit));
                    }
                });
            }
        }

        private void appendN() {
            this.appendTag("N", true, new ContentBuilder(){

                @Override
                public void addTagContent() {
                    VCardWriter.this.appendTag("FAMILY", StringUtils.escapeForXML(VCard.this.lastName));
                    VCardWriter.this.appendTag("GIVEN", StringUtils.escapeForXML(VCard.this.firstName));
                    VCardWriter.this.appendTag("MIDDLE", StringUtils.escapeForXML(VCard.this.middleName));
                }
            });
        }

        private void appendTag(String tag, String attr, String attrValue, boolean hasContent, ContentBuilder builder) {
            this.sb.append('<').append(tag);
            if (attr != null) {
                this.sb.append(' ').append(attr).append('=').append('\'').append(attrValue).append('\'');
            }
            if (hasContent) {
                this.sb.append('>');
                builder.addTagContent();
                this.sb.append("</").append(tag).append(">\n");
            } else {
                this.sb.append("/>\n");
            }
        }

        private void appendTag(String tag, boolean hasContent, ContentBuilder builder) {
            this.appendTag(tag, null, null, hasContent, builder);
        }

        private void appendTag(String tag, final CharSequence tagText) {
            if (tagText == null) {
                return;
            }
            ContentBuilder contentBuilder = new ContentBuilder(){

                @Override
                public void addTagContent() {
                    VCardWriter.this.sb.append(tagText.toString().trim());
                }
            };
            this.appendTag(tag, true, contentBuilder);
        }
    }
}

