/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xhtmlim.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.packet.PacketExtension;

public class XHTMLExtension
implements PacketExtension {
    private List<String> bodies = new ArrayList<String>();

    @Override
    public String getElementName() {
        return "html";
    }

    @Override
    public String getNamespace() {
        return "http://jabber.org/protocol/xhtml-im";
    }

    @Override
    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<").append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\">");
        for (String body : this.getBodies()) {
            buf.append(body);
        }
        buf.append("</").append(this.getElementName()).append(">");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getBodies() {
        List<String> list = this.bodies;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<String>(this.bodies));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBody(String body) {
        List<String> list = this.bodies;
        synchronized (list) {
            this.bodies.add(body);
        }
    }

    public int getBodiesCount() {
        return this.bodies.size();
    }
}

