/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sm.provider;

import java.io.IOException;
import java.util.ArrayList;
import org.jivesoftware.smack.packet.StanzaErrorTextElement;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.sm.packet.StreamManagement;
import org.jivesoftware.smack.util.ParserUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ParseStreamManagement {
    public static StreamManagement.Enabled enabled(XmlPullParser parser) throws XmlPullParserException, IOException {
        ParserUtils.assertAtStartTag(parser);
        boolean resume = ParserUtils.getBooleanAttribute(parser, "resume", false);
        String id = parser.getAttributeValue("", "id");
        String location = parser.getAttributeValue("", "location");
        int max = ParserUtils.getIntegerAttribute(parser, "max", -1);
        parser.next();
        ParserUtils.assertAtEndTag(parser);
        return new StreamManagement.Enabled(id, resume, location, max);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static StreamManagement.Failed failed(XmlPullParser parser) throws XmlPullParserException, IOException {
        ParserUtils.assertAtStartTag(parser);
        XMPPError.Condition condition = null;
        ArrayList<StanzaErrorTextElement> textElements = new ArrayList<StanzaErrorTextElement>(4);
        block4: while (true) {
            int event = parser.next();
            switch (event) {
                case 2: {
                    String name = parser.getName();
                    String namespace = parser.getNamespace();
                    if (!"urn:ietf:params:xml:ns:xmpp-stanzas".equals(namespace)) break;
                    if (name.equals("text")) {
                        String lang = ParserUtils.getXmlLang(parser);
                        String text = parser.nextText();
                        StanzaErrorTextElement stanzaErrorTextElement = new StanzaErrorTextElement(text, lang);
                        textElements.add(stanzaErrorTextElement);
                        break;
                    }
                    condition = XMPPError.Condition.fromString(name);
                    break;
                }
                case 3: {
                    String name = parser.getName();
                    if ("failed".equals(name)) break block4;
                }
            }
        }
        ParserUtils.assertAtEndTag(parser);
        return new StreamManagement.Failed(condition, textElements);
    }

    public static StreamManagement.Resumed resumed(XmlPullParser parser) throws XmlPullParserException, IOException {
        ParserUtils.assertAtStartTag(parser);
        long h = ParserUtils.getLongAttribute(parser, "h");
        String previd = parser.getAttributeValue("", "previd");
        parser.next();
        ParserUtils.assertAtEndTag(parser);
        return new StreamManagement.Resumed(h, previd);
    }

    public static StreamManagement.AckAnswer ackAnswer(XmlPullParser parser) throws XmlPullParserException, IOException {
        ParserUtils.assertAtStartTag(parser);
        long h = ParserUtils.getLongAttribute(parser, "h");
        parser.next();
        ParserUtils.assertAtEndTag(parser);
        return new StreamManagement.AckAnswer(h);
    }

    public static StreamManagement.AckRequest ackRequest(XmlPullParser parser) throws XmlPullParserException, IOException {
        ParserUtils.assertAtStartTag(parser);
        parser.next();
        ParserUtils.assertAtEndTag(parser);
        return StreamManagement.AckRequest.INSTANCE;
    }
}

