/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.dns.javax;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.initializer.SmackInitializer;
import org.jivesoftware.smack.util.DNSUtil;
import org.jivesoftware.smack.util.dns.DNSResolver;
import org.jivesoftware.smack.util.dns.HostAddress;
import org.jivesoftware.smack.util.dns.SRVRecord;

public class JavaxResolver
extends DNSResolver
implements SmackInitializer {
    private static JavaxResolver instance;
    private static DirContext dirContext;

    public static synchronized DNSResolver getInstance() {
        if (instance == null && JavaxResolver.isSupported()) {
            instance = new JavaxResolver();
        }
        return instance;
    }

    public static boolean isSupported() {
        return dirContext != null;
    }

    public static void setup() {
        DNSUtil.setDNSResolver(JavaxResolver.getInstance());
    }

    public JavaxResolver() {
        super(false);
    }

    @Override
    protected List<SRVRecord> lookupSRVRecords0(String name, List<HostAddress> failedAddresses, ConnectionConfiguration.DnssecMode dnssecMode) {
        Attribute srvAttribute;
        ArrayList<SRVRecord> res = null;
        try {
            Attributes dnsLookup = dirContext.getAttributes(name, new String[]{"SRV"});
            srvAttribute = dnsLookup.get("SRV");
            if (srvAttribute == null) {
                return null;
            }
        }
        catch (NameNotFoundException e) {
            LOGGER.log(Level.FINEST, "No DNS SRV RR found for " + name, e);
            return null;
        }
        catch (NamingException e) {
            LOGGER.log(Level.WARNING, "Exception while resolving DNS SRV RR for " + name, e);
            return null;
        }
        try {
            NamingEnumeration<?> srvRecords = srvAttribute.getAll();
            res = new ArrayList<SRVRecord>();
            while (srvRecords.hasMore()) {
                String srvRecordString = (String)srvRecords.next();
                String[] srvRecordEntries = srvRecordString.split(" ");
                int priority = Integer.parseInt(srvRecordEntries[srvRecordEntries.length - 4]);
                int port = Integer.parseInt(srvRecordEntries[srvRecordEntries.length - 2]);
                int weight = Integer.parseInt(srvRecordEntries[srvRecordEntries.length - 3]);
                String host = srvRecordEntries[srvRecordEntries.length - 1];
                List<InetAddress> hostAddresses = this.lookupHostAddress0(host, failedAddresses, dnssecMode);
                if (this.shouldContinue(name, host, hostAddresses)) continue;
                SRVRecord srvRecord = new SRVRecord(host, port, priority, weight, hostAddresses);
                res.add(srvRecord);
            }
        }
        catch (NamingException e) {
            LOGGER.log(Level.SEVERE, "Exception while resolving DNS SRV RR for" + name, e);
        }
        return res;
    }

    @Override
    public List<Exception> initialize() {
        JavaxResolver.setup();
        return null;
    }

    static {
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            dirContext = new InitialDirContext(env);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JavaxResolver.setup();
    }
}

