/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.address;

import java.util.ArrayList;
import java.util.Collection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.address.MultipleRecipientInfo;
import org.jivesoftware.smackx.address.packet.MultipleAddresses;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;

public class MultipleRecipientManager {
    public static void send(XMPPConnection connection, Stanza packet, Collection<? extends Jid> to, Collection<? extends Jid> cc, Collection<? extends Jid> bcc) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.FeatureNotSupportedException, SmackException.NotConnectedException, InterruptedException {
        MultipleRecipientManager.send(connection, packet, to, cc, bcc, null, null, false);
    }

    public static void send(XMPPConnection connection, Stanza packet, Collection<? extends Jid> to, Collection<? extends Jid> cc, Collection<? extends Jid> bcc, Jid replyTo, Jid replyRoom, boolean noReply) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.FeatureNotSupportedException, SmackException.NotConnectedException, InterruptedException {
        if (to != null && to.size() == 1 && (cc == null || cc.isEmpty()) && (bcc == null || bcc.isEmpty()) && !noReply && StringUtils.isNullOrEmpty((CharSequence)replyTo) && StringUtils.isNullOrEmpty((CharSequence)replyRoom)) {
            Jid toJid = to.iterator().next();
            packet.setTo(toJid);
            connection.sendStanza(packet);
            return;
        }
        DomainBareJid serviceAddress = MultipleRecipientManager.getMultipleRecipientServiceAddress(connection);
        if (serviceAddress != null) {
            MultipleRecipientManager.sendThroughService(connection, packet, to, cc, bcc, replyTo, replyRoom, noReply, serviceAddress);
        } else {
            if (noReply || replyTo != null || replyRoom != null) {
                throw new SmackException.FeatureNotSupportedException("Extended Stanza Addressing");
            }
            MultipleRecipientManager.sendToIndividualRecipients(connection, packet, to, cc, bcc);
        }
    }

    public static void reply(XMPPConnection connection, Message original, Message reply) throws SmackException, XMPPException.XMPPErrorException, InterruptedException {
        MultipleAddresses.Address replyAddress;
        MultipleRecipientInfo info = MultipleRecipientManager.getMultipleRecipientInfo(original);
        if (info == null) {
            throw new SmackException("Original message does not contain multiple recipient info");
        }
        if (info.shouldNotReply()) {
            throw new SmackException("Original message should not be replied");
        }
        if (info.getReplyRoom() != null) {
            throw new SmackException("Reply should be sent through a room");
        }
        if (original.getThread() != null) {
            reply.setThread(original.getThread());
        }
        if ((replyAddress = info.getReplyAddress()) != null && replyAddress.getJid() != null) {
            reply.setTo(replyAddress.getJid());
            connection.sendStanza(reply);
        } else {
            EntityFullJid from;
            ArrayList<Jid> to = new ArrayList<Jid>(info.getTOAddresses().size());
            ArrayList<Jid> cc = new ArrayList<Jid>(info.getCCAddresses().size());
            for (MultipleAddresses.Address jid : info.getTOAddresses()) {
                to.add(jid.getJid());
            }
            for (MultipleAddresses.Address jid : info.getCCAddresses()) {
                cc.add(jid.getJid());
            }
            if (!to.contains(original.getFrom()) && !cc.contains(original.getFrom())) {
                to.add(original.getFrom());
            }
            if (!to.remove(from = connection.getUser()) && !cc.remove(from)) {
                EntityBareJid bareJID = from.asEntityBareJid();
                to.remove(bareJID);
                cc.remove(bareJID);
            }
            MultipleRecipientManager.send(connection, reply, to, cc, null, null, null, false);
        }
    }

    public static MultipleRecipientInfo getMultipleRecipientInfo(Stanza packet) {
        MultipleAddresses extension = (MultipleAddresses)packet.getExtension("addresses", "http://jabber.org/protocol/address");
        return extension == null ? null : new MultipleRecipientInfo(extension);
    }

    private static void sendToIndividualRecipients(XMPPConnection connection, Stanza packet, Collection<? extends Jid> to, Collection<? extends Jid> cc, Collection<? extends Jid> bcc) throws SmackException.NotConnectedException, InterruptedException {
        if (to != null) {
            for (Jid jid : to) {
                packet.setTo(jid);
                connection.sendStanza(new PacketCopy(packet.toXML()));
            }
        }
        if (cc != null) {
            for (Jid jid : cc) {
                packet.setTo(jid);
                connection.sendStanza(new PacketCopy(packet.toXML()));
            }
        }
        if (bcc != null) {
            for (Jid jid : bcc) {
                packet.setTo(jid);
                connection.sendStanza(new PacketCopy(packet.toXML()));
            }
        }
    }

    private static void sendThroughService(XMPPConnection connection, Stanza packet, Collection<? extends Jid> to, Collection<? extends Jid> cc, Collection<? extends Jid> bcc, Jid replyTo, Jid replyRoom, boolean noReply, DomainBareJid serviceAddress) throws SmackException.NotConnectedException, InterruptedException {
        MultipleAddresses multipleAddresses = new MultipleAddresses();
        if (to != null) {
            for (Jid jid : to) {
                multipleAddresses.addAddress(MultipleAddresses.Type.to, jid, null, null, false, null);
            }
        }
        if (cc != null) {
            for (Jid jid : cc) {
                multipleAddresses.addAddress(MultipleAddresses.Type.to, jid, null, null, false, null);
            }
        }
        if (bcc != null) {
            for (Jid jid : bcc) {
                multipleAddresses.addAddress(MultipleAddresses.Type.bcc, jid, null, null, false, null);
            }
        }
        if (noReply) {
            multipleAddresses.setNoReply();
        } else {
            if (replyTo != null) {
                multipleAddresses.addAddress(MultipleAddresses.Type.replyto, replyTo, null, null, false, null);
            }
            if (replyRoom != null) {
                multipleAddresses.addAddress(MultipleAddresses.Type.replyroom, replyRoom, null, null, false, null);
            }
        }
        packet.setTo(serviceAddress);
        packet.addExtension(multipleAddresses);
        connection.sendStanza(packet);
    }

    private static DomainBareJid getMultipleRecipientServiceAddress(XMPPConnection connection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor(connection);
        return sdm.findService("http://jabber.org/protocol/address", true);
    }

    private static class PacketCopy
    extends Stanza {
        private final CharSequence text;

        public PacketCopy(CharSequence text) {
            this.text = text;
        }

        @Override
        public CharSequence toXML() {
            return this.text;
        }

        @Override
        public String toString() {
            return this.toXML().toString();
        }
    }
}

