/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Data;

class DataListener
extends AbstractIqRequestHandler {
    private final InBandBytestreamManager manager;

    public DataListener(InBandBytestreamManager manager) {
        super("data", "http://jabber.org/protocol/ibb", IQ.Type.set, IQRequestHandler.Mode.async);
        this.manager = manager;
    }

    @Override
    public IQ handleIQRequest(IQ iqRequest) {
        Data data = (Data)iqRequest;
        InBandBytestreamSession ibbSession = this.manager.getSessions().get(data.getDataPacketExtension().getSessionID());
        try {
            if (ibbSession == null) {
                this.manager.replyItemNotFoundPacket(data);
            } else {
                ibbSession.processIQPacket(data);
            }
        }
        catch (InterruptedException | SmackException.NotConnectedException | SmackException.NotLoggedInException e) {
            return null;
        }
        return null;
    }
}

