/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.delay.provider;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smackx.delay.packet.DelayInformation;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class AbstractDelayInformationProvider
extends ExtensionElementProvider<DelayInformation> {
    @Override
    public final DelayInformation parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException, SmackException {
        Date stamp;
        String stampString = parser.getAttributeValue("", "stamp");
        String from = parser.getAttributeValue("", "from");
        String reason = null;
        if (!parser.isEmptyElementTag()) {
            int event = parser.next();
            switch (event) {
                case 4: {
                    reason = parser.getText();
                    parser.next();
                    break;
                }
                case 3: {
                    reason = "";
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected event: " + event);
                }
            }
        } else {
            parser.next();
        }
        try {
            stamp = this.parseDate(stampString);
        }
        catch (ParseException e) {
            throw new SmackException(e);
        }
        return new DelayInformation(stamp, from, reason);
    }

    protected abstract Date parseDate(String var1) throws ParseException;
}

