/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.disco.provider;

import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.xmlpull.v1.XmlPullParser;

public class DiscoverInfoProvider
extends IQProvider<DiscoverInfo> {
    @Override
    public DiscoverInfo parse(XmlPullParser parser, int initialDepth) throws Exception {
        DiscoverInfo discoverInfo = new DiscoverInfo();
        boolean done = false;
        String category = "";
        String identityName = "";
        String type = "";
        String variable = "";
        String lang = "";
        discoverInfo.setNode(parser.getAttributeValue("", "node"));
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2) {
                String name = parser.getName();
                String namespace = parser.getNamespace();
                if (namespace.equals("http://jabber.org/protocol/disco#info")) {
                    switch (name) {
                        case "identity": {
                            category = parser.getAttributeValue("", "category");
                            identityName = parser.getAttributeValue("", "name");
                            type = parser.getAttributeValue("", "type");
                            lang = parser.getAttributeValue(parser.getNamespace("xml"), "lang");
                            break;
                        }
                        case "feature": {
                            variable = parser.getAttributeValue("", "var");
                        }
                    }
                    continue;
                }
                PacketParserUtils.addExtensionElement(discoverInfo, parser);
                continue;
            }
            if (eventType != 3) continue;
            if (parser.getName().equals("identity")) {
                DiscoverInfo.Identity identity = new DiscoverInfo.Identity(category, type, identityName, lang);
                discoverInfo.addIdentity(identity);
            }
            if (parser.getName().equals("feature")) {
                boolean notADuplicateFeature = discoverInfo.addFeature(variable);
                assert (notADuplicateFeature);
            }
            if (!parser.getName().equals("query")) continue;
            done = true;
        }
        return discoverInfo;
    }
}

