/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.filetransfer.FileTransferListener;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.IncomingFileTransfer;
import org.jivesoftware.smackx.filetransfer.OutgoingFileTransfer;
import org.jivesoftware.smackx.si.packet.StreamInitiation;
import org.jxmpp.jid.EntityFullJid;

public final class FileTransferManager
extends Manager {
    private static final Map<XMPPConnection, FileTransferManager> INSTANCES = new WeakHashMap<XMPPConnection, FileTransferManager>();
    private final FileTransferNegotiator fileTransferNegotiator;
    private final List<FileTransferListener> listeners = new CopyOnWriteArrayList<FileTransferListener>();

    public static synchronized FileTransferManager getInstanceFor(XMPPConnection connection) {
        FileTransferManager fileTransferManager = INSTANCES.get(connection);
        if (fileTransferManager == null) {
            fileTransferManager = new FileTransferManager(connection);
            INSTANCES.put(connection, fileTransferManager);
        }
        return fileTransferManager;
    }

    private FileTransferManager(XMPPConnection connection) {
        super(connection);
        this.fileTransferNegotiator = FileTransferNegotiator.getInstanceFor(connection);
        connection.registerIQRequestHandler(new AbstractIqRequestHandler("si", "http://jabber.org/protocol/si", IQ.Type.set, IQRequestHandler.Mode.async){

            @Override
            public IQ handleIQRequest(IQ packet) {
                StreamInitiation si = (StreamInitiation)packet;
                FileTransferRequest request = new FileTransferRequest(FileTransferManager.this, si);
                for (FileTransferListener listener : FileTransferManager.this.listeners) {
                    listener.fileTransferRequest(request);
                }
                return null;
            }
        });
    }

    public void addFileTransferListener(FileTransferListener li) {
        this.listeners.add(li);
    }

    public void removeFileTransferListener(FileTransferListener li) {
        this.listeners.remove(li);
    }

    public OutgoingFileTransfer createOutgoingFileTransfer(EntityFullJid userID) {
        if (userID == null) {
            throw new IllegalArgumentException("userID was null");
        }
        return new OutgoingFileTransfer(this.connection().getUser(), userID, FileTransferNegotiator.getNextStreamID(), this.fileTransferNegotiator);
    }

    protected IncomingFileTransfer createIncomingFileTransfer(FileTransferRequest request) {
        if (request == null) {
            throw new NullPointerException("RecieveRequest cannot be null");
        }
        IncomingFileTransfer transfer = new IncomingFileTransfer(request, this.fileTransferNegotiator);
        transfer.setFileInfo(request.getFileName(), request.getFileSize());
        return transfer;
    }

    protected void rejectIncomingFileTransfer(FileTransferRequest request) throws SmackException.NotConnectedException, InterruptedException {
        StreamInitiation initiation = request.getStreamInitiation();
        ErrorIQ rejection = IQ.createErrorResponse((IQ)initiation, XMPPError.getBuilder(XMPPError.Condition.forbidden));
        this.connection().sendStanza(rejection);
    }
}

