/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PresenceListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.chat.Chat;
import org.jivesoftware.smack.chat.ChatManager;
import org.jivesoftware.smack.chat.ChatMessageListener;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.MessageWithBodiesFilter;
import org.jivesoftware.smack.filter.MessageWithSubjectFilter;
import org.jivesoftware.smack.filter.MessageWithThreadFilter;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.PresenceTypeFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaIdFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.filter.ToMatchesFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.iqregister.packet.Registration;
import org.jivesoftware.smackx.muc.Affiliate;
import org.jivesoftware.smackx.muc.DiscussionHistory;
import org.jivesoftware.smackx.muc.InvitationRejectionListener;
import org.jivesoftware.smackx.muc.MUCAffiliation;
import org.jivesoftware.smackx.muc.MUCRole;
import org.jivesoftware.smackx.muc.MucConfigFormManager;
import org.jivesoftware.smackx.muc.MucEnterConfiguration;
import org.jivesoftware.smackx.muc.MultiUserChatException;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jivesoftware.smackx.muc.Occupant;
import org.jivesoftware.smackx.muc.ParticipantStatusListener;
import org.jivesoftware.smackx.muc.SubjectUpdatedListener;
import org.jivesoftware.smackx.muc.UserStatusListener;
import org.jivesoftware.smackx.muc.filter.MUCUserStatusCodeFilter;
import org.jivesoftware.smackx.muc.packet.Destroy;
import org.jivesoftware.smackx.muc.packet.MUCAdmin;
import org.jivesoftware.smackx.muc.packet.MUCItem;
import org.jivesoftware.smackx.muc.packet.MUCOwner;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.EntityJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.util.cache.ExpirationCache;

public class MultiUserChat {
    private static final Logger LOGGER = Logger.getLogger(MultiUserChat.class.getName());
    private static final ExpirationCache<DomainBareJid, Void> KNOWN_MUC_SERVICES = new ExpirationCache(100, 86400000L);
    private final XMPPConnection connection;
    private final EntityBareJid room;
    private final MultiUserChatManager multiUserChatManager;
    private final Map<EntityFullJid, Presence> occupantsMap = new ConcurrentHashMap<EntityFullJid, Presence>();
    private final Set<InvitationRejectionListener> invitationRejectionListeners = new CopyOnWriteArraySet<InvitationRejectionListener>();
    private final Set<SubjectUpdatedListener> subjectUpdatedListeners = new CopyOnWriteArraySet<SubjectUpdatedListener>();
    private final Set<UserStatusListener> userStatusListeners = new CopyOnWriteArraySet<UserStatusListener>();
    private final Set<ParticipantStatusListener> participantStatusListeners = new CopyOnWriteArraySet<ParticipantStatusListener>();
    private final Set<MessageListener> messageListeners = new CopyOnWriteArraySet<MessageListener>();
    private final Set<PresenceListener> presenceListeners = new CopyOnWriteArraySet<PresenceListener>();
    private final Set<PresenceListener> presenceInterceptors = new CopyOnWriteArraySet<PresenceListener>();
    private final StanzaFilter fromRoomFilter;
    private final StanzaFilter fromRoomGroupchatFilter;
    private final StanzaListener presenceInterceptor;
    private final StanzaListener messageListener;
    private final StanzaListener presenceListener;
    private final StanzaListener subjectListener;
    private static final StanzaFilter DECLINE_FILTER = new AndFilter(MessageTypeFilter.NORMAL, new StanzaExtensionFilter("x", "http://jabber.org/protocol/muc#user"));
    private final StanzaListener declinesListener;
    private String subject;
    private Resourcepart nickname;
    private boolean joined = false;
    private StanzaCollector messageCollector;

    MultiUserChat(XMPPConnection connection, EntityBareJid room, MultiUserChatManager multiUserChatManager) {
        this.connection = connection;
        this.room = room;
        this.multiUserChatManager = multiUserChatManager;
        this.fromRoomFilter = FromMatchesFilter.create(room);
        this.fromRoomGroupchatFilter = new AndFilter(this.fromRoomFilter, MessageTypeFilter.GROUPCHAT);
        this.messageListener = new StanzaListener(){

            @Override
            public void processStanza(Stanza packet) throws SmackException.NotConnectedException {
                Message message = (Message)packet;
                for (MessageListener listener : MultiUserChat.this.messageListeners) {
                    listener.processMessage(message);
                }
            }
        };
        this.subjectListener = new StanzaListener(){

            @Override
            public void processStanza(Stanza packet) {
                Message msg = (Message)packet;
                EntityFullJid from = msg.getFrom().asEntityFullJidIfPossible();
                MultiUserChat.this.subject = msg.getSubject();
                for (SubjectUpdatedListener listener : MultiUserChat.this.subjectUpdatedListeners) {
                    listener.subjectUpdated(MultiUserChat.this.subject, from);
                }
            }
        };
        this.presenceListener = new StanzaListener(){

            @Override
            public void processStanza(Stanza packet) {
                Presence presence = (Presence)packet;
                EntityFullJid from = presence.getFrom().asEntityFullJidIfPossible();
                if (from == null) {
                    LOGGER.warning("Presence not from a full JID: " + presence.getFrom());
                    return;
                }
                String myRoomJID = MultiUserChat.this.room + "/" + MultiUserChat.this.nickname;
                boolean isUserStatusModification = presence.getFrom().equals(myRoomJID);
                switch (presence.getType()) {
                    case available: {
                        Presence oldPresence = MultiUserChat.this.occupantsMap.put(from, presence);
                        if (oldPresence != null) {
                            Object mucExtension = MUCUser.from(oldPresence);
                            MUCAffiliation oldAffiliation = ((MUCUser)mucExtension).getItem().getAffiliation();
                            MUCRole oldRole = ((MUCUser)mucExtension).getItem().getRole();
                            mucExtension = MUCUser.from(packet);
                            MUCAffiliation newAffiliation = ((MUCUser)mucExtension).getItem().getAffiliation();
                            MUCRole newRole = ((MUCUser)mucExtension).getItem().getRole();
                            MultiUserChat.this.checkRoleModifications(oldRole, newRole, isUserStatusModification, from);
                            MultiUserChat.this.checkAffiliationModifications(oldAffiliation, newAffiliation, isUserStatusModification, from);
                            break;
                        }
                        if (isUserStatusModification) break;
                        for (ParticipantStatusListener listener : MultiUserChat.this.participantStatusListeners) {
                            listener.joined(from);
                        }
                        break;
                    }
                    case unavailable: {
                        MultiUserChat.this.occupantsMap.remove(from);
                        MUCUser mucUser = MUCUser.from(packet);
                        if (mucUser != null && mucUser.hasStatus()) {
                            MultiUserChat.this.checkPresenceCode(mucUser.getStatus(), presence.getFrom().equals(myRoomJID), mucUser, from);
                            break;
                        }
                        if (isUserStatusModification) break;
                        for (ParticipantStatusListener listener : MultiUserChat.this.participantStatusListeners) {
                            listener.left(from);
                        }
                        break;
                    }
                }
                for (PresenceListener listener : MultiUserChat.this.presenceListeners) {
                    listener.processPresence(presence);
                }
            }
        };
        this.declinesListener = new StanzaListener(){

            @Override
            public void processStanza(Stanza packet) {
                Message message = (Message)packet;
                MUCUser mucUser = MUCUser.from(packet);
                MUCUser.Decline rejection = mucUser.getDecline();
                if (rejection == null) {
                    return;
                }
                MultiUserChat.this.fireInvitationRejectionListeners(message, rejection);
            }
        };
        this.presenceInterceptor = new StanzaListener(){

            @Override
            public void processStanza(Stanza packet) {
                Presence presence = (Presence)packet;
                for (PresenceListener interceptor : MultiUserChat.this.presenceInterceptors) {
                    interceptor.processPresence(presence);
                }
            }
        };
    }

    public EntityBareJid getRoom() {
        return this.room;
    }

    private Presence enter(MucEnterConfiguration conf) throws SmackException.NotConnectedException, SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.NotAMucServiceException {
        Presence presence;
        DomainBareJid mucService = this.room.asDomainBareJid();
        if (!KNOWN_MUC_SERVICES.containsKey(mucService)) {
            if (this.multiUserChatManager.providesMucService(mucService)) {
                KNOWN_MUC_SERVICES.put(mucService, null);
            } else {
                throw new MultiUserChatException.NotAMucServiceException(this);
            }
        }
        Presence joinPresence = conf.getJoinPresence(this);
        this.connection.addSyncStanzaListener(this.messageListener, this.fromRoomGroupchatFilter);
        this.connection.addSyncStanzaListener(this.presenceListener, new AndFilter(this.fromRoomFilter, StanzaTypeFilter.PRESENCE));
        this.connection.addSyncStanzaListener(this.subjectListener, new AndFilter(this.fromRoomFilter, MessageWithSubjectFilter.INSTANCE, new NotFilter(MessageTypeFilter.ERROR), new NotFilter(MessageWithBodiesFilter.INSTANCE), new NotFilter(MessageWithThreadFilter.INSTANCE)));
        this.connection.addSyncStanzaListener(this.declinesListener, new AndFilter(this.fromRoomFilter, DECLINE_FILTER));
        this.connection.addPacketInterceptor(this.presenceInterceptor, new AndFilter(ToMatchesFilter.create(this.room), StanzaTypeFilter.PRESENCE));
        this.messageCollector = this.connection.createStanzaCollector(this.fromRoomGroupchatFilter);
        AndFilter responseFilter = new AndFilter(StanzaTypeFilter.PRESENCE, new OrFilter(new AndFilter(FromMatchesFilter.createBare(this.getRoom()), MUCUserStatusCodeFilter.STATUS_110_PRESENCE_TO_SELF), new AndFilter(FromMatchesFilter.createFull(joinPresence.getTo()), new StanzaIdFilter(joinPresence), PresenceTypeFilter.ERROR)));
        try {
            presence = (Presence)this.connection.createStanzaCollectorAndSend(responseFilter, joinPresence).nextResultOrThrow(conf.getTimeout());
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
            this.removeConnectionCallbacks();
            throw e;
        }
        this.nickname = presence.getFrom().asEntityFullJidIfPossible().getResourcepart();
        this.joined = true;
        this.multiUserChatManager.addJoinedRoom(this.room);
        return presence;
    }

    public MucEnterConfiguration.Builder getEnterConfigurationBuilder(Resourcepart nickname) {
        return new MucEnterConfiguration.Builder(nickname, this.connection.getReplyTimeout());
    }

    public synchronized MucCreateConfigFormHandle create(Resourcepart nickname) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.MucAlreadyJoinedException, SmackException.NotConnectedException, MultiUserChatException.MissingMucCreationAcknowledgeException, MultiUserChatException.NotAMucServiceException {
        if (this.joined) {
            throw new MultiUserChatException.MucAlreadyJoinedException();
        }
        MucCreateConfigFormHandle mucCreateConfigFormHandle = this.createOrJoin(nickname);
        if (mucCreateConfigFormHandle != null) {
            return mucCreateConfigFormHandle;
        }
        this.leave();
        throw new MultiUserChatException.MissingMucCreationAcknowledgeException();
    }

    public synchronized MucCreateConfigFormHandle createOrJoin(Resourcepart nickname) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.MucAlreadyJoinedException, SmackException.NotConnectedException, MultiUserChatException.NotAMucServiceException {
        MucEnterConfiguration mucEnterConfiguration = this.getEnterConfigurationBuilder(nickname).build();
        return this.createOrJoin(mucEnterConfiguration);
    }

    @Deprecated
    public MucCreateConfigFormHandle createOrJoin(Resourcepart nickname, String password, DiscussionHistory history, long timeout) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.MucAlreadyJoinedException, SmackException.NotConnectedException, MultiUserChatException.NotAMucServiceException {
        MucEnterConfiguration.Builder builder = this.getEnterConfigurationBuilder(nickname).withPassword(password).timeoutAfter(timeout);
        return this.createOrJoin(builder.build());
    }

    public synchronized MucCreateConfigFormHandle createOrJoin(MucEnterConfiguration mucEnterConfiguration) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, MultiUserChatException.MucAlreadyJoinedException, SmackException.NotConnectedException, MultiUserChatException.NotAMucServiceException {
        if (this.joined) {
            throw new MultiUserChatException.MucAlreadyJoinedException();
        }
        Presence presence = this.enter(mucEnterConfiguration);
        MUCUser mucUser = MUCUser.from(presence);
        if (mucUser != null && mucUser.getStatus().contains(MUCUser.Status.ROOM_CREATED_201)) {
            return new MucCreateConfigFormHandle();
        }
        return null;
    }

    public MucCreateConfigFormHandle createOrJoinIfNecessary(Resourcepart nickname, String password) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, MultiUserChatException.NotAMucServiceException {
        if (this.isJoined()) {
            return null;
        }
        MucEnterConfiguration mucEnterConfiguration = this.getEnterConfigurationBuilder(nickname).withPassword(password).build();
        try {
            return this.createOrJoin(mucEnterConfiguration);
        }
        catch (MultiUserChatException.MucAlreadyJoinedException e) {
            return null;
        }
    }

    public void join(Resourcepart nickname) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, MultiUserChatException.NotAMucServiceException {
        MucEnterConfiguration.Builder builder = this.getEnterConfigurationBuilder(nickname);
        this.join(builder.build());
    }

    public void join(Resourcepart nickname, String password) throws XMPPException.XMPPErrorException, InterruptedException, SmackException.NoResponseException, SmackException.NotConnectedException, MultiUserChatException.NotAMucServiceException {
        MucEnterConfiguration.Builder builder = this.getEnterConfigurationBuilder(nickname).withPassword(password);
        this.join(builder.build());
    }

    @Deprecated
    public void join(Resourcepart nickname, String password, DiscussionHistory history, long timeout) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException, MultiUserChatException.NotAMucServiceException {
        MucEnterConfiguration.Builder builder = this.getEnterConfigurationBuilder(nickname).withPassword(password).timeoutAfter(timeout);
        this.join(builder.build());
    }

    public synchronized void join(MucEnterConfiguration mucEnterConfiguration) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException, MultiUserChatException.NotAMucServiceException {
        if (this.joined) {
            this.leave();
        }
        this.enter(mucEnterConfiguration);
    }

    public boolean isJoined() {
        return this.joined;
    }

    public synchronized void leave() throws SmackException.NotConnectedException, InterruptedException {
        this.userHasLeft();
        Presence leavePresence = new Presence(Presence.Type.unavailable);
        leavePresence.setTo(JidCreate.fullFrom(this.room, this.nickname));
        this.connection.sendStanza(leavePresence);
    }

    public MucConfigFormManager getConfigFormManager() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return new MucConfigFormManager(this);
    }

    public Form getConfigurationForm() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.get);
        IQ answer = (IQ)this.connection.createStanzaCollectorAndSend(iq).nextResultOrThrow();
        return Form.getFormFrom(answer);
    }

    public void sendConfigurationForm(Form form) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.set);
        iq.addExtension(form.getDataFormToSend());
        this.connection.createStanzaCollectorAndSend(iq).nextResultOrThrow();
    }

    public Form getRegistrationForm() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Registration reg = new Registration();
        reg.setType(IQ.Type.get);
        reg.setTo(this.room);
        IQ result = (IQ)this.connection.createStanzaCollectorAndSend(reg).nextResultOrThrow();
        return Form.getFormFrom(result);
    }

    public void sendRegistrationForm(Form form) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Registration reg = new Registration();
        reg.setType(IQ.Type.set);
        reg.setTo(this.room);
        reg.addExtension(form.getDataFormToSend());
        this.connection.createStanzaCollectorAndSend(reg).nextResultOrThrow();
    }

    public void destroy(String reason, EntityBareJid alternateJID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCOwner iq = new MUCOwner();
        iq.setTo(this.room);
        iq.setType(IQ.Type.set);
        Destroy destroy = new Destroy(alternateJID, reason);
        iq.setDestroy(destroy);
        try {
            this.connection.createStanzaCollectorAndSend(iq).nextResultOrThrow();
        }
        catch (XMPPException.XMPPErrorException e) {
            throw e;
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException e) {
            this.userHasLeft();
            throw e;
        }
        this.userHasLeft();
    }

    public void invite(EntityBareJid user, String reason) throws SmackException.NotConnectedException, InterruptedException {
        this.invite(new Message(), user, reason);
    }

    public void invite(Message message, EntityBareJid user, String reason) throws SmackException.NotConnectedException, InterruptedException {
        message.setTo(this.room);
        MUCUser mucUser = new MUCUser();
        MUCUser.Invite invite = new MUCUser.Invite(reason, user);
        mucUser.setInvite(invite);
        message.addExtension(mucUser);
        this.connection.sendStanza(message);
    }

    public boolean addInvitationRejectionListener(InvitationRejectionListener listener) {
        return this.invitationRejectionListeners.add(listener);
    }

    public boolean removeInvitationRejectionListener(InvitationRejectionListener listener) {
        return this.invitationRejectionListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInvitationRejectionListeners(Message message, MUCUser.Decline rejection) {
        EntityBareJid invitee = rejection.getFrom();
        String reason = rejection.getReason();
        InvitationRejectionListener[] invitationRejectionListenerArray = this.invitationRejectionListeners;
        synchronized (this.invitationRejectionListeners) {
            InvitationRejectionListener[] listeners = new InvitationRejectionListener[this.invitationRejectionListeners.size()];
            this.invitationRejectionListeners.toArray(listeners);
            // ** MonitorExit[var6_5] (shouldn't be in output)
            for (InvitationRejectionListener listener : listeners) {
                listener.invitationDeclined(invitee, reason, message, rejection);
            }
            return;
        }
    }

    public boolean addSubjectUpdatedListener(SubjectUpdatedListener listener) {
        return this.subjectUpdatedListeners.add(listener);
    }

    public boolean removeSubjectUpdatedListener(SubjectUpdatedListener listener) {
        return this.subjectUpdatedListeners.remove(listener);
    }

    public void addPresenceInterceptor(PresenceListener presenceInterceptor) {
        this.presenceInterceptors.add(presenceInterceptor);
    }

    public void removePresenceInterceptor(PresenceListener presenceInterceptor) {
        this.presenceInterceptors.remove(presenceInterceptor);
    }

    public String getSubject() {
        return this.subject;
    }

    public String getReservedNickname() throws SmackException, InterruptedException {
        try {
            DiscoverInfo result = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverInfo(this.room, "x-roomuser-item");
            Iterator<DiscoverInfo.Identity> iterator = result.getIdentities().iterator();
            if (iterator.hasNext()) {
                DiscoverInfo.Identity identity = iterator.next();
                return identity.getName();
            }
        }
        catch (XMPPException e) {
            LOGGER.log(Level.SEVERE, "Error retrieving room nickname", e);
        }
        return null;
    }

    public Resourcepart getNickname() {
        return this.nickname;
    }

    public synchronized void changeNickname(Resourcepart nickname) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, MultiUserChatException.MucNotJoinedException {
        StringUtils.requireNotNullOrEmpty(nickname, "Nickname must not be null or blank.");
        if (!this.joined) {
            throw new MultiUserChatException.MucNotJoinedException(this);
        }
        EntityFullJid jid = JidCreate.fullFrom(this.room, nickname);
        Presence joinPresence = new Presence(Presence.Type.available);
        joinPresence.setTo(jid);
        AndFilter responseFilter = new AndFilter(FromMatchesFilter.createFull(jid), new StanzaTypeFilter(Presence.class));
        StanzaCollector response = this.connection.createStanzaCollectorAndSend(responseFilter, joinPresence);
        response.nextResultOrThrow();
        this.nickname = nickname;
    }

    public void changeAvailabilityStatus(String status, Presence.Mode mode) throws SmackException.NotConnectedException, InterruptedException, MultiUserChatException.MucNotJoinedException {
        StringUtils.requireNotNullOrEmpty(this.nickname, "Nickname must not be null or blank.");
        if (!this.joined) {
            throw new MultiUserChatException.MucNotJoinedException(this);
        }
        Presence joinPresence = new Presence(Presence.Type.available);
        joinPresence.setStatus(status);
        joinPresence.setMode(mode);
        joinPresence.setTo(JidCreate.fullFrom(this.room, this.nickname));
        this.connection.sendStanza(joinPresence);
    }

    public void kickParticipant(Resourcepart nickname, String reason) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeRole(nickname, MUCRole.none, reason);
    }

    public void requestVoice() throws SmackException.NotConnectedException, InterruptedException {
        DataForm form = new DataForm(DataForm.Type.submit);
        FormField formTypeField = new FormField("FORM_TYPE");
        formTypeField.addValue("http://jabber.org/protocol/muc#request");
        form.addField(formTypeField);
        FormField requestVoiceField = new FormField("muc#role");
        requestVoiceField.setType(FormField.Type.text_single);
        requestVoiceField.setLabel("Requested role");
        requestVoiceField.addValue("participant");
        form.addField(requestVoiceField);
        Message message = new Message(this.room);
        message.addExtension(form);
        this.connection.sendStanza(message);
    }

    public void grantVoice(Collection<Resourcepart> nicknames) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeRole(nicknames, MUCRole.participant);
    }

    public void grantVoice(Resourcepart nickname) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeRole(nickname, MUCRole.participant, null);
    }

    public void revokeVoice(Collection<Resourcepart> nicknames) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeRole(nicknames, MUCRole.visitor);
    }

    public void revokeVoice(Resourcepart nickname) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeRole(nickname, MUCRole.visitor, null);
    }

    public void banUsers(Collection<? extends Jid> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jids, MUCAffiliation.outcast);
    }

    public void banUser(Jid jid, String reason) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jid, MUCAffiliation.outcast, reason);
    }

    public void grantMembership(Collection<? extends Jid> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jids, MUCAffiliation.member);
    }

    public void grantMembership(Jid jid) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jid, MUCAffiliation.member, null);
    }

    public void revokeMembership(Collection<? extends Jid> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jids, MUCAffiliation.none);
    }

    public void revokeMembership(Jid jid) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jid, MUCAffiliation.none, null);
    }

    public void grantModerator(Collection<Resourcepart> nicknames) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeRole(nicknames, MUCRole.moderator);
    }

    public void grantModerator(Resourcepart nickname) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeRole(nickname, MUCRole.moderator, null);
    }

    public void revokeModerator(Collection<Resourcepart> nicknames) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeRole(nicknames, MUCRole.participant);
    }

    public void revokeModerator(Resourcepart nickname) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeRole(nickname, MUCRole.participant, null);
    }

    public void grantOwnership(Collection<? extends Jid> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jids, MUCAffiliation.owner);
    }

    public void grantOwnership(Jid jid) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jid, MUCAffiliation.owner, null);
    }

    public void revokeOwnership(Collection<? extends Jid> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jids, MUCAffiliation.admin);
    }

    public void revokeOwnership(Jid jid) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jid, MUCAffiliation.admin, null);
    }

    public void grantAdmin(Collection<? extends Jid> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jids, MUCAffiliation.admin);
    }

    public void grantAdmin(Jid jid) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jid, MUCAffiliation.admin);
    }

    public void revokeAdmin(Collection<? extends Jid> jids) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jids, MUCAffiliation.admin);
    }

    public void revokeAdmin(EntityJid jid) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jid, MUCAffiliation.member);
    }

    private void changeAffiliationByAdmin(Jid jid, MUCAffiliation affiliation) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.changeAffiliationByAdmin(jid, affiliation, null);
    }

    private void changeAffiliationByAdmin(Jid jid, MUCAffiliation affiliation, String reason) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.set);
        MUCItem item = new MUCItem(affiliation, jid, reason);
        iq.addItem(item);
        this.connection.createStanzaCollectorAndSend(iq).nextResultOrThrow();
    }

    private void changeAffiliationByAdmin(Collection<? extends Jid> jids, MUCAffiliation affiliation) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.set);
        for (Jid jid : jids) {
            MUCItem item = new MUCItem(affiliation, jid);
            iq.addItem(item);
        }
        this.connection.createStanzaCollectorAndSend(iq).nextResultOrThrow();
    }

    private void changeRole(Resourcepart nickname, MUCRole role, String reason) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.set);
        MUCItem item = new MUCItem(role, nickname, reason);
        iq.addItem(item);
        this.connection.createStanzaCollectorAndSend(iq).nextResultOrThrow();
    }

    private void changeRole(Collection<Resourcepart> nicknames, MUCRole role) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.set);
        for (Resourcepart nickname : nicknames) {
            MUCItem item = new MUCItem(role, nickname);
            iq.addItem(item);
        }
        this.connection.createStanzaCollectorAndSend(iq).nextResultOrThrow();
    }

    public int getOccupantsCount() {
        return this.occupantsMap.size();
    }

    public List<EntityFullJid> getOccupants() {
        return new ArrayList<EntityFullJid>(this.occupantsMap.keySet());
    }

    public Presence getOccupantPresence(EntityFullJid user) {
        return this.occupantsMap.get(user);
    }

    public Occupant getOccupant(EntityFullJid user) {
        Presence presence = this.getOccupantPresence(user);
        if (presence != null) {
            return new Occupant(presence);
        }
        return null;
    }

    public boolean addParticipantListener(PresenceListener listener) {
        return this.presenceListeners.add(listener);
    }

    public boolean removeParticipantListener(PresenceListener listener) {
        return this.presenceListeners.remove(listener);
    }

    public List<Affiliate> getOwners() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getAffiliatesByAdmin(MUCAffiliation.owner);
    }

    public List<Affiliate> getAdmins() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getAffiliatesByAdmin(MUCAffiliation.admin);
    }

    public List<Affiliate> getMembers() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getAffiliatesByAdmin(MUCAffiliation.member);
    }

    public List<Affiliate> getOutcasts() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getAffiliatesByAdmin(MUCAffiliation.outcast);
    }

    private List<Affiliate> getAffiliatesByAdmin(MUCAffiliation affiliation) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.get);
        MUCItem item = new MUCItem(affiliation);
        iq.addItem(item);
        MUCAdmin answer = (MUCAdmin)this.connection.createStanzaCollectorAndSend(iq).nextResultOrThrow();
        ArrayList<Affiliate> affiliates = new ArrayList<Affiliate>();
        for (MUCItem mucadminItem : answer.getItems()) {
            affiliates.add(new Affiliate(mucadminItem));
        }
        return affiliates;
    }

    public List<Occupant> getModerators() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getOccupants(MUCRole.moderator);
    }

    public List<Occupant> getParticipants() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getOccupants(MUCRole.participant);
    }

    private List<Occupant> getOccupants(MUCRole role) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCAdmin iq = new MUCAdmin();
        iq.setTo(this.room);
        iq.setType(IQ.Type.get);
        MUCItem item = new MUCItem(role);
        iq.addItem(item);
        MUCAdmin answer = (MUCAdmin)this.connection.createStanzaCollectorAndSend(iq).nextResultOrThrow();
        ArrayList<Occupant> participants = new ArrayList<Occupant>();
        for (MUCItem mucadminItem : answer.getItems()) {
            participants.add(new Occupant(mucadminItem));
        }
        return participants;
    }

    public void sendMessage(String text) throws SmackException.NotConnectedException, InterruptedException {
        Message message = this.createMessage();
        message.setBody(text);
        this.connection.sendStanza(message);
    }

    public Chat createPrivateChat(EntityFullJid occupant, ChatMessageListener listener) {
        return ChatManager.getInstanceFor(this.connection).createChat(occupant, listener);
    }

    public Message createMessage() {
        return new Message((Jid)this.room, Message.Type.groupchat);
    }

    public void sendMessage(Message message) throws SmackException.NotConnectedException, InterruptedException {
        message.setTo(this.room);
        message.setType(Message.Type.groupchat);
        this.connection.sendStanza(message);
    }

    public Message pollMessage() throws MultiUserChatException.MucNotJoinedException {
        if (this.messageCollector == null) {
            throw new MultiUserChatException.MucNotJoinedException(this);
        }
        return (Message)this.messageCollector.pollResult();
    }

    public Message nextMessage() throws MultiUserChatException.MucNotJoinedException, InterruptedException {
        if (this.messageCollector == null) {
            throw new MultiUserChatException.MucNotJoinedException(this);
        }
        return (Message)this.messageCollector.nextResult();
    }

    public Message nextMessage(long timeout) throws MultiUserChatException.MucNotJoinedException, InterruptedException {
        if (this.messageCollector == null) {
            throw new MultiUserChatException.MucNotJoinedException(this);
        }
        return (Message)this.messageCollector.nextResult(timeout);
    }

    public boolean addMessageListener(MessageListener listener) {
        return this.messageListeners.add(listener);
    }

    public boolean removeMessageListener(MessageListener listener) {
        return this.messageListeners.remove(listener);
    }

    public void changeSubject(final String subject) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Message message = this.createMessage();
        message.setSubject(subject);
        AndFilter responseFilter = new AndFilter(this.fromRoomGroupchatFilter, new StanzaFilter(){

            @Override
            public boolean accept(Stanza packet) {
                Message msg = (Message)packet;
                return subject.equals(msg.getSubject());
            }
        });
        StanzaCollector response = this.connection.createStanzaCollectorAndSend(responseFilter, message);
        response.nextResultOrThrow();
    }

    private void removeConnectionCallbacks() {
        this.connection.removeSyncStanzaListener(this.messageListener);
        this.connection.removeSyncStanzaListener(this.presenceListener);
        this.connection.removeSyncStanzaListener(this.subjectListener);
        this.connection.removeSyncStanzaListener(this.declinesListener);
        this.connection.removePacketInterceptor(this.presenceInterceptor);
        if (this.messageCollector != null) {
            this.messageCollector.cancel();
            this.messageCollector = null;
        }
    }

    private synchronized void userHasLeft() {
        this.occupantsMap.clear();
        this.joined = false;
        this.multiUserChatManager.removeJoinedRoom(this.room);
        this.removeConnectionCallbacks();
    }

    public boolean addUserStatusListener(UserStatusListener listener) {
        return this.userStatusListeners.add(listener);
    }

    public boolean removeUserStatusListener(UserStatusListener listener) {
        return this.userStatusListeners.remove(listener);
    }

    public boolean addParticipantStatusListener(ParticipantStatusListener listener) {
        return this.participantStatusListeners.add(listener);
    }

    public boolean removeParticipantStatusListener(ParticipantStatusListener listener) {
        return this.participantStatusListeners.remove(listener);
    }

    private void checkRoleModifications(MUCRole oldRole, MUCRole newRole, boolean isUserModification, EntityFullJid from) {
        block30: {
            block29: {
                if ((MUCRole.visitor.equals((Object)oldRole) || MUCRole.none.equals((Object)oldRole)) && MUCRole.participant.equals((Object)newRole)) {
                    if (isUserModification) {
                        for (UserStatusListener userStatusListener : this.userStatusListeners) {
                            userStatusListener.voiceGranted();
                        }
                    } else {
                        for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                            participantStatusListener.voiceGranted(from);
                        }
                    }
                } else if (MUCRole.participant.equals((Object)oldRole) && (MUCRole.visitor.equals((Object)newRole) || MUCRole.none.equals((Object)newRole))) {
                    if (isUserModification) {
                        for (UserStatusListener userStatusListener : this.userStatusListeners) {
                            userStatusListener.voiceRevoked();
                        }
                    } else {
                        for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                            participantStatusListener.voiceRevoked(from);
                        }
                    }
                }
                if (MUCRole.moderator.equals((Object)oldRole) || !MUCRole.moderator.equals((Object)newRole)) break block29;
                if (MUCRole.visitor.equals((Object)oldRole) || MUCRole.none.equals((Object)oldRole)) {
                    if (isUserModification) {
                        for (UserStatusListener userStatusListener : this.userStatusListeners) {
                            userStatusListener.voiceGranted();
                        }
                    } else {
                        for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                            participantStatusListener.voiceGranted(from);
                        }
                    }
                }
                if (isUserModification) {
                    for (UserStatusListener userStatusListener : this.userStatusListeners) {
                        userStatusListener.moderatorGranted();
                    }
                } else {
                    for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                        participantStatusListener.moderatorGranted(from);
                    }
                }
                break block30;
            }
            if (!MUCRole.moderator.equals((Object)oldRole) || MUCRole.moderator.equals((Object)newRole)) break block30;
            if (MUCRole.visitor.equals((Object)newRole) || MUCRole.none.equals((Object)newRole)) {
                if (isUserModification) {
                    for (UserStatusListener userStatusListener : this.userStatusListeners) {
                        userStatusListener.voiceRevoked();
                    }
                } else {
                    for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                        participantStatusListener.voiceRevoked(from);
                    }
                }
            }
            if (isUserModification) {
                for (UserStatusListener userStatusListener : this.userStatusListeners) {
                    userStatusListener.moderatorRevoked();
                }
            } else {
                for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                    participantStatusListener.moderatorRevoked(from);
                }
            }
        }
    }

    private void checkAffiliationModifications(MUCAffiliation oldAffiliation, MUCAffiliation newAffiliation, boolean isUserModification, EntityFullJid from) {
        block30: {
            block31: {
                block29: {
                    if (MUCAffiliation.owner.equals((Object)oldAffiliation) && !MUCAffiliation.owner.equals((Object)newAffiliation)) {
                        if (isUserModification) {
                            for (UserStatusListener userStatusListener : this.userStatusListeners) {
                                userStatusListener.ownershipRevoked();
                            }
                        } else {
                            for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                                participantStatusListener.ownershipRevoked(from);
                            }
                        }
                    } else if (MUCAffiliation.admin.equals((Object)oldAffiliation) && !MUCAffiliation.admin.equals((Object)newAffiliation)) {
                        if (isUserModification) {
                            for (UserStatusListener userStatusListener : this.userStatusListeners) {
                                userStatusListener.adminRevoked();
                            }
                        } else {
                            for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                                participantStatusListener.adminRevoked(from);
                            }
                        }
                    } else if (MUCAffiliation.member.equals((Object)oldAffiliation) && !MUCAffiliation.member.equals((Object)newAffiliation)) {
                        if (isUserModification) {
                            for (UserStatusListener userStatusListener : this.userStatusListeners) {
                                userStatusListener.membershipRevoked();
                            }
                        } else {
                            for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                                participantStatusListener.membershipRevoked(from);
                            }
                        }
                    }
                    if (MUCAffiliation.owner.equals((Object)oldAffiliation) || !MUCAffiliation.owner.equals((Object)newAffiliation)) break block29;
                    if (isUserModification) {
                        for (UserStatusListener userStatusListener : this.userStatusListeners) {
                            userStatusListener.ownershipGranted();
                        }
                    } else {
                        for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                            participantStatusListener.ownershipGranted(from);
                        }
                    }
                    break block30;
                }
                if (MUCAffiliation.admin.equals((Object)oldAffiliation) || !MUCAffiliation.admin.equals((Object)newAffiliation)) break block31;
                if (isUserModification) {
                    for (UserStatusListener userStatusListener : this.userStatusListeners) {
                        userStatusListener.adminGranted();
                    }
                } else {
                    for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                        participantStatusListener.adminGranted(from);
                    }
                }
                break block30;
            }
            if (MUCAffiliation.member.equals((Object)oldAffiliation) || !MUCAffiliation.member.equals((Object)newAffiliation)) break block30;
            if (isUserModification) {
                for (UserStatusListener userStatusListener : this.userStatusListeners) {
                    userStatusListener.membershipGranted();
                }
            } else {
                for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                    participantStatusListener.membershipGranted(from);
                }
            }
        }
    }

    private void checkPresenceCode(Set<MUCUser.Status> statusCodes, boolean isUserModification, MUCUser mucUser, EntityFullJid from) {
        if (statusCodes.contains(MUCUser.Status.KICKED_307)) {
            if (isUserModification) {
                this.userHasLeft();
                for (UserStatusListener userStatusListener : this.userStatusListeners) {
                    userStatusListener.kicked(mucUser.getItem().getActor(), mucUser.getItem().getReason());
                }
            } else {
                for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                    participantStatusListener.kicked(from, mucUser.getItem().getActor(), mucUser.getItem().getReason());
                }
            }
        }
        if (statusCodes.contains(MUCUser.Status.BANNED_301)) {
            if (isUserModification) {
                this.joined = false;
                for (UserStatusListener userStatusListener : this.userStatusListeners) {
                    userStatusListener.banned(mucUser.getItem().getActor(), mucUser.getItem().getReason());
                }
                this.occupantsMap.clear();
                this.nickname = null;
                this.userHasLeft();
            } else {
                for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                    participantStatusListener.banned(from, mucUser.getItem().getActor(), mucUser.getItem().getReason());
                }
            }
        }
        if (statusCodes.contains(MUCUser.Status.REMOVED_AFFIL_CHANGE_321) && isUserModification) {
            this.joined = false;
            for (UserStatusListener userStatusListener : this.userStatusListeners) {
                userStatusListener.membershipRevoked();
            }
            this.occupantsMap.clear();
            this.nickname = null;
            this.userHasLeft();
        }
        if (statusCodes.contains(MUCUser.Status.NEW_NICKNAME_303)) {
            for (ParticipantStatusListener participantStatusListener : this.participantStatusListeners) {
                participantStatusListener.nicknameChanged(from, mucUser.getItem().getNick());
            }
        }
        if (mucUser.getDestroy() != null) {
            MultiUserChat alternateMUC = this.multiUserChatManager.getMultiUserChat(mucUser.getDestroy().getJid());
            for (UserStatusListener listener : this.userStatusListeners) {
                listener.roomDestroyed(alternateMUC, mucUser.getDestroy().getReason());
            }
            this.occupantsMap.clear();
            this.nickname = null;
            this.userHasLeft();
        }
    }

    public String toString() {
        return "MUC: " + this.room + "(" + this.connection.getUser() + ")";
    }

    public class MucCreateConfigFormHandle {
        public void makeInstant() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
            MultiUserChat.this.sendConfigurationForm(new Form(DataForm.Type.submit));
        }

        public MucConfigFormManager getConfigFormManager() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
            return MultiUserChat.this.getConfigFormManager();
        }
    }
}

