/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.EmptyResultIQ;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.pubsub.Affiliation;
import org.jivesoftware.smackx.pubsub.AffiliationsExtension;
import org.jivesoftware.smackx.pubsub.CollectionNode;
import org.jivesoftware.smackx.pubsub.ConfigureForm;
import org.jivesoftware.smackx.pubsub.ConfigureNodeFields;
import org.jivesoftware.smackx.pubsub.FormNode;
import org.jivesoftware.smackx.pubsub.FormNodeType;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.LeafNode;
import org.jivesoftware.smackx.pubsub.Node;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.NodeType;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.jivesoftware.smackx.pubsub.Subscription;
import org.jivesoftware.smackx.pubsub.SubscriptionsExtension;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.jivesoftware.smackx.pubsub.packet.PubSubNamespace;
import org.jivesoftware.smackx.pubsub.util.NodeUtils;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.FormField;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public final class PubSubManager
extends Manager {
    public static final String AUTO_CREATE_FEATURE = "http://jabber.org/protocol/pubsub#auto-create";
    private static final Logger LOGGER = Logger.getLogger(PubSubManager.class.getName());
    private static final Map<XMPPConnection, Map<BareJid, PubSubManager>> INSTANCES = new WeakHashMap<XMPPConnection, Map<BareJid, PubSubManager>>();
    private final BareJid pubSubService;
    private final Map<String, Node> nodeMap = new ConcurrentHashMap<String, Node>();

    public static PubSubManager getInstance(XMPPConnection connection) {
        DomainBareJid pubSubService = null;
        if (connection.isAuthenticated()) {
            try {
                pubSubService = PubSubManager.getPubSubService(connection);
            }
            catch (SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
                LOGGER.log(Level.WARNING, "Could not determine PubSub service", e);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.FINE, "Interrupted while trying to determine PubSub service", e);
            }
        }
        if (pubSubService == null) {
            try {
                pubSubService = JidCreate.domainBareFrom("pubsub." + connection.getXMPPServiceDomain());
            }
            catch (XmppStringprepException e) {
                throw new RuntimeException(e);
            }
        }
        return PubSubManager.getInstance(connection, pubSubService);
    }

    public static synchronized PubSubManager getInstance(XMPPConnection connection, BareJid pubSubService) {
        PubSubManager pubSubManager;
        Map<BareJid, PubSubManager> managers = INSTANCES.get(connection);
        if (managers == null) {
            managers = new HashMap<BareJid, PubSubManager>();
            INSTANCES.put(connection, managers);
        }
        if ((pubSubManager = managers.get(pubSubService)) == null) {
            pubSubManager = new PubSubManager(connection, pubSubService);
            managers.put(pubSubService, pubSubManager);
        }
        return pubSubManager;
    }

    PubSubManager(XMPPConnection connection, BareJid toAddress) {
        super(connection);
        this.pubSubService = toAddress;
    }

    public LeafNode createNode() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub reply = this.sendPubsubPacket(IQ.Type.set, new NodeExtension(PubSubElementType.CREATE), null);
        NodeExtension elem = (NodeExtension)reply.getExtension("create", PubSubNamespace.BASIC.getXmlns());
        LeafNode newNode = new LeafNode(this, elem.getNode());
        this.nodeMap.put(newNode.getId(), newNode);
        return newNode;
    }

    public LeafNode createNode(String nodeId) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return (LeafNode)this.createNode(nodeId, null);
    }

    public Node createNode(String nodeId, Form config) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub request = PubSub.createPubsubPacket(this.pubSubService, IQ.Type.set, new NodeExtension(PubSubElementType.CREATE, nodeId), null);
        boolean isLeafNode = true;
        if (config != null) {
            request.addExtension(new FormNode(FormNodeType.CONFIGURE, config));
            FormField nodeTypeField = config.getField(ConfigureNodeFields.node_type.getFieldName());
            if (nodeTypeField != null) {
                isLeafNode = nodeTypeField.getValues().get(0).equals(NodeType.leaf.toString());
            }
        }
        this.sendPubsubPacket(request);
        Node newNode = isLeafNode ? new LeafNode(this, nodeId) : new CollectionNode(this, nodeId);
        this.nodeMap.put(newNode.getId(), newNode);
        return newNode;
    }

    public <T extends Node> T getNode(String id) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, PubSubException.NotAPubSubNodeException {
        Node node = this.nodeMap.get(id);
        if (node == null) {
            DiscoverInfo info = new DiscoverInfo();
            info.setTo(this.pubSubService);
            info.setNode(id);
            DiscoverInfo infoReply = (DiscoverInfo)this.connection().createStanzaCollectorAndSend(info).nextResultOrThrow();
            if (infoReply.hasIdentity("pubsub", "leaf")) {
                node = new LeafNode(this, id);
            } else if (infoReply.hasIdentity("pubsub", "collection")) {
                node = new CollectionNode(this, id);
            } else {
                throw new PubSubException.NotAPubSubNodeException(id, infoReply);
            }
            this.nodeMap.put(id, node);
        }
        Node res = node;
        return (T)res;
    }

    public LeafNode getOrCreateLeafNode(String id) throws SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException, XMPPException.XMPPErrorException, PubSubException.NotALeafNodeException {
        try {
            return (LeafNode)this.getNode(id);
        }
        catch (PubSubException.NotAPubSubNodeException e) {
            return this.createNode(id);
        }
        catch (XMPPException.XMPPErrorException e1) {
            if (e1.getXMPPError().getCondition() == XMPPError.Condition.item_not_found) {
                try {
                    return this.createNode(id);
                }
                catch (XMPPException.XMPPErrorException e2) {
                    if (e2.getXMPPError().getCondition() == XMPPError.Condition.conflict) {
                        try {
                            return (LeafNode)this.getNode(id);
                        }
                        catch (PubSubException.NotAPubSubNodeException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    throw e2;
                }
            }
            if (e1.getXMPPError().getCondition() == XMPPError.Condition.service_unavailable) {
                LOGGER.warning("The PubSub service " + this.pubSubService + " threw an DiscoInfoNodeAssertionError, trying workaround for Prosody bug #805 (https://prosody.im/issues/issue/805)");
                return this.getOrCreateLeafNodeProsodyWorkaround(id);
            }
            throw e1;
        }
    }

    public LeafNode getLeafNode(String id) throws PubSubException.NotALeafNodeException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException, XMPPException.XMPPErrorException, PubSubException.NotAPubSubNodeException {
        Object node;
        try {
            node = this.getNode(id);
        }
        catch (XMPPException.XMPPErrorException e) {
            if (e.getXMPPError().getCondition() == XMPPError.Condition.service_unavailable) {
                return this.getLeafNodeProsodyWorkaround(id);
            }
            throw e;
        }
        if (node instanceof LeafNode) {
            return (LeafNode)node;
        }
        throw new PubSubException.NotALeafNodeException(id, this.pubSubService);
    }

    private LeafNode getLeafNodeProsodyWorkaround(String id) throws SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException, PubSubException.NotALeafNodeException, XMPPException.XMPPErrorException {
        LeafNode leafNode = new LeafNode(this, id);
        try {
            leafNode.getItems(1);
        }
        catch (XMPPException.XMPPErrorException e) {
            XMPPError.Condition condition = e.getXMPPError().getCondition();
            if (condition == XMPPError.Condition.feature_not_implemented) {
                throw new PubSubException.NotALeafNodeException(id, this.pubSubService);
            }
            throw e;
        }
        this.nodeMap.put(id, leafNode);
        return leafNode;
    }

    private LeafNode getOrCreateLeafNodeProsodyWorkaround(String id) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException, PubSubException.NotALeafNodeException {
        try {
            return this.createNode(id);
        }
        catch (XMPPException.XMPPErrorException e1) {
            if (e1.getXMPPError().getCondition() == XMPPError.Condition.conflict) {
                return this.getLeafNodeProsodyWorkaround(id);
            }
            throw e1;
        }
    }

    public <I extends Item> LeafNode tryToPublishAndPossibleAutoCreate(String id, I item) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        LeafNode leafNode = new LeafNode(this, id);
        leafNode.send(item);
        this.nodeMap.put(id, leafNode);
        return leafNode;
    }

    public DiscoverItems discoverNodes(String nodeId) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverItems items = new DiscoverItems();
        if (nodeId != null) {
            items.setNode(nodeId);
        }
        items.setTo(this.pubSubService);
        DiscoverItems nodeItems = (DiscoverItems)this.connection().createStanzaCollectorAndSend(items).nextResultOrThrow();
        return nodeItems;
    }

    public List<Subscription> getSubscriptions() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub reply = this.sendPubsubPacket(IQ.Type.get, new NodeExtension(PubSubElementType.SUBSCRIPTIONS), null);
        SubscriptionsExtension subElem = (SubscriptionsExtension)reply.getExtension(PubSubElementType.SUBSCRIPTIONS.getElementName(), PubSubElementType.SUBSCRIPTIONS.getNamespace().getXmlns());
        return subElem.getSubscriptions();
    }

    public List<Affiliation> getAffiliations() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub reply = this.sendPubsubPacket(IQ.Type.get, new NodeExtension(PubSubElementType.AFFILIATIONS), null);
        AffiliationsExtension listElem = (AffiliationsExtension)reply.getExtension(PubSubElementType.AFFILIATIONS);
        return listElem.getAffiliations();
    }

    public void deleteNode(String nodeId) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.sendPubsubPacket(IQ.Type.set, new NodeExtension(PubSubElementType.DELETE, nodeId), PubSubElementType.DELETE.getNamespace());
        this.nodeMap.remove(nodeId);
    }

    public ConfigureForm getDefaultConfiguration() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub reply = this.sendPubsubPacket(IQ.Type.get, new NodeExtension(PubSubElementType.DEFAULT), PubSubElementType.DEFAULT.getNamespace());
        return NodeUtils.getFormFromPacket(reply, PubSubElementType.DEFAULT);
    }

    public BareJid getServiceJid() {
        return this.pubSubService;
    }

    public DiscoverInfo getSupportedFeatures() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        ServiceDiscoveryManager mgr = ServiceDiscoveryManager.getInstanceFor(this.connection());
        return mgr.discoverInfo(this.pubSubService);
    }

    public boolean supportsAutomaticNodeCreation() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor(this.connection());
        return sdm.supportsFeature(this.pubSubService, AUTO_CREATE_FEATURE);
    }

    public boolean canCreateNodesAndPublishItems() throws SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException, XMPPException.XMPPErrorException {
        LeafNode leafNode = null;
        try {
            leafNode = this.createNode();
        }
        catch (XMPPException.XMPPErrorException e) {
            if (e.getXMPPError().getCondition() == XMPPError.Condition.forbidden) {
                boolean bl = false;
                return bl;
            }
            throw e;
        }
        finally {
            if (leafNode != null) {
                this.deleteNode(leafNode.getId());
            }
        }
        return true;
    }

    private PubSub sendPubsubPacket(IQ.Type type, ExtensionElement ext, PubSubNamespace ns) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.sendPubsubPacket(this.pubSubService, type, Collections.singletonList(ext), ns);
    }

    XMPPConnection getConnection() {
        return this.connection();
    }

    PubSub sendPubsubPacket(Jid to, IQ.Type type, List<ExtensionElement> extList, PubSubNamespace ns) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub pubSub = new PubSub(to, type, ns);
        for (ExtensionElement pe : extList) {
            pubSub.addExtension(pe);
        }
        return this.sendPubsubPacket(pubSub);
    }

    PubSub sendPubsubPacket(PubSub packet) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        IQ resultIQ = (IQ)this.connection().createStanzaCollectorAndSend(packet).nextResultOrThrow();
        if (resultIQ instanceof EmptyResultIQ) {
            return null;
        }
        return (PubSub)resultIQ;
    }

    public static DomainBareJid getPubSubService(XMPPConnection connection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return ServiceDiscoveryManager.getInstanceFor(connection).findService("http://jabber.org/protocol/pubsub", true, "pubsub", "service");
    }
}

