/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.xdata.FormField;

public class DataForm
implements ExtensionElement {
    public static final String NAMESPACE = "jabber:x:data";
    public static final String ELEMENT = "x";
    private Type type;
    private String title;
    private final List<String> instructions = new ArrayList<String>();
    private ReportedData reportedData;
    private final List<Item> items = new ArrayList<Item>();
    private final Map<String, FormField> fields = new LinkedHashMap<String, FormField>();
    private final List<Element> extensionElements = new ArrayList<Element>();

    public DataForm(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getInstructions() {
        List<String> list = this.instructions;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<String>(this.instructions));
        }
    }

    public ReportedData getReportedData() {
        return this.reportedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Item> getItems() {
        List<Item> list = this.items;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<Item>(this.items));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FormField> getFields() {
        Map<String, FormField> map = this.fields;
        synchronized (map) {
            return new ArrayList<FormField>(this.fields.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormField getField(String variableName) {
        Map<String, FormField> map = this.fields;
        synchronized (map) {
            return this.fields.get(variableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasField(String variableName) {
        Map<String, FormField> map = this.fields;
        synchronized (map) {
            return this.fields.containsKey(variableName);
        }
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInstructions(List<String> instructions) {
        List<String> list = this.instructions;
        synchronized (list) {
            this.instructions.clear();
            this.instructions.addAll(instructions);
        }
    }

    public void setReportedData(ReportedData reportedData) {
        this.reportedData = reportedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addField(FormField field) {
        String fieldVariableName = field.getVariable();
        if (fieldVariableName != null && this.hasField(fieldVariableName)) {
            throw new IllegalArgumentException("This data form already contains a form field with the variable name '" + fieldVariableName + "'");
        }
        Map<String, FormField> map = this.fields;
        synchronized (map) {
            this.fields.put(fieldVariableName, field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstruction(String instruction) {
        List<String> list = this.instructions;
        synchronized (list) {
            this.instructions.add(instruction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItem(Item item) {
        List<Item> list = this.items;
        synchronized (list) {
            this.items.add(item);
        }
    }

    public void addExtensionElement(Element element) {
        this.extensionElements.add(element);
    }

    public List<Element> getExtensionElements() {
        return Collections.unmodifiableList(this.extensionElements);
    }

    public FormField getHiddenFormTypeField() {
        FormField field = this.getField("FORM_TYPE");
        if (field != null && field.getType() == FormField.Type.hidden) {
            return field;
        }
        return null;
    }

    public boolean hasHiddenFormTypeField() {
        return this.getHiddenFormTypeField() != null;
    }

    @Override
    public XmlStringBuilder toXML() {
        XmlStringBuilder buf = new XmlStringBuilder(this);
        buf.attribute("type", this.getType());
        buf.rightAngleBracket();
        buf.optElement("title", this.getTitle());
        for (String instruction : this.getInstructions()) {
            buf.element("instructions", instruction);
        }
        if (this.getReportedData() != null) {
            buf.append(this.getReportedData().toXML());
        }
        for (Item item : this.getItems()) {
            buf.append(item.toXML());
        }
        for (FormField field : this.getFields()) {
            buf.append(field.toXML());
        }
        for (Element element : this.extensionElements) {
            buf.append(element.toXML());
        }
        buf.closeElement(this);
        return buf;
    }

    public static DataForm from(Stanza packet) {
        return (DataForm)packet.getExtension(ELEMENT, NAMESPACE);
    }

    public static class Item {
        public static final String ELEMENT = "item";
        private List<FormField> fields = new ArrayList<FormField>();

        public Item(List<FormField> fields) {
            this.fields = fields;
        }

        public List<FormField> getFields() {
            return Collections.unmodifiableList(new ArrayList<FormField>(this.fields));
        }

        public CharSequence toXML() {
            XmlStringBuilder buf = new XmlStringBuilder();
            buf.openElement(ELEMENT);
            for (FormField field : this.getFields()) {
                buf.append(field.toXML());
            }
            buf.closeElement(ELEMENT);
            return buf;
        }
    }

    public static class ReportedData {
        public static final String ELEMENT = "reported";
        private List<FormField> fields = new ArrayList<FormField>();

        public ReportedData(List<FormField> fields) {
            this.fields = fields;
        }

        public List<FormField> getFields() {
            return Collections.unmodifiableList(new ArrayList<FormField>(this.fields));
        }

        public CharSequence toXML() {
            XmlStringBuilder buf = new XmlStringBuilder();
            buf.openElement(ELEMENT);
            for (FormField field : this.getFields()) {
                buf.append(field.toXML());
            }
            buf.closeElement(ELEMENT);
            return buf;
        }
    }

    public static enum Type {
        form,
        submit,
        cancel,
        result;


        public static Type fromString(String string) {
            return Type.valueOf(string.toLowerCase(Locale.US));
        }
    }
}

