/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdatalayout.packet;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class DataLayout
implements ExtensionElement {
    public static final String ELEMENT = "page";
    public static final String NAMESPACE = "http://jabber.org/protocol/xdata-layout";
    private final List<DataFormLayoutElement> pageLayout = new ArrayList<DataFormLayoutElement>();
    private final String label;

    public DataLayout(String label) {
        this.label = label;
    }

    public List<DataFormLayoutElement> getPageLayout() {
        return this.pageLayout;
    }

    public String getLabel() {
        return this.label;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public XmlStringBuilder toXML() {
        XmlStringBuilder buf = new XmlStringBuilder(this);
        buf.optAttribute("label", this.getLabel());
        buf.rightAngleBracket();
        DataLayout.walkList(buf, this.getPageLayout());
        buf.closeElement(this);
        return buf;
    }

    private static void walkList(XmlStringBuilder buf, List<DataFormLayoutElement> pageLayout) {
        for (DataFormLayoutElement object : pageLayout) {
            buf.append(object.toXML());
        }
    }

    public static interface DataFormLayoutElement
    extends NamedElement {
    }

    public static class Text
    implements DataFormLayoutElement {
        public static final String ELEMENT = "text";
        private final String text;

        public Text(String text) {
            this.text = text;
        }

        @Override
        public XmlStringBuilder toXML() {
            XmlStringBuilder buf = new XmlStringBuilder();
            buf.element(ELEMENT, this.getText());
            return buf;
        }

        public String getText() {
            return this.text;
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Reportedref
    implements DataFormLayoutElement {
        public static final String ELEMENT = "reportedref";

        @Override
        public XmlStringBuilder toXML() {
            XmlStringBuilder buf = new XmlStringBuilder(this);
            buf.closeEmptyElement();
            return buf;
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Section
    implements DataFormLayoutElement {
        public static final String ELEMENT = "section";
        private final List<DataFormLayoutElement> sectionLayout = new ArrayList<DataFormLayoutElement>();
        private final String label;

        public Section(String label) {
            this.label = label;
        }

        public List<DataFormLayoutElement> getSectionLayout() {
            return this.sectionLayout;
        }

        @Override
        public XmlStringBuilder toXML() {
            XmlStringBuilder buf = new XmlStringBuilder(this);
            buf.optAttribute("label", this.getLabel());
            buf.rightAngleBracket();
            DataLayout.walkList(buf, this.getSectionLayout());
            buf.closeElement(ELEMENT);
            return buf;
        }

        public String getLabel() {
            return this.label;
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }
    }

    public static class Fieldref
    implements DataFormLayoutElement {
        public static final String ELEMENT = "fieldref";
        private final String var;

        public Fieldref(String var) {
            this.var = var;
        }

        @Override
        public XmlStringBuilder toXML() {
            XmlStringBuilder buf = new XmlStringBuilder(this);
            buf.attribute("var", this.getVar());
            buf.closeEmptyElement();
            return buf;
        }

        public String getVar() {
            return this.var;
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }
    }
}

