/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.stringprep;

import org.jxmpp.stringprep.XmppStringprep;
import org.jxmpp.stringprep.XmppStringprepException;
import org.jxmpp.stringprep.simple.SimpleXmppStringprep;
import org.jxmpp.util.cache.Cache;
import org.jxmpp.util.cache.LruCache;

public class XmppStringPrepUtil {
    private static final Cache<String, String> NODEPREP_CACHE;
    private static final Cache<String, String> DOMAINPREP_CACHE;
    private static final Cache<String, String> RESOURCEPREP_CACHE;
    private static XmppStringprep xmppStringprep;

    public static void setXmppStringprep(XmppStringprep xmppStringprep) {
        XmppStringPrepUtil.xmppStringprep = xmppStringprep;
    }

    public static String localprep(String string) throws XmppStringprepException {
        if (xmppStringprep == null) {
            return string;
        }
        XmppStringPrepUtil.throwIfEmptyString(string);
        String res = NODEPREP_CACHE.lookup(string);
        if (res != null) {
            return res;
        }
        res = xmppStringprep.localprep(string);
        NODEPREP_CACHE.put(string, res);
        return res;
    }

    public static String domainprep(String string) throws XmppStringprepException {
        if (xmppStringprep == null) {
            return string;
        }
        XmppStringPrepUtil.throwIfEmptyString(string);
        String res = DOMAINPREP_CACHE.lookup(string);
        if (res != null) {
            return res;
        }
        res = xmppStringprep.domainprep(string);
        DOMAINPREP_CACHE.put(string, res);
        return res;
    }

    public static String resourceprep(String string) throws XmppStringprepException {
        if (xmppStringprep == null) {
            return string;
        }
        XmppStringPrepUtil.throwIfEmptyString(string);
        String res = RESOURCEPREP_CACHE.lookup(string);
        if (res != null) {
            return res;
        }
        res = xmppStringprep.resourceprep(string);
        RESOURCEPREP_CACHE.put(string, res);
        return res;
    }

    public static void setMaxCacheSizes(int size) {
        NODEPREP_CACHE.setMaxCacheSize(size);
        DOMAINPREP_CACHE.setMaxCacheSize(size);
        RESOURCEPREP_CACHE.setMaxCacheSize(size);
    }

    private static void throwIfEmptyString(String string) throws XmppStringprepException {
        if (string.length() == 0) {
            throw new XmppStringprepException(string, "Argument can't be the empty string");
        }
    }

    static {
        SimpleXmppStringprep.setup();
        NODEPREP_CACHE = new LruCache<String, String>(100);
        DOMAINPREP_CACHE = new LruCache<String, String>(100);
        RESOURCEPREP_CACHE = new LruCache<String, String>(100);
    }
}

