/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt.saxon;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.saxon.Configuration;
import org.apache.camel.Endpoint;
import org.apache.camel.component.xslt.XsltComponent;
import org.apache.camel.component.xslt.saxon.XsltSaxonEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.EndpointHelper;

@Component(value="xslt-saxon")
public class XsltSaxonComponent
extends XsltComponent {
    @Metadata(label="advanced")
    private Configuration saxonConfiguration;
    @Metadata(label="advanced")
    private Map<String, Object> saxonConfigurationProperties = new HashMap<String, Object>();
    @Metadata(label="advanced", javaType="java.lang.String")
    private List<Object> saxonExtensionFunctions;

    public List<Object> getSaxonExtensionFunctions() {
        return this.saxonExtensionFunctions;
    }

    public void setSaxonExtensionFunctions(List<Object> extensionFunctions) {
        this.saxonExtensionFunctions = extensionFunctions;
    }

    public void setSaxonExtensionFunctions(String extensionFunctions) {
        this.saxonExtensionFunctions = EndpointHelper.resolveReferenceListParameter(this.getCamelContext(), extensionFunctions, Object.class);
    }

    public Configuration getSaxonConfiguration() {
        return this.saxonConfiguration;
    }

    public void setSaxonConfiguration(Configuration saxonConfiguration) {
        this.saxonConfiguration = saxonConfiguration;
    }

    public Map<String, Object> getSaxonConfigurationProperties() {
        return this.saxonConfigurationProperties;
    }

    public void setSaxonConfigurationProperties(Map<String, Object> configurationProperties) {
        this.saxonConfigurationProperties = configurationProperties;
    }

    @Override
    protected XsltSaxonEndpoint createXsltEndpoint(String uri) {
        return new XsltSaxonEndpoint(uri, this);
    }

    @Override
    protected void configureEndpoint(Endpoint endpoint, String remaining, Map<String, Object> parameters) throws Exception {
        XsltSaxonEndpoint saxon = (XsltSaxonEndpoint)endpoint;
        saxon.setContentCache(this.isContentCache());
        saxon.setSaxonConfiguration(this.saxonConfiguration);
        saxon.setSaxonConfigurationProperties(this.saxonConfigurationProperties);
        saxon.setSaxonExtensionFunctions(this.saxonExtensionFunctions);
        super.configureEndpoint(endpoint, remaining, parameters);
    }
}

