/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.json.JsonWriter;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.StaxReader;
import com.thoughtworks.xstream.io.xml.StaxWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.xml.stream.XMLStreamException;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.xstream.AbstractXStreamWrapper;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Dataformat;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedXMLInputFactory;
import org.codehaus.jettison.mapped.MappedXMLOutputFactory;

@Dataformat(value="xstreamJson")
@Metadata(includeProperties="prettyPrint,dropRootNode,contentTypeHeader")
public class JsonDataFormat
extends AbstractXStreamWrapper {
    private MappedXMLOutputFactory mof;
    private MappedXMLInputFactory mif;
    private boolean prettyPrint;
    private boolean dropRootNode;

    @Override
    public String getDataFormatName() {
        return "xstreamJson";
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public boolean isDropRootNode() {
        return this.dropRootNode;
    }

    public void setDropRootNode(boolean dropRootNode) {
        this.dropRootNode = dropRootNode;
    }

    @Override
    public void marshal(Exchange exchange, Object body, OutputStream stream) throws Exception {
        super.marshal(exchange, body, stream);
        if (this.isContentTypeHeader()) {
            exchange.getMessage().setHeader("Content-Type", "application/json");
        }
    }

    @Override
    protected XStream createXStream(ClassResolver resolver, ClassLoader classLoader) {
        XStream xs = super.createXStream(resolver, classLoader);
        if (this.getMode() != null) {
            xs.setMode(this.getModeFromString(this.getMode()));
        } else {
            xs.setMode(1001);
        }
        return xs;
    }

    @Override
    protected HierarchicalStreamWriter createHierarchicalStreamWriter(Exchange exchange, Object body, OutputStream stream) throws XMLStreamException {
        if (this.isPrettyPrint()) {
            if (this.isDropRootNode()) {
                return new JsonWriter((Writer)new OutputStreamWriter(stream, StandardCharsets.UTF_8), 1);
            }
            return new JsonWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8));
        }
        return new StaxWriter(new QNameMap(), this.mof.createXMLStreamWriter(stream));
    }

    @Override
    protected HierarchicalStreamReader createHierarchicalStreamReader(Exchange exchange, InputStream stream) throws XMLStreamException {
        return new StaxReader(new QNameMap(), this.mif.createXMLStreamReader(stream));
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        Configuration config = new Configuration();
        config.setDropRootElement(this.dropRootNode);
        this.mof = new MappedXMLOutputFactory(config);
        this.mif = new MappedXMLInputFactory(config);
    }
}

