/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml;

import java.io.InputStream;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Ordered;
import org.apache.camel.component.properties.AbstractLocationPropertiesSource;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesLocation;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.StringHelper;

public class IntegrationConfigurationPropertiesSource
extends AbstractLocationPropertiesSource
implements CamelContextAware,
Ordered {
    private final String name;
    private CamelContext camelContext;

    public IntegrationConfigurationPropertiesSource(PropertiesComponent propertiesComponent, PropertiesLocation location, String name) {
        super(propertiesComponent, location);
        this.name = name;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Properties loadPropertiesFromLocation(PropertiesComponent propertiesComponent, PropertiesLocation location) {
        return null;
    }

    @Override
    public int getOrder() {
        return 300;
    }

    public void parseConfigurationValue(String line) {
        if (line.contains("=")) {
            String key = StringHelper.before(line, "=").trim();
            String value = StringHelper.after(line, "=").trim();
            this.setProperty(key, value);
        } else if (ResourceHelper.hasScheme(line)) {
            try (InputStream is = ResourceHelper.resolveResourceAsInputStream(this.camelContext, line);){
                Properties prop = new Properties();
                prop.load(is);
                for (String k : prop.stringPropertyNames()) {
                    String v = prop.getProperty(k);
                    String key = k.trim();
                    String value = v.trim();
                    this.setProperty(key, value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "camel-yaml-dsl";
    }
}

