/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.RouteConfigurationBuilder;
import org.apache.camel.component.properties.PropertiesComponent;
import org.apache.camel.component.properties.PropertiesLocation;
import org.apache.camel.dsl.yaml.IntegrationConfigurationPropertiesSource;
import org.apache.camel.dsl.yaml.IntegrationSourceResource;
import org.apache.camel.dsl.yaml.YamlRoutesBuilderLoaderSupport;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.dsl.yaml.common.exception.InvalidEndpointException;
import org.apache.camel.dsl.yaml.common.exception.InvalidNodeTypeException;
import org.apache.camel.dsl.yaml.deserializers.OutputAwareFromDefinition;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.KameletDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.TemplatedRouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.errorhandler.DeadLetterChannelDefinition;
import org.apache.camel.model.errorhandler.DefaultErrorHandlerDefinition;
import org.apache.camel.model.errorhandler.NoErrorHandlerDefinition;
import org.apache.camel.model.rest.RestConfigurationDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.rest.VerbDefinition;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.DependencyStrategy;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.annotations.RoutesLoader;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.StringQuoteHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snakeyaml.engine.v2.api.LoadSettings;
import org.snakeyaml.engine.v2.api.YamlUnicodeReader;
import org.snakeyaml.engine.v2.common.ScalarStyle;
import org.snakeyaml.engine.v2.composer.Composer;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;
import org.snakeyaml.engine.v2.nodes.NodeType;
import org.snakeyaml.engine.v2.nodes.ScalarNode;
import org.snakeyaml.engine.v2.nodes.SequenceNode;
import org.snakeyaml.engine.v2.nodes.Tag;
import org.snakeyaml.engine.v2.parser.ParserImpl;
import org.snakeyaml.engine.v2.scanner.StreamReader;

@ManagedResource(description="Managed YAML RoutesBuilderLoader")
@RoutesLoader(value="yaml")
public class YamlRoutesBuilderLoader
extends YamlRoutesBuilderLoaderSupport {
    public static final String EXTENSION = "yaml";
    private static final Logger LOG = LoggerFactory.getLogger(YamlRoutesBuilderLoader.class);
    private static final String INTEGRATION_VERSION = "camel.apache.org/v1";
    private static final String BINDING_VERSION = "camel.apache.org/v1";
    private static final String STRIMZI_VERSION = "kafka.strimzi.io/v1";
    private static final String KNATIVE_VERSION = "messaging.knative.dev/v1";

    public YamlRoutesBuilderLoader() {
        super(EXTENSION);
    }

    YamlRoutesBuilderLoader(String extension) {
        super(extension);
    }

    @Override
    protected RouteBuilder builder(final YamlDeserializationContext ctx, final Node root) {
        final HashSet indexes = new HashSet();
        return new RouteConfigurationBuilder(){

            @Override
            public void configure() throws Exception {
                YamlDeserializerSupport.setDeserializationContext(root, ctx);
                Object target = YamlRoutesBuilderLoader.this.preConfigureNode(root, ctx, false);
                if (target == null) {
                    return;
                }
                Iterator<?> it = ObjectHelper.createIterator(target);
                while (it.hasNext()) {
                    target = it.next();
                    if (target instanceof Node && YamlDeserializerSupport.isSequenceNode((Node)target)) {
                        SequenceNode seq = YamlDeserializerSupport.asSequenceNode((Node)target);
                        for (Node node : seq.getValue()) {
                            Object item;
                            boolean accepted;
                            int idx = -1;
                            if (node.getStartMark().isPresent()) {
                                idx = node.getStartMark().get().getIndex();
                            }
                            if (idx != -1 && indexes.contains(idx) || !(accepted = this.doConfigure(item = ctx.mandatoryResolve(node).construct(node))) || idx == -1) continue;
                            indexes.add(idx);
                        }
                        continue;
                    }
                    this.doConfigure(target);
                }
            }

            private boolean doConfigure(Object item) throws Exception {
                if (item instanceof OutputAwareFromDefinition) {
                    RouteDefinition route = new RouteDefinition();
                    route.setInput(((OutputAwareFromDefinition)item).getDelegate());
                    route.setOutputs(((OutputAwareFromDefinition)item).getOutputs());
                    CamelContextAware.trySetCamelContext(this.getRouteCollection(), this.getCamelContext());
                    this.getRouteCollection().route(route);
                    return true;
                }
                if (item instanceof RouteDefinition) {
                    CamelContextAware.trySetCamelContext(this.getRouteCollection(), this.getCamelContext());
                    this.getRouteCollection().route((RouteDefinition)item);
                    return true;
                }
                if (item instanceof CamelContextCustomizer) {
                    ((CamelContextCustomizer)item).configure(this.getCamelContext());
                    return true;
                }
                if (item instanceof InterceptFromDefinition) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("interceptFrom must be defined before any routes in the RouteBuilder");
                    }
                    CamelContextAware.trySetCamelContext(this.getRouteCollection(), this.getCamelContext());
                    this.getRouteCollection().getInterceptFroms().add((InterceptFromDefinition)item);
                    return true;
                }
                if (item instanceof InterceptDefinition) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("intercept must be defined before any routes in the RouteBuilder");
                    }
                    CamelContextAware.trySetCamelContext(this.getRouteCollection(), this.getCamelContext());
                    this.getRouteCollection().getIntercepts().add((InterceptDefinition)item);
                    return true;
                }
                if (item instanceof InterceptSendToEndpointDefinition) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("interceptSendToEndpoint must be defined before any routes in the RouteBuilder");
                    }
                    CamelContextAware.trySetCamelContext(this.getRouteCollection(), this.getCamelContext());
                    this.getRouteCollection().getInterceptSendTos().add((InterceptSendToEndpointDefinition)item);
                    return true;
                }
                if (item instanceof OnCompletionDefinition) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("onCompletion must be defined before any routes in the RouteBuilder");
                    }
                    CamelContextAware.trySetCamelContext(this.getRouteCollection(), this.getCamelContext());
                    this.getRouteCollection().getOnCompletions().add((OnCompletionDefinition)item);
                    return true;
                }
                if (item instanceof OnExceptionDefinition) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("onException must be defined before any routes in the RouteBuilder");
                    }
                    CamelContextAware.trySetCamelContext(this.getRouteCollection(), this.getCamelContext());
                    this.getRouteCollection().getOnExceptions().add((OnExceptionDefinition)item);
                    return true;
                }
                if (item instanceof ErrorHandlerFactory) {
                    if (!this.getRouteCollection().getRoutes().isEmpty()) {
                        throw new IllegalArgumentException("errorHandler must be defined before any routes in the RouteBuilder");
                    }
                    this.errorHandler((ErrorHandlerFactory)item);
                    return true;
                }
                if (item instanceof RouteTemplateDefinition) {
                    CamelContextAware.trySetCamelContext(this.getRouteTemplateCollection(), this.getCamelContext());
                    this.getRouteTemplateCollection().routeTemplate((RouteTemplateDefinition)item);
                    return true;
                }
                if (item instanceof TemplatedRouteDefinition) {
                    CamelContextAware.trySetCamelContext(this.getTemplatedRouteCollection(), this.getCamelContext());
                    this.getTemplatedRouteCollection().templatedRoute((TemplatedRouteDefinition)item);
                    return true;
                }
                if (item instanceof RestDefinition) {
                    RestDefinition definition = (RestDefinition)item;
                    for (VerbDefinition verb : definition.getVerbs()) {
                        verb.setRest(definition);
                    }
                    CamelContextAware.trySetCamelContext(this.getRestCollection(), this.getCamelContext());
                    this.getRestCollection().rest(definition);
                    return true;
                }
                if (item instanceof RestConfigurationDefinition) {
                    ((RestConfigurationDefinition)item).asRestConfiguration(this.getCamelContext(), this.getCamelContext().getRestConfiguration());
                    return true;
                }
                return false;
            }

            @Override
            public void configuration() throws Exception {
                YamlDeserializerSupport.setDeserializationContext(root, ctx);
                Object target = YamlRoutesBuilderLoader.this.preConfigureNode(root, ctx, false);
                if (target == null) {
                    return;
                }
                Iterator<?> it = ObjectHelper.createIterator(target);
                while (it.hasNext()) {
                    target = it.next();
                    if (target instanceof Node && YamlDeserializerSupport.isSequenceNode((Node)target)) {
                        SequenceNode seq = YamlDeserializerSupport.asSequenceNode((Node)target);
                        for (Node node : seq.getValue()) {
                            Object item;
                            boolean accepted;
                            int idx = -1;
                            if (node.getStartMark().isPresent()) {
                                idx = node.getStartMark().get().getIndex();
                            }
                            if (idx != -1 && indexes.contains(idx) || !(accepted = this.doConfiguration(item = ctx.mandatoryResolve(node).construct(node))) || idx == -1) continue;
                            indexes.add(idx);
                        }
                        continue;
                    }
                    this.doConfiguration(target);
                }
            }

            private boolean doConfiguration(Object item) {
                if (item instanceof RouteConfigurationDefinition) {
                    CamelContextAware.trySetCamelContext(this.getRouteConfigurationCollection(), this.getCamelContext());
                    this.getRouteConfigurationCollection().routeConfiguration((RouteConfigurationDefinition)item);
                    return true;
                }
                return false;
            }
        };
    }

    private Object preConfigureNode(Node root, YamlDeserializationContext ctx, boolean preParse) {
        Object target = this.routeBackwardsCompatible(root, ctx, preParse);
        if (Objects.equals((Object)root.getNodeType(), (Object)NodeType.MAPPING)) {
            boolean binding;
            MappingNode mn = YamlDeserializerSupport.asMappingNode(root);
            boolean integration = this.anyTupleMatches(mn.getValue(), "apiVersion", (String v) -> v.startsWith("camel.apache.org/v1")) && this.anyTupleMatches(mn.getValue(), "kind", "Integration");
            boolean bl = binding = this.anyTupleMatches(mn.getValue(), "apiVersion", (String v) -> v.startsWith("camel.apache.org/v1")) && this.anyTupleMatches(mn.getValue(), "kind", "KameletBinding");
            if (integration) {
                target = this.preConfigureIntegration(root, ctx, target, preParse);
            } else if (binding) {
                target = this.preConfigureKameletBinding(root, ctx, target, preParse);
            }
        }
        return target;
    }

    private Object routeBackwardsCompatible(Node root, YamlDeserializationContext ctx, boolean preParse) {
        Node target = root;
        if (!YamlDeserializerSupport.isSequenceNode(root)) {
            return target;
        }
        SequenceNode seq = YamlDeserializerSupport.asSequenceNode(root);
        for (Node node : seq.getValue()) {
            Node steps;
            Node route = YamlDeserializerSupport.nodeAt(node, "/route");
            if (route == null || (steps = YamlDeserializerSupport.nodeAt(route, "/steps")) == null) continue;
            int line = -1;
            if (steps.getStartMark().isPresent()) {
                line = steps.getStartMark().get().getLine();
            }
            String file = ctx.getResource().getLocation();
            LOG.warn("Deprecated route/steps detected in {}:{}", (Object)file, (Object)(line + ". To migrate move route/steps to route/from/steps"));
            Node from = YamlDeserializerSupport.nodeAt(route, "/from");
            MappingNode mn = YamlDeserializerSupport.asMappingNode(from);
            if (mn == null || mn.getValue() == null) continue;
            ScalarNode sn = new ScalarNode(Tag.STR, "steps", ScalarStyle.PLAIN);
            NodeTuple nt = new NodeTuple(sn, steps);
            mn.getValue().add(nt);
            mn = YamlDeserializerSupport.asMappingNode(route);
            mn.getValue().removeIf(t -> {
                String k = YamlDeserializerSupport.asText(t.getKeyNode());
                return "steps".equals(k);
            });
        }
        return target;
    }

    private Object preConfigureIntegration(Node root, YamlDeserializationContext ctx, Object target, boolean preParse) {
        List<CamelContextCustomizer> list;
        Node configuration;
        ArrayList<Object> answer = new ArrayList<Object>();
        Node deps = YamlDeserializerSupport.nodeAt(root, "/spec/dependencies");
        if (deps != null) {
            CamelContextCustomizer dep = this.preConfigureDependencies(deps);
            answer.add(dep);
        }
        if ((configuration = YamlDeserializerSupport.nodeAt(root, "/spec/configuration")) != null) {
            list = this.preConfigureConfiguration(ctx.getResource(), configuration);
            answer.addAll(list);
        }
        if ((configuration = YamlDeserializerSupport.nodeAt(root, "/spec/traits/camel")) != null) {
            list = this.preConfigureTraitConfiguration(ctx.getResource(), configuration);
            answer.addAll(list);
        }
        if ((configuration = YamlDeserializerSupport.nodeAt(root, "/spec/traits/environment")) != null) {
            list = this.preConfigureTraitEnvironment(ctx.getResource(), configuration);
            answer.addAll(list);
        }
        if (!preParse) {
            Node routes;
            Node sources = YamlDeserializerSupport.nodeAt(root, "/spec/sources");
            if (sources != null) {
                List<CamelContextCustomizer> list2 = this.preConfigureSources(sources);
                answer.addAll(list2);
            }
            if ((routes = YamlDeserializerSupport.nodeAt(root, "/spec/flows")) == null) {
                routes = YamlDeserializerSupport.nodeAt(root, "/spec/flow");
            }
            if (routes != null) {
                if (routes.getNodeType() != NodeType.SEQUENCE) {
                    throw new InvalidNodeTypeException(routes, NodeType.SEQUENCE);
                }
                routes = (Node)this.routeBackwardsCompatible(routes, ctx, preParse);
                answer.add(routes);
            }
        }
        return answer;
    }

    private CamelContextCustomizer preConfigureDependencies(Node node) {
        final List<String> dep = YamlDeserializerSupport.asStringList(node);
        return new CamelContextCustomizer(){

            @Override
            public void configure(CamelContext camelContext) {
                for (DependencyStrategy ds : camelContext.getRegistry().findByType(DependencyStrategy.class)) {
                    for (String d : dep) {
                        try {
                            ds.onDependency(d);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        };
    }

    private List<CamelContextCustomizer> preConfigureConfiguration(final Resource resource, Node node) {
        ArrayList<CamelContextCustomizer> answer = new ArrayList<CamelContextCustomizer>();
        final ArrayList<String> lines = new ArrayList<String>();
        SequenceNode seq = YamlDeserializerSupport.asSequenceNode(node);
        for (Node n : seq.getValue()) {
            MappingNode content = YamlDeserializerSupport.asMappingNode(n);
            Map<String, Object> params = YamlDeserializerSupport.asMap(content);
            Object type = params.get("type");
            Object value = params.get("value");
            if (!"property".equals(type) || value == null) continue;
            String line = value.toString();
            lines.add(line);
        }
        answer.add(new CamelContextCustomizer(){

            @Override
            public void configure(CamelContext camelContext) {
                try {
                    PropertiesComponent pc = (PropertiesComponent)camelContext.getPropertiesComponent();
                    IntegrationConfigurationPropertiesSource ps = (IntegrationConfigurationPropertiesSource)pc.getPropertiesSource("integration-configuration");
                    if (ps == null) {
                        ps = new IntegrationConfigurationPropertiesSource(pc, new PropertiesLocation(resource.getLocation()), "integration-configuration");
                        pc.addPropertiesSource(ps);
                    }
                    lines.forEach(ps::parseConfigurationValue);
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Error adding properties from spec/configuration", e);
                }
            }
        });
        return answer;
    }

    private List<CamelContextCustomizer> preConfigureTraitConfiguration(final Resource resource, Node node) {
        ArrayList<CamelContextCustomizer> answer = new ArrayList<CamelContextCustomizer>();
        Node target = YamlDeserializerSupport.nodeAt(node, "configuration/properties/");
        final List<String> lines = YamlDeserializerSupport.asStringList(target);
        if (lines == null || lines.isEmpty()) {
            return answer;
        }
        answer.add(new CamelContextCustomizer(){

            @Override
            public void configure(CamelContext camelContext) {
                try {
                    PropertiesComponent pc = (PropertiesComponent)camelContext.getPropertiesComponent();
                    IntegrationConfigurationPropertiesSource ps = (IntegrationConfigurationPropertiesSource)pc.getPropertiesSource("integration-trait-configuration");
                    if (ps == null) {
                        ps = new IntegrationConfigurationPropertiesSource(pc, new PropertiesLocation(resource.getLocation()), "integration-trait-configuration");
                        pc.addPropertiesSource(ps);
                    }
                    lines.forEach(ps::parseConfigurationValue);
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Error adding properties from spec/traits/camel/configuration", e);
                }
            }
        });
        return answer;
    }

    private List<CamelContextCustomizer> preConfigureTraitEnvironment(final Resource resource, Node node) {
        ArrayList<CamelContextCustomizer> answer = new ArrayList<CamelContextCustomizer>();
        Node target = YamlDeserializerSupport.nodeAt(node, "configuration/vars/");
        final List<String> lines = YamlDeserializerSupport.asStringList(target);
        if (lines == null || lines.isEmpty()) {
            return answer;
        }
        answer.add(new CamelContextCustomizer(){

            @Override
            public void configure(CamelContext camelContext) {
                try {
                    PropertiesComponent pc = (PropertiesComponent)camelContext.getPropertiesComponent();
                    IntegrationConfigurationPropertiesSource ps = (IntegrationConfigurationPropertiesSource)pc.getPropertiesSource("environment-trait-configuration");
                    if (ps == null) {
                        ps = new IntegrationConfigurationPropertiesSource(pc, new PropertiesLocation(resource.getLocation()), "environment-trait-configuration");
                        pc.addPropertiesSource(ps);
                    }
                    lines.forEach(ps::parseConfigurationValue);
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Error adding properties from spec/traits/environment/configuration", e);
                }
            }
        });
        return answer;
    }

    private List<CamelContextCustomizer> preConfigureTraitConfigurationBinding(final Resource resource, Map<String, Object> map) {
        ArrayList<CamelContextCustomizer> answer = new ArrayList<CamelContextCustomizer>();
        if (map == null || map.isEmpty()) {
            return null;
        }
        Object value = map.get("trait.camel.apache.org/camel.properties");
        if (value == null || value.toString().isEmpty()) {
            return null;
        }
        final String[] properties = StringQuoteHelper.splitSafeQuote(value.toString(), ',', true);
        answer.add(new CamelContextCustomizer(){

            @Override
            public void configure(CamelContext camelContext) {
                try {
                    PropertiesComponent pc = (PropertiesComponent)camelContext.getPropertiesComponent();
                    IntegrationConfigurationPropertiesSource ps = (IntegrationConfigurationPropertiesSource)pc.getPropertiesSource("binding-trait-configuration");
                    if (ps == null) {
                        ps = new IntegrationConfigurationPropertiesSource(pc, new PropertiesLocation(resource.getLocation()), "binding-trait-configuration");
                        pc.addPropertiesSource(ps);
                    }
                    for (String line : properties) {
                        ps.parseConfigurationValue(line);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Error adding properties from metadata/annotations/", e);
                }
            }
        });
        return answer;
    }

    private List<CamelContextCustomizer> preConfigureTraitEnvironmentBinding(final Resource resource, Map<String, Object> map) {
        ArrayList<CamelContextCustomizer> answer = new ArrayList<CamelContextCustomizer>();
        if (map == null || map.isEmpty()) {
            return null;
        }
        Object value = map.get("trait.camel.apache.org/environment.vars");
        if (value == null || value.toString().isEmpty()) {
            return null;
        }
        final String[] properties = StringQuoteHelper.splitSafeQuote(value.toString(), ',', true);
        answer.add(new CamelContextCustomizer(){

            @Override
            public void configure(CamelContext camelContext) {
                try {
                    PropertiesComponent pc = (PropertiesComponent)camelContext.getPropertiesComponent();
                    IntegrationConfigurationPropertiesSource ps = (IntegrationConfigurationPropertiesSource)pc.getPropertiesSource("environment-trait-configuration");
                    if (ps == null) {
                        ps = new IntegrationConfigurationPropertiesSource(pc, new PropertiesLocation(resource.getLocation()), "environment-trait-configuration");
                        pc.addPropertiesSource(ps);
                    }
                    for (String line : properties) {
                        ps.parseConfigurationValue(line);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeCamelException("Error adding properties from metadata/annotations/", e);
                }
            }
        });
        return answer;
    }

    private List<CamelContextCustomizer> preConfigureSources(Node node) {
        ArrayList<CamelContextCustomizer> answer = new ArrayList<CamelContextCustomizer>();
        SequenceNode seq = YamlDeserializerSupport.asSequenceNode(node);
        for (Node n : seq.getValue()) {
            MappingNode content = YamlDeserializerSupport.asMappingNode(n);
            Map<String, Object> params = YamlDeserializerSupport.asMap(content);
            Object name = params.get("name");
            Object code = params.get("content");
            if (name == null || code == null) continue;
            String ext = FileUtil.onlyExt(name.toString(), false);
            final IntegrationSourceResource res = new IntegrationSourceResource(ext, name.toString(), code.toString());
            answer.add(new CamelContextCustomizer(){

                @Override
                public void configure(CamelContext camelContext) {
                    try {
                        camelContext.adapt(ExtendedCamelContext.class).getRoutesLoader().loadRoutes(res);
                    }
                    catch (Exception e) {
                        throw new RuntimeCamelException("Error loading sources from resource: " + res + " due to " + e.getMessage(), e);
                    }
                }
            });
        }
        return answer;
    }

    private Object preConfigureKameletBinding(Node root, YamlDeserializationContext ctx, Object target, boolean preParse) {
        ArrayList<Object> answer = new ArrayList<Object>();
        MappingNode ann = YamlDeserializerSupport.asMappingNode(YamlDeserializerSupport.nodeAt(root, "/metadata/annotations"));
        Map<String, Object> params = YamlDeserializerSupport.asMap(ann);
        if (params != null) {
            List<CamelContextCustomizer> list = this.preConfigureTraitConfigurationBinding(ctx.getResource(), params);
            if (list != null) {
                answer.addAll(list);
            }
            if ((list = this.preConfigureTraitEnvironmentBinding(ctx.getResource(), params)) != null) {
                answer.addAll(list);
            }
        }
        if (!preParse) {
            RouteDefinition route = new RouteDefinition();
            String routeId = YamlDeserializerSupport.asText(YamlDeserializerSupport.nodeAt(root, "/metadata/name"));
            if (routeId != null) {
                route.routeId(routeId);
            }
            MappingNode source = YamlDeserializerSupport.asMappingNode(YamlDeserializerSupport.nodeAt(root, "/spec/source"));
            MappingNode sink = YamlDeserializerSupport.asMappingNode(YamlDeserializerSupport.nodeAt(root, "/spec/sink"));
            if (source != null && sink != null) {
                MappingNode errorHandler;
                Node steps;
                int line = -1;
                if (source.getStartMark().isPresent()) {
                    line = source.getStartMark().get().getLine();
                }
                String uri = this.extractCamelEndpointUri(source);
                route.from(uri);
                if (line != -1) {
                    route.getInput().setLineNumber(line);
                    if (ctx != null) {
                        route.getInput().setLocation(ctx.getResource().getLocation());
                    }
                }
                if ((steps = YamlDeserializerSupport.nodeAt(root, "/spec/steps")) != null) {
                    SequenceNode sn = YamlDeserializerSupport.asSequenceNode(steps);
                    for (Node node : sn.getValue()) {
                        ProcessorDefinition out;
                        boolean kamelet;
                        MappingNode step = YamlDeserializerSupport.asMappingNode(node);
                        uri = this.extractCamelEndpointUri(step);
                        if (uri == null) continue;
                        line = -1;
                        if (node.getStartMark().isPresent()) {
                            line = node.getStartMark().get().getLine();
                        }
                        if (kamelet = uri.startsWith("kamelet:")) {
                            uri = uri.substring(8);
                            out = new KameletDefinition(uri);
                        } else {
                            out = new ToDefinition(uri);
                        }
                        route.addOutput(out);
                        if (line == -1) continue;
                        out.setLineNumber(line);
                        if (ctx == null) continue;
                        out.setLocation(ctx.getResource().getLocation());
                    }
                }
                line = -1;
                if (sink.getStartMark().isPresent()) {
                    line = sink.getStartMark().get().getLine();
                }
                uri = this.extractCamelEndpointUri(sink);
                ToDefinition to = new ToDefinition(uri);
                route.addOutput(to);
                if (line != -1) {
                    to.setLineNumber(line);
                    if (ctx != null) {
                        to.setLocation(ctx.getResource().getLocation());
                    }
                }
                if ((errorHandler = YamlDeserializerSupport.asMappingNode(YamlDeserializerSupport.nodeAt(root, "/spec/errorHandler"))) != null) {
                    NodeTuple nt = errorHandler.getValue().get(0);
                    String ehName = YamlDeserializerSupport.asText(nt.getKeyNode());
                    DefaultErrorHandlerDefinition ehf = null;
                    if ("sink".equals(ehName)) {
                        DeadLetterChannelDefinition dlcd = new DeadLetterChannelDefinition();
                        MappingNode endpoint = YamlDeserializerSupport.asMappingNode(YamlDeserializerSupport.nodeAt(nt.getValueNode(), "/endpoint"));
                        String dlq = this.extractCamelEndpointUri(endpoint);
                        dlcd.setDeadLetterUri(dlq);
                        ehf = dlcd;
                    } else if ("log".equals(ehName)) {
                        ehf = new DefaultErrorHandlerDefinition();
                    } else if ("none".equals(ehName)) {
                        route.errorHandler(new NoErrorHandlerDefinition());
                    }
                    if (ehf != null) {
                        MappingNode prop = YamlDeserializerSupport.asMappingNode(YamlDeserializerSupport.nodeAt(nt.getValueNode(), "/parameters"));
                        params = YamlDeserializerSupport.asMap(prop);
                        if (params != null) {
                            PropertyBindingSupport.build().withIgnoreCase(true).withFluentBuilder(true).withRemoveParameters(true).withCamelContext(this.getCamelContext()).withTarget(ehf).withProperties(params).bind();
                        }
                        route.errorHandler(ehf);
                    }
                }
            }
            answer.add(route);
        }
        return answer;
    }

    private String extractCamelEndpointUri(MappingNode node) {
        MappingNode mn = null;
        Node ref = YamlDeserializerSupport.nodeAt(node, "/ref");
        if (ref != null) {
            mn = YamlDeserializerSupport.asMappingNode(ref);
        }
        boolean kamelet = mn != null && this.anyTupleMatches(mn.getValue(), "kind", "Kamelet");
        boolean strimzi = !kamelet && mn != null && this.anyTupleMatches(mn.getValue(), "apiVersion", (String v) -> v.startsWith(STRIMZI_VERSION)) && this.anyTupleMatches(mn.getValue(), "kind", "KafkaTopic");
        boolean knative = !kamelet && !strimzi && mn != null && this.anyTupleMatches(mn.getValue(), "apiVersion", (String v) -> v.startsWith(KNATIVE_VERSION));
        Object uri = kamelet || strimzi || knative ? this.extractTupleValue(mn.getValue(), "name") : this.extractTupleValue(node.getValue(), "uri");
        MappingNode prop = YamlDeserializerSupport.asMappingNode(YamlDeserializerSupport.nodeAt(node, "/properties"));
        Map<String, Object> params = YamlDeserializerSupport.asMap(prop);
        if (params != null && !params.isEmpty()) {
            try {
                String query = URISupport.createQueryString(params);
                uri = (String)uri + "?" + query;
            }
            catch (URISyntaxException e) {
                throw new InvalidEndpointException(node, "Error creating URI query parameters", e);
            }
        }
        if (kamelet) {
            return "kamelet:" + (String)uri;
        }
        if (strimzi) {
            return "kafka:" + (String)uri;
        }
        if (knative) {
            return "knative:channel/" + (String)uri;
        }
        return uri;
    }

    @Override
    public void preParseRoute(Resource resource) throws Exception {
        LOG.trace("Pre-parsing: {}", (Object)resource.getLocation());
        if (!resource.exists()) {
            throw new FileNotFoundException("Resource not found: " + resource.getLocation());
        }
        try (InputStream is = this.resourceInputStream(resource);){
            LoadSettings local = LoadSettings.builder().setLabel(resource.getLocation()).build();
            YamlDeserializationContext ctx = this.newYamlDeserializationContext(local, resource);
            StreamReader reader = new StreamReader(local, new YamlUnicodeReader(is));
            ParserImpl parser = new ParserImpl(local, reader);
            Composer composer = new Composer(local, parser);
            try {
                composer.getSingleNode().map(node -> this.preParseNode(ctx, (Node)node));
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error pre-parsing resource: " + ctx.getResource().getLocation(), e);
            }
        }
    }

    private Object preParseNode(YamlDeserializationContext ctx, Node root) {
        LOG.trace("Pre-parsing node: {}", (Object)root);
        YamlDeserializerSupport.setDeserializationContext(root, ctx);
        Object target = this.preConfigureNode(root, ctx, true);
        Iterator<?> it = ObjectHelper.createIterator(target);
        while (it.hasNext()) {
            target = it.next();
            if (!(target instanceof CamelContextCustomizer)) continue;
            CamelContextCustomizer customizer = (CamelContextCustomizer)target;
            customizer.configure(this.getCamelContext());
        }
        return null;
    }
}

