/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.deserializers;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.dsl.yaml.common.YamlDeserializerBase;
import org.apache.camel.model.BeanFactoryDefinition;
import org.apache.camel.model.PropertyDefinition;
import org.snakeyaml.engine.v2.nodes.Node;

public abstract class BeanFactoryDefinitionDeserializer<T extends BeanFactoryDefinition<?, ?>>
extends YamlDeserializerBase<T> {
    protected BeanFactoryDefinitionDeserializer(Class<T> clazz) {
        super(clazz);
    }

    @Override
    protected boolean setProperty(T target, String propertyKey, String propertyName, Node node) {
        switch (propertyKey) {
            case "beanType": 
            case "bean-type": {
                String val = BeanFactoryDefinitionDeserializer.asText(node);
                ((BeanFactoryDefinition)target).setBeanType(val);
                break;
            }
            case "name": {
                String val = BeanFactoryDefinitionDeserializer.asText(node);
                ((BeanFactoryDefinition)target).setName(val);
                break;
            }
            case "property": {
                List<PropertyDefinition> val = BeanFactoryDefinitionDeserializer.asFlatList(node, PropertyDefinition.class);
                ((BeanFactoryDefinition)target).setProperties(val);
                break;
            }
            case "properties": {
                ((BeanFactoryDefinition)target).setProperties(BeanFactoryDefinitionDeserializer.asMap(node).entrySet().stream().map(e -> new PropertyDefinition((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()));
                break;
            }
            case "script": {
                String val = BeanFactoryDefinitionDeserializer.asText(node);
                ((BeanFactoryDefinition)target).setScript(val);
                break;
            }
            case "type": {
                String val = BeanFactoryDefinitionDeserializer.asText(node);
                ((BeanFactoryDefinition)target).setType(val);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

