/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.deserializers;

import java.util.ArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.dsl.yaml.common.YamlSupport;
import org.apache.camel.dsl.yaml.deserializers.NamedBeanDefinition;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.annotations.YamlIn;
import org.apache.camel.spi.annotations.YamlProperty;
import org.apache.camel.spi.annotations.YamlType;
import org.apache.camel.util.ObjectHelper;
import org.snakeyaml.engine.v2.api.ConstructNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.SequenceNode;

@YamlIn
@YamlType(nodes={"beans"}, order=0, properties={@YamlProperty(name="__extends", type="array:org.apache.camel.dsl.yaml.deserializers.NamedBeanDefinition")})
public class BeansDeserializer
extends YamlDeserializerSupport
implements ConstructNode {
    @Override
    public Object construct(Node node) {
        SequenceNode sn = BeansDeserializer.asSequenceNode(node);
        ArrayList<CamelContextCustomizer> customizers = new ArrayList<CamelContextCustomizer>();
        YamlDeserializationContext dc = BeansDeserializer.getDeserializationContext(node);
        for (Node item : sn.getValue()) {
            BeansDeserializer.setDeserializationContext(item, dc);
            final NamedBeanDefinition bean = BeansDeserializer.asType(item, NamedBeanDefinition.class);
            ObjectHelper.notNull(bean.getName(), "The bean name must be set");
            ObjectHelper.notNull(bean.getType(), "The bean type must be set");
            customizers.add(new CamelContextCustomizer(){

                @Override
                public void configure(CamelContext camelContext) {
                    try {
                        String name = bean.getName();
                        camelContext.getRegistry().unbind(name);
                        camelContext.getRegistry().bind(name, bean.newInstance(camelContext));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        return YamlSupport.customizer(customizers);
    }
}

