/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.deserializers;

import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.dsl.yaml.common.exception.InvalidExpressionException;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.language.CSimpleExpression;
import org.apache.camel.model.language.ConstantExpression;
import org.apache.camel.model.language.DatasonnetExpression;
import org.apache.camel.model.language.ExchangePropertyExpression;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.GroovyExpression;
import org.apache.camel.model.language.HeaderExpression;
import org.apache.camel.model.language.Hl7TerserExpression;
import org.apache.camel.model.language.JavaScriptExpression;
import org.apache.camel.model.language.JoorExpression;
import org.apache.camel.model.language.JqExpression;
import org.apache.camel.model.language.JsonPathExpression;
import org.apache.camel.model.language.LanguageExpression;
import org.apache.camel.model.language.MethodCallExpression;
import org.apache.camel.model.language.MvelExpression;
import org.apache.camel.model.language.OgnlExpression;
import org.apache.camel.model.language.PythonExpression;
import org.apache.camel.model.language.RefExpression;
import org.apache.camel.model.language.SimpleExpression;
import org.apache.camel.model.language.SpELExpression;
import org.apache.camel.model.language.TokenizerExpression;
import org.apache.camel.model.language.XMLTokenizerExpression;
import org.apache.camel.model.language.XPathExpression;
import org.apache.camel.model.language.XQueryExpression;
import org.apache.camel.spi.annotations.YamlProperty;
import org.apache.camel.spi.annotations.YamlType;
import org.snakeyaml.engine.v2.api.ConstructNode;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;

public final class ExpressionDeserializers
extends YamlDeserializerSupport {
    private ExpressionDeserializers() {
    }

    public static ExpressionDefinition constructExpressionType(Node node) {
        Node val;
        MappingNode mn = ExpressionDeserializers.asMappingNode(node);
        if (mn.getValue().size() != 1) {
            return null;
        }
        NodeTuple nt = mn.getValue().get(0);
        YamlDeserializationContext dc = ExpressionDeserializers.getDeserializationContext(node);
        String key = ExpressionDeserializers.asText(nt.getKeyNode());
        ExpressionDefinition answer = ExpressionDeserializers.constructExpressionType(key, val = ExpressionDeserializers.setDeserializationContext(nt.getValueNode(), dc));
        if (answer == null) {
            throw new InvalidExpressionException(node, "Unknown expression with id: " + key);
        }
        return answer;
    }

    public static ExpressionDefinition constructExpressionType(String id, Node node) {
        switch (id) {
            case "constant": {
                return ExpressionDeserializers.asType(node, ConstantExpression.class);
            }
            case "csimple": {
                return ExpressionDeserializers.asType(node, CSimpleExpression.class);
            }
            case "datasonnet": {
                return ExpressionDeserializers.asType(node, DatasonnetExpression.class);
            }
            case "exchangeProperty": {
                return ExpressionDeserializers.asType(node, ExchangePropertyExpression.class);
            }
            case "exchange-property": {
                return ExpressionDeserializers.asType(node, ExchangePropertyExpression.class);
            }
            case "groovy": {
                return ExpressionDeserializers.asType(node, GroovyExpression.class);
            }
            case "header": {
                return ExpressionDeserializers.asType(node, HeaderExpression.class);
            }
            case "hl7terser": {
                return ExpressionDeserializers.asType(node, Hl7TerserExpression.class);
            }
            case "joor": {
                return ExpressionDeserializers.asType(node, JoorExpression.class);
            }
            case "jq": {
                return ExpressionDeserializers.asType(node, JqExpression.class);
            }
            case "js": {
                return ExpressionDeserializers.asType(node, JavaScriptExpression.class);
            }
            case "jsonpath": {
                return ExpressionDeserializers.asType(node, JsonPathExpression.class);
            }
            case "language": {
                return ExpressionDeserializers.asType(node, LanguageExpression.class);
            }
            case "method": {
                return ExpressionDeserializers.asType(node, MethodCallExpression.class);
            }
            case "mvel": {
                return ExpressionDeserializers.asType(node, MvelExpression.class);
            }
            case "ognl": {
                return ExpressionDeserializers.asType(node, OgnlExpression.class);
            }
            case "python": {
                return ExpressionDeserializers.asType(node, PythonExpression.class);
            }
            case "ref": {
                return ExpressionDeserializers.asType(node, RefExpression.class);
            }
            case "simple": {
                return ExpressionDeserializers.asType(node, SimpleExpression.class);
            }
            case "spel": {
                return ExpressionDeserializers.asType(node, SpELExpression.class);
            }
            case "tokenize": {
                return ExpressionDeserializers.asType(node, TokenizerExpression.class);
            }
            case "xpath": {
                return ExpressionDeserializers.asType(node, XPathExpression.class);
            }
            case "xquery": {
                return ExpressionDeserializers.asType(node, XQueryExpression.class);
            }
            case "xtokenize": {
                return ExpressionDeserializers.asType(node, XMLTokenizerExpression.class);
            }
            case "expression": {
                return ExpressionDeserializers.constructExpressionType(node);
            }
            case "expression-type": {
                return ExpressionDeserializers.constructExpressionType(node);
            }
            case "expressionType": {
                return ExpressionDeserializers.constructExpressionType(node);
            }
        }
        return null;
    }

    @YamlType(types={ExpressionSubElementDefinition.class}, order=2147482646, properties={@YamlProperty(name="constant", type="object:org.apache.camel.model.language.ConstantExpression"), @YamlProperty(name="csimple", type="object:org.apache.camel.model.language.CSimpleExpression"), @YamlProperty(name="datasonnet", type="object:org.apache.camel.model.language.DatasonnetExpression"), @YamlProperty(name="exchangeProperty", type="object:org.apache.camel.model.language.ExchangePropertyExpression"), @YamlProperty(name="exchange-property", type="object:org.apache.camel.model.language.ExchangePropertyExpression"), @YamlProperty(name="groovy", type="object:org.apache.camel.model.language.GroovyExpression"), @YamlProperty(name="header", type="object:org.apache.camel.model.language.HeaderExpression"), @YamlProperty(name="hl7terser", type="object:org.apache.camel.model.language.Hl7TerserExpression"), @YamlProperty(name="joor", type="object:org.apache.camel.model.language.JoorExpression"), @YamlProperty(name="jq", type="object:org.apache.camel.model.language.JqExpression"), @YamlProperty(name="js", type="object:org.apache.camel.model.language.JavaScriptExpression"), @YamlProperty(name="jsonpath", type="object:org.apache.camel.model.language.JsonPathExpression"), @YamlProperty(name="language", type="object:org.apache.camel.model.language.LanguageExpression"), @YamlProperty(name="method", type="object:org.apache.camel.model.language.MethodCallExpression"), @YamlProperty(name="mvel", type="object:org.apache.camel.model.language.MvelExpression"), @YamlProperty(name="ognl", type="object:org.apache.camel.model.language.OgnlExpression"), @YamlProperty(name="python", type="object:org.apache.camel.model.language.PythonExpression"), @YamlProperty(name="ref", type="object:org.apache.camel.model.language.RefExpression"), @YamlProperty(name="simple", type="object:org.apache.camel.model.language.SimpleExpression"), @YamlProperty(name="spel", type="object:org.apache.camel.model.language.SpELExpression"), @YamlProperty(name="tokenize", type="object:org.apache.camel.model.language.TokenizerExpression"), @YamlProperty(name="xpath", type="object:org.apache.camel.model.language.XPathExpression"), @YamlProperty(name="xquery", type="object:org.apache.camel.model.language.XQueryExpression"), @YamlProperty(name="xtokenize", type="object:org.apache.camel.model.language.XMLTokenizerExpression")})
    public static class ExpressionSubElementDefinitionDeserializers
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            ExpressionDefinition val = ExpressionDeserializers.constructExpressionType(node);
            return new ExpressionSubElementDefinition(val);
        }
    }

    @YamlType(types={ExpressionDefinition.class}, order=2147482646, properties={@YamlProperty(name="constant", type="object:org.apache.camel.model.language.ConstantExpression"), @YamlProperty(name="csimple", type="object:org.apache.camel.model.language.CSimpleExpression"), @YamlProperty(name="datasonnet", type="object:org.apache.camel.model.language.DatasonnetExpression"), @YamlProperty(name="exchangeProperty", type="object:org.apache.camel.model.language.ExchangePropertyExpression"), @YamlProperty(name="exchange-property", type="object:org.apache.camel.model.language.ExchangePropertyExpression"), @YamlProperty(name="groovy", type="object:org.apache.camel.model.language.GroovyExpression"), @YamlProperty(name="header", type="object:org.apache.camel.model.language.HeaderExpression"), @YamlProperty(name="hl7terser", type="object:org.apache.camel.model.language.Hl7TerserExpression"), @YamlProperty(name="joor", type="object:org.apache.camel.model.language.JoorExpression"), @YamlProperty(name="jq", type="object:org.apache.camel.model.language.JqExpression"), @YamlProperty(name="js", type="object:org.apache.camel.model.language.JavaScriptExpression"), @YamlProperty(name="jsonpath", type="object:org.apache.camel.model.language.JsonPathExpression"), @YamlProperty(name="language", type="object:org.apache.camel.model.language.LanguageExpression"), @YamlProperty(name="method", type="object:org.apache.camel.model.language.MethodCallExpression"), @YamlProperty(name="mvel", type="object:org.apache.camel.model.language.MvelExpression"), @YamlProperty(name="ognl", type="object:org.apache.camel.model.language.OgnlExpression"), @YamlProperty(name="python", type="object:org.apache.camel.model.language.PythonExpression"), @YamlProperty(name="ref", type="object:org.apache.camel.model.language.RefExpression"), @YamlProperty(name="simple", type="object:org.apache.camel.model.language.SimpleExpression"), @YamlProperty(name="spel", type="object:org.apache.camel.model.language.SpELExpression"), @YamlProperty(name="tokenize", type="object:org.apache.camel.model.language.TokenizerExpression"), @YamlProperty(name="xpath", type="object:org.apache.camel.model.language.XPathExpression"), @YamlProperty(name="xquery", type="object:org.apache.camel.model.language.XQueryExpression"), @YamlProperty(name="xtokenize", type="object:org.apache.camel.model.language.XMLTokenizerExpression")})
    public static class ExpressionDefinitionDeserializers
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            return ExpressionDeserializers.constructExpressionType(node);
        }
    }
}

