/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.deserializers;

import org.apache.camel.dsl.yaml.common.YamlDeserializerBase;
import org.apache.camel.dsl.yaml.common.exception.UnsupportedFieldException;
import org.apache.camel.dsl.yaml.deserializers.NamedBeanDefinition;
import org.apache.camel.spi.annotations.YamlProperty;
import org.apache.camel.spi.annotations.YamlType;
import org.apache.camel.util.ObjectHelper;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;

@YamlType(types={NamedBeanDefinition.class}, order=0, properties={@YamlProperty(name="name", type="string", required=true), @YamlProperty(name="type", type="string", required=true), @YamlProperty(name="properties", type="object")})
public class NamedBeanDeserializer
extends YamlDeserializerBase<NamedBeanDefinition> {
    public NamedBeanDeserializer() {
        super(NamedBeanDefinition.class);
    }

    @Override
    protected NamedBeanDefinition newInstance() {
        return new NamedBeanDefinition();
    }

    @Override
    public NamedBeanDefinition construct(Node node) {
        MappingNode bn = NamedBeanDeserializer.asMappingNode(node);
        NamedBeanDefinition answer = new NamedBeanDefinition();
        block10: for (NodeTuple tuple : bn.getValue()) {
            String key = NamedBeanDeserializer.asText(tuple.getKeyNode());
            Node val = tuple.getValueNode();
            switch (key) {
                case "name": {
                    answer.setName(NamedBeanDeserializer.asText(val));
                    continue block10;
                }
                case "type": {
                    Object type = NamedBeanDeserializer.asText(val);
                    if (!((String)type).startsWith("#class:")) {
                        type = "#class:" + (String)type;
                    }
                    answer.setType((String)type);
                    continue block10;
                }
                case "properties": {
                    answer.setProperties(NamedBeanDeserializer.asMap(val));
                    continue block10;
                }
            }
            throw new UnsupportedFieldException(val, key);
        }
        ObjectHelper.notNull(answer.getName(), "The bean name must be set");
        ObjectHelper.notNull(answer.getType(), "The bean type must be set");
        return answer;
    }
}

