/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.deserializers;

import java.util.Map;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerBase;
import org.apache.camel.dsl.yaml.common.YamlSupport;
import org.apache.camel.dsl.yaml.common.exception.UnsupportedFieldException;
import org.apache.camel.dsl.yaml.deserializers.OutputAwareFromDefinition;
import org.apache.camel.model.DescriptionDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.spi.annotations.YamlProperty;
import org.apache.camel.spi.annotations.YamlType;
import org.apache.camel.util.ObjectHelper;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;

@YamlType(types={OutputAwareFromDefinition.class}, order=0, properties={@YamlProperty(name="uri", type="string", required=true), @YamlProperty(name="id", type="string"), @YamlProperty(name="description", type="string"), @YamlProperty(name="parameters", type="object"), @YamlProperty(name="steps", type="array:org.apache.camel.model.ProcessorDefinition", required=true)})
public class OutputAwareFromDefinitionDeserializer
extends YamlDeserializerBase<OutputAwareFromDefinition> {
    public OutputAwareFromDefinitionDeserializer() {
        super(OutputAwareFromDefinition.class);
    }

    @Override
    protected OutputAwareFromDefinition newInstance() {
        return new OutputAwareFromDefinition();
    }

    @Override
    protected OutputAwareFromDefinition newInstance(String value) {
        return new OutputAwareFromDefinition(value);
    }

    @Override
    protected void setProperties(OutputAwareFromDefinition target, MappingNode node) {
        YamlDeserializationContext dc = OutputAwareFromDefinitionDeserializer.getDeserializationContext(node);
        int line = -1;
        if (node.getStartMark().isPresent()) {
            line = node.getStartMark().get().getLine();
        }
        String uri = null;
        String id = null;
        DescriptionDefinition desc = null;
        Map<String, Object> parameters = null;
        block14: for (NodeTuple tuple : node.getValue()) {
            String key = OutputAwareFromDefinitionDeserializer.asText(tuple.getKeyNode());
            Node val = tuple.getValueNode();
            OutputAwareFromDefinitionDeserializer.setDeserializationContext(val, dc);
            switch (key) {
                case "id": {
                    id = OutputAwareFromDefinitionDeserializer.asText(val);
                    continue block14;
                }
                case "description": {
                    desc = OutputAwareFromDefinitionDeserializer.asType(val, DescriptionDefinition.class);
                    continue block14;
                }
                case "uri": {
                    uri = OutputAwareFromDefinitionDeserializer.asText(val);
                    continue block14;
                }
                case "parameters": {
                    parameters = OutputAwareFromDefinitionDeserializer.parseParameters(tuple);
                    continue block14;
                }
                case "steps": {
                    OutputAwareFromDefinitionDeserializer.setSteps(target, val);
                    continue block14;
                }
            }
            throw new UnsupportedFieldException(node, key);
        }
        if (target.getDelegate() == null) {
            ObjectHelper.notNull("uri", "The uri must set");
            FromDefinition from = new FromDefinition(YamlSupport.createEndpointUri(dc.getCamelContext(), node, uri, parameters));
            if (line != -1) {
                from.setLineNumber(line);
                from.setLocation(dc.getResource().getLocation());
            }
            if (id != null) {
                from.setId(id);
            }
            if (desc != null) {
                from.setDescription(desc);
            }
            target.setDelegate(from);
        }
    }
}

