/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.deserializers;

import java.util.List;
import org.apache.camel.dsl.yaml.common.YamlDeserializerBase;
import org.apache.camel.dsl.yaml.common.exception.InvalidRouteException;
import org.apache.camel.dsl.yaml.deserializers.OutputAwareFromDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateBeanDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplateParameterDefinition;
import org.apache.camel.spi.annotations.YamlIn;
import org.apache.camel.spi.annotations.YamlProperty;
import org.apache.camel.spi.annotations.YamlType;
import org.snakeyaml.engine.v2.nodes.Node;

@YamlIn
@YamlType(nodes={"route-template", "routeTemplate"}, types={RouteTemplateDefinition.class}, order=2147482646, properties={@YamlProperty(name="id", type="string", required=true), @YamlProperty(name="route", type="object:org.apache.camel.model.RouteDefinition"), @YamlProperty(name="from", type="object:org.apache.camel.model.FromDefinition"), @YamlProperty(name="parameters", type="array:org.apache.camel.model.RouteTemplateParameterDefinition"), @YamlProperty(name="beans", type="array:org.apache.camel.dsl.yaml.deserializers.NamedBeanDefinition")})
public class RouteTemplateDefinitionDeserializer
extends YamlDeserializerBase<RouteTemplateDefinition> {
    public RouteTemplateDefinitionDeserializer() {
        super(RouteTemplateDefinition.class);
    }

    @Override
    protected RouteTemplateDefinition newInstance() {
        return new RouteTemplateDefinition();
    }

    @Override
    protected boolean setProperty(RouteTemplateDefinition target, String propertyKey, String propertyName, Node node) {
        switch (propertyKey) {
            case "id": {
                target.setId(RouteTemplateDefinitionDeserializer.asText(node));
                break;
            }
            case "route": {
                RouteDefinition route = RouteTemplateDefinitionDeserializer.asType(node, RouteDefinition.class);
                target.setRoute(route);
                break;
            }
            case "from": {
                OutputAwareFromDefinition val = RouteTemplateDefinitionDeserializer.asType(node, OutputAwareFromDefinition.class);
                RouteDefinition route = new RouteDefinition();
                route.setInput(val.getDelegate());
                route.setOutputs(val.getOutputs());
                target.setRoute(route);
                break;
            }
            case "parameters": {
                List<RouteTemplateParameterDefinition> items = RouteTemplateDefinitionDeserializer.asFlatList(node, RouteTemplateParameterDefinition.class);
                target.setTemplateParameters(items);
                break;
            }
            case "beans": {
                List<RouteTemplateBeanDefinition> items = RouteTemplateDefinitionDeserializer.asFlatList(node, RouteTemplateBeanDefinition.class);
                target.setTemplateBeans(items);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void afterPropertiesSet(RouteTemplateDefinition target, Node node) {
        if (target.getRoute() == null) {
            throw new InvalidRouteException(node, "RouteTemplate must have route or from set");
        }
        if (target.getRoute().getInput() == null) {
            throw new InvalidRouteException(node, "RouteTemplate must have from set");
        }
    }
}

