/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.AggregationStrategyAwareDefinition;
import org.apache.camel.model.EnrichDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.Enricher;
import org.apache.camel.reifier.ExpressionReifier;

public class EnrichReifier
extends ExpressionReifier<EnrichDefinition> {
    public EnrichReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (EnrichDefinition)EnrichDefinition.class.cast(definition));
    }

    @Override
    public Processor createProcessor() throws Exception {
        AggregationStrategy strategy;
        Expression exp = this.createExpression(((EnrichDefinition)this.definition).getExpression());
        boolean isShareUnitOfWork = this.parseBoolean(((EnrichDefinition)this.definition).getShareUnitOfWork(), false);
        boolean isIgnoreInvalidEndpoint = this.parseBoolean(((EnrichDefinition)this.definition).getIgnoreInvalidEndpoint(), false);
        boolean isAggregateOnException = this.parseBoolean(((EnrichDefinition)this.definition).getAggregateOnException(), false);
        Enricher enricher = new Enricher(exp);
        enricher.setShareUnitOfWork(isShareUnitOfWork);
        enricher.setIgnoreInvalidEndpoint(isIgnoreInvalidEndpoint);
        enricher.setAggregateOnException(isAggregateOnException);
        Integer num = this.parseInt(((EnrichDefinition)this.definition).getCacheSize());
        if (num != null) {
            enricher.setCacheSize(num);
        }
        if ((strategy = this.getConfiguredAggregationStrategy((AggregationStrategyAwareDefinition)((Object)this.definition))) != null) {
            enricher.setAggregationStrategy(strategy);
        }
        if (((EnrichDefinition)this.definition).getAggregateOnException() != null) {
            enricher.setAggregateOnException(this.parseBoolean(((EnrichDefinition)this.definition).getAggregateOnException(), false));
        }
        if (((EnrichDefinition)this.definition).getAllowOptimisedComponents() != null) {
            enricher.setAllowOptimisedComponents(this.parseBoolean(((EnrichDefinition)this.definition).getAllowOptimisedComponents(), true));
        }
        return enricher;
    }
}

