/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.reporter.libthrift;

import java.util.List;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocolUtil;

public final class InternalScribeCodec {
    static final TField CATEGORY_FIELD_DESC = new TField("category", 11, 1);
    static final TField MESSAGE_FIELD_DESC = new TField("message", 11, 2);
    static final TField MESSAGES_FIELD_DESC = new TField("messages", 15, 1);
    static final byte[] MAP = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};

    public static int messageSizeInBytes(byte[] category, int spanSizeInBytes) {
        int sizeInBytes = 15;
        sizeInBytes += 3;
        sizeInBytes += 5;
        sizeInBytes += InternalScribeCodec.sizeOfLogEntry(category, spanSizeInBytes);
        return ++sizeInBytes;
    }

    public static int messageSizeInBytes(byte[] category, List<byte[]> encodedSpans) {
        int sizeInBytes = 15;
        sizeInBytes += 3;
        sizeInBytes += 5;
        for (byte[] encodedSpan : encodedSpans) {
            sizeInBytes += InternalScribeCodec.sizeOfLogEntry(category, encodedSpan.length);
        }
        return ++sizeInBytes;
    }

    public static void writeLogRequest(byte[] category, List<byte[]> encodedSpans, int seqid, TBinaryProtocol oprot) throws TException {
        oprot.writeMessageBegin(new TMessage("Log", 1, seqid));
        oprot.writeFieldBegin(MESSAGES_FIELD_DESC);
        oprot.writeListBegin(new TList(12, encodedSpans.size()));
        for (byte[] encodedSpan : encodedSpans) {
            InternalScribeCodec.write(category, encodedSpan, oprot);
        }
        oprot.writeFieldStop();
    }

    public static boolean readLogResponse(int seqid, TBinaryProtocol iprot) throws TException {
        TMessage msg = iprot.readMessageBegin();
        if (msg.type == 3) {
            throw TApplicationException.readFrom(iprot);
        }
        if (msg.seqid != seqid) {
            throw new TApplicationException(4, "Log failed: out of sequence response");
        }
        return InternalScribeCodec.parseResponse(iprot);
    }

    static boolean parseResponse(TBinaryProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField schemeField = iprot.readFieldBegin();
            if (schemeField.type == 0) break;
            if (schemeField.id == 0 && schemeField.type == 8) {
                return iprot.readI32() == 0;
            }
            TProtocolUtil.skip(iprot, schemeField.type);
        }
        throw new TApplicationException(5, "Log failed: unknown result");
    }

    static int sizeOfLogEntry(byte[] category, int spanSizeInBytes) {
        int sizeInBytes = 7 + category.length;
        sizeInBytes += 7 + InternalScribeCodec.base64SizeInBytes(spanSizeInBytes);
        return ++sizeInBytes;
    }

    static void write(byte[] category, byte[] span, TBinaryProtocol oprot) throws TException {
        oprot.writeFieldBegin(CATEGORY_FIELD_DESC);
        oprot.writeI32(category.length);
        oprot.getTransport().write(category, 0, category.length);
        oprot.writeFieldBegin(MESSAGE_FIELD_DESC);
        byte[] base64 = InternalScribeCodec.base64(span);
        oprot.writeI32(base64.length);
        oprot.getTransport().write(base64, 0, base64.length);
        oprot.writeFieldStop();
    }

    static byte[] base64(byte[] in) {
        int length = InternalScribeCodec.base64SizeInBytes(in.length);
        byte[] out = new byte[length];
        int index = 0;
        int end = in.length - in.length % 3;
        for (int i = 0; i < end; i += 3) {
            out[index++] = MAP[(in[i] & 0xFF) >> 2];
            out[index++] = MAP[(in[i] & 3) << 4 | (in[i + 1] & 0xFF) >> 4];
            out[index++] = MAP[(in[i + 1] & 0xF) << 2 | (in[i + 2] & 0xFF) >> 6];
            out[index++] = MAP[in[i + 2] & 0x3F];
        }
        switch (in.length % 3) {
            case 1: {
                out[index++] = MAP[(in[end] & 0xFF) >> 2];
                out[index++] = MAP[(in[end] & 3) << 4];
                out[index++] = 61;
                out[index++] = 61;
                break;
            }
            case 2: {
                out[index++] = MAP[(in[end] & 0xFF) >> 2];
                out[index++] = MAP[(in[end] & 3) << 4 | (in[end + 1] & 0xFF) >> 4];
                out[index++] = MAP[(in[end + 1] & 0xF) << 2];
                out[index++] = 61;
            }
        }
        assert (index == out.length) : "index " + index + " != out.length " + out.length;
        return out;
    }

    static int base64SizeInBytes(int sizeInBytes) {
        int result = sizeInBytes * 4 / 3;
        int remainder = sizeInBytes * 4 % 3;
        return remainder == 0 ? result : result + (4 - remainder);
    }
}

