/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.zipkin;

import brave.Span;
import brave.Tracing;
import brave.context.slf4j.MDCScopeDecorator;
import brave.propagation.B3Propagation;
import brave.propagation.Propagation;
import brave.propagation.ThreadLocalCurrentTraceContext;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import brave.sampler.Sampler;
import java.io.Closeable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.NamedNode;
import org.apache.camel.Route;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.StaticService;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.zipkin.CamelRequest;
import org.apache.camel.zipkin.ServiceHostFunction;
import org.apache.camel.zipkin.ServicePortFunction;
import org.apache.camel.zipkin.ZipkinClientRequestAdapter;
import org.apache.camel.zipkin.ZipkinClientResponseAdaptor;
import org.apache.camel.zipkin.ZipkinServerRequestAdapter;
import org.apache.camel.zipkin.ZipkinServerResponseAdapter;
import org.apache.camel.zipkin.ZipkinState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import zipkin2.reporter.AsyncReporter;
import zipkin2.reporter.Reporter;
import zipkin2.reporter.libthrift.LibthriftSender;
import zipkin2.reporter.urlconnection.URLConnectionSender;

@ManagedResource(description="ZipkinTracer")
public class ZipkinTracer
extends ServiceSupport
implements RoutePolicyFactory,
StaticService,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(ZipkinTracer.class);
    private static final String ZIPKIN_COLLECTOR_HTTP_SERVICE = "zipkin-collector-http";
    private static final String ZIPKIN_COLLECTOR_THRIFT_SERVICE = "zipkin-collector-thrift";
    private static final Propagation.Getter<CamelRequest, String> GETTER = (cr, key) -> cr.getHeader((String)key);
    private static final Propagation.Setter<CamelRequest, String> SETTER = (cr, key, value) -> cr.setHeader((String)key, value);
    static final TraceContext.Extractor<CamelRequest> EXTRACTOR = B3Propagation.B3_STRING.extractor(GETTER);
    private static final TraceContext.Injector<CamelRequest> INJECTOR = B3Propagation.B3_STRING.injector(SETTER);
    private final ZipkinEventNotifier eventNotifier = new ZipkinEventNotifier();
    private final Map<String, Tracing> braves = new HashMap<String, Tracing>();
    private transient boolean useFallbackServiceNames;
    private CamelContext camelContext;
    private String endpoint;
    private String hostName;
    private int port;
    private float rate = 1.0f;
    private Reporter<zipkin2.Span> spanReporter;
    private Map<String, String> clientServiceMappings = new HashMap<String, String>();
    private Map<String, String> serverServiceMappings = new HashMap<String, String>();
    private Set<String> excludePatterns = new HashSet<String>();
    private boolean includeMessageBody;
    private boolean includeMessageBodyStreams;
    private Map<String, String> clientCustomTags = Collections.emptyMap();
    private final Map<String, Span.Kind> producerComponentToSpanKind = new HashMap<String, Span.Kind>();
    private final Map<String, Span.Kind> consumerComponentToSpanKind = new HashMap<String, Span.Kind>();

    public ZipkinTracer() {
        this.producerComponentToSpanKind.put("jms", Span.Kind.PRODUCER);
        this.producerComponentToSpanKind.put("sjms", Span.Kind.PRODUCER);
        this.producerComponentToSpanKind.put("activemq", Span.Kind.PRODUCER);
        this.producerComponentToSpanKind.put("kafka", Span.Kind.PRODUCER);
        this.producerComponentToSpanKind.put("amqp", Span.Kind.PRODUCER);
        this.consumerComponentToSpanKind.put("jms", Span.Kind.CONSUMER);
        this.consumerComponentToSpanKind.put("sjms", Span.Kind.CONSUMER);
        this.consumerComponentToSpanKind.put("activemq", Span.Kind.CONSUMER);
        this.consumerComponentToSpanKind.put("kafka", Span.Kind.CONSUMER);
        this.consumerComponentToSpanKind.put("amqp", Span.Kind.CONSUMER);
    }

    @Override
    public RoutePolicy createRoutePolicy(CamelContext camelContext, String routeId, NamedNode route) {
        this.init(camelContext);
        return new ZipkinRoutePolicy();
    }

    public void init(CamelContext camelContext) {
        if (!camelContext.hasService(this)) {
            try {
                camelContext.addService(this, true, true);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException(e);
            }
        }
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @ManagedAttribute(description="The POST URL for zipkin's v2 api.")
    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @ManagedAttribute(description="The hostname for the remote zipkin scribe collector.")
    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @ManagedAttribute(description="The port number for the remote zipkin scribe collector.")
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @ManagedAttribute(description="Rates how many events should be traced by zipkin. The rate is expressed as a percentage (1.0f = 100%, 0.5f is 50%, 0.1f is 10%).")
    public float getRate() {
        return this.rate;
    }

    public void setRate(float rate) {
        this.rate = rate;
    }

    public void setSpanReporter(Reporter<zipkin2.Span> spanReporter) {
        this.spanReporter = spanReporter;
    }

    public Reporter<zipkin2.Span> getSpanReporter() {
        return this.spanReporter;
    }

    public String getServiceName() {
        return this.clientServiceMappings.get("*");
    }

    public void setServiceName(String serviceName) {
        this.clientServiceMappings.put("*", serviceName);
        this.serverServiceMappings.put("*", serviceName);
    }

    public Map<String, String> getClientServiceMappings() {
        return this.clientServiceMappings;
    }

    public void setClientServiceMappings(Map<String, String> clientServiceMappings) {
        this.clientServiceMappings = clientServiceMappings;
    }

    public void addClientServiceMapping(String pattern, String serviceName) {
        this.clientServiceMappings.put(pattern, serviceName);
    }

    public Map<String, String> getServerServiceMappings() {
        return this.serverServiceMappings;
    }

    public void setServerServiceMappings(Map<String, String> serverServiceMappings) {
        this.serverServiceMappings = serverServiceMappings;
    }

    public void addServerServiceMapping(String pattern, String serviceName) {
        this.serverServiceMappings.put(pattern, serviceName);
    }

    public Set<String> getExcludePatterns() {
        return this.excludePatterns;
    }

    public void setExcludePatterns(Set<String> excludePatterns) {
        this.excludePatterns = excludePatterns;
    }

    public void addExcludePattern(String pattern) {
        this.excludePatterns.add(pattern);
    }

    @ManagedAttribute(description="Whether to include the Camel message body in the zipkin traces")
    public boolean isIncludeMessageBody() {
        return this.includeMessageBody;
    }

    @ManagedAttribute(description="Whether to include the Camel message body in the zipkin traces")
    public void setIncludeMessageBody(boolean includeMessageBody) {
        this.includeMessageBody = includeMessageBody;
    }

    @ManagedAttribute(description="Whether to include stream based Camel message bodies in the zipkin traces")
    public boolean isIncludeMessageBodyStreams() {
        return this.includeMessageBodyStreams;
    }

    @ManagedAttribute(description="Whether to include stream based Camel message bodies in the zipkin traces")
    public void setIncludeMessageBodyStreams(boolean includeMessageBodyStreams) {
        this.includeMessageBodyStreams = includeMessageBodyStreams;
    }

    public void setClientCustomTags(Map<String, String> clientCustomTags) {
        this.clientCustomTags = clientCustomTags == null ? Collections.emptyMap() : new HashMap<String, String>(clientCustomTags);
    }

    public Map<String, String> getClientCustomTags() {
        return this.clientCustomTags;
    }

    @Override
    protected void doInit() throws Exception {
        String serviceName;
        Set<Reporter> reporters;
        ObjectHelper.notNull(this.camelContext, "CamelContext", this);
        this.camelContext.getManagementStrategy().addEventNotifier(this.eventNotifier);
        if (!this.camelContext.getRoutePolicyFactories().contains(this)) {
            this.camelContext.addRoutePolicyFactory(this);
        }
        if (this.spanReporter == null) {
            if (this.endpoint != null) {
                LOG.info("Configuring Zipkin URLConnectionSender using endpoint: {}", (Object)this.endpoint);
                this.spanReporter = AsyncReporter.create(URLConnectionSender.create(this.endpoint));
            } else if (this.hostName != null && this.port > 0) {
                LOG.info("Configuring Zipkin ScribeSpanCollector using host: {} and port: {}", (Object)this.hostName, (Object)this.port);
                LibthriftSender sender = LibthriftSender.newBuilder().host(this.hostName).port(this.port).build();
                this.spanReporter = AsyncReporter.create(sender);
            } else {
                int num;
                String host = ServiceHostFunction.apply(ZIPKIN_COLLECTOR_HTTP_SERVICE);
                String port = ServicePortFunction.apply(ZIPKIN_COLLECTOR_HTTP_SERVICE);
                if (ObjectHelper.isNotEmpty(host) && ObjectHelper.isNotEmpty(port)) {
                    LOG.info("Auto-configuring Zipkin URLConnectionSender using host: {} and port: {}", (Object)host, (Object)port);
                    num = this.camelContext.getTypeConverter().mandatoryConvertTo(Integer.class, port);
                    String implicitEndpoint = "http://" + host + ":" + num + "/api/v2/spans";
                    this.spanReporter = AsyncReporter.create(URLConnectionSender.create(implicitEndpoint));
                } else {
                    host = ServiceHostFunction.apply(ZIPKIN_COLLECTOR_THRIFT_SERVICE);
                    port = ServicePortFunction.apply(ZIPKIN_COLLECTOR_THRIFT_SERVICE);
                    if (ObjectHelper.isNotEmpty(host) && ObjectHelper.isNotEmpty(port)) {
                        LOG.info("Auto-configuring Zipkin ScribeSpanCollector using host: {} and port: {}", (Object)host, (Object)port);
                        num = this.camelContext.getTypeConverter().mandatoryConvertTo(Integer.class, port);
                        LibthriftSender sender = LibthriftSender.newBuilder().host(host).port(num).build();
                        this.spanReporter = AsyncReporter.create(sender);
                    }
                }
            }
        }
        if (this.spanReporter == null && (reporters = this.camelContext.getRegistry().findByType(Reporter.class)).size() == 1) {
            this.spanReporter = reporters.iterator().next();
        }
        ObjectHelper.notNull(this.spanReporter, "Reporter<zipkin2.Span>", this);
        if (this.clientServiceMappings.isEmpty() && this.serverServiceMappings.isEmpty()) {
            LOG.warn("No service name(s) has been mapped in clientServiceMappings or serverServiceMappings. Camel will fallback and use endpoint uris as service names.");
            this.useFallbackServiceNames = true;
        }
        for (Map.Entry<String, String> entry : this.clientServiceMappings.entrySet()) {
            String pattern = entry.getKey();
            serviceName = entry.getValue();
            this.createTracingForService(pattern, serviceName);
        }
        for (Map.Entry<String, String> entry : this.serverServiceMappings.entrySet()) {
            String pattern = entry.getKey();
            serviceName = entry.getValue();
            this.createTracingForService(pattern, serviceName);
        }
        ServiceHelper.startService(this.spanReporter, this.eventNotifier);
    }

    @Override
    protected void doShutdown() throws Exception {
        this.camelContext.getManagementStrategy().removeEventNotifier(this.eventNotifier);
        ServiceHelper.stopService((Object)this.eventNotifier);
        ServiceHelper.stopAndShutdownService(this.spanReporter);
        if (this.spanReporter instanceof Closeable) {
            IOHelper.close((Closeable)((Object)this.spanReporter));
        }
        this.braves.clear();
        this.camelContext.getRoutePolicyFactories().remove(this);
    }

    private String getServiceName(Exchange exchange, Endpoint endpoint, boolean server, boolean client) {
        if (client) {
            return this.getServiceName(exchange, endpoint, this.clientServiceMappings);
        }
        if (server) {
            return this.getServiceName(exchange, endpoint, this.serverServiceMappings);
        }
        return null;
    }

    private String getServiceName(Exchange exchange, Endpoint endpoint, Map<String, String> serviceMappings) {
        String id;
        String pattern;
        String url;
        String answer = null;
        if (endpoint != null && (url = endpoint.getEndpointUri()) != null) {
            for (String string : this.excludePatterns) {
                if (!EndpointHelper.matchEndpoint(exchange.getContext(), url, string)) continue;
                return null;
            }
            for (Map.Entry entry : serviceMappings.entrySet()) {
                pattern = (String)entry.getKey();
                if (!EndpointHelper.matchEndpoint(exchange.getContext(), url, pattern)) continue;
                answer = (String)entry.getValue();
                break;
            }
        }
        if (answer == null && (id = ZipkinTracer.routeIdExpression().evaluate(exchange, String.class)) != null) {
            for (String string : this.excludePatterns) {
                if (!PatternHelper.matchPattern(id, string)) continue;
                return null;
            }
            for (Map.Entry entry : serviceMappings.entrySet()) {
                pattern = (String)entry.getKey();
                if (!PatternHelper.matchPattern(id, pattern)) continue;
                answer = (String)entry.getValue();
                break;
            }
        }
        if (answer == null && (id = exchange.getFromRouteId()) != null) {
            for (String string : this.excludePatterns) {
                if (!PatternHelper.matchPattern(id, string)) continue;
                return null;
            }
            for (Map.Entry entry : serviceMappings.entrySet()) {
                pattern = (String)entry.getKey();
                if (!PatternHelper.matchPattern(id, pattern)) continue;
                answer = (String)entry.getValue();
                break;
            }
        }
        if (answer == null && this.useFallbackServiceNames) {
            String key = null;
            if (endpoint != null) {
                key = endpoint.getEndpointKey();
            } else if (exchange.getFromEndpoint() != null) {
                key = exchange.getFromEndpoint().getEndpointKey();
            }
            for (String string : this.excludePatterns) {
                if (!PatternHelper.matchPattern(key, string)) continue;
                return null;
            }
            String sanitizedKey = URISupport.sanitizeUri(key);
            if (LOG.isTraceEnabled() && sanitizedKey != null) {
                LOG.trace("Using serviceName: {} as fallback", (Object)sanitizedKey);
            }
            return sanitizedKey;
        }
        if (LOG.isTraceEnabled() && answer != null) {
            LOG.trace("Using serviceName: {}", answer);
        }
        return answer;
    }

    private void createTracingForService(String pattern, String serviceName) {
        Tracing brave = this.braves.get(pattern);
        if (brave == null && !this.braves.containsKey(serviceName)) {
            brave = this.newTracing(serviceName);
            this.braves.put(serviceName, brave);
        }
    }

    private Tracing newTracing(String serviceName) {
        Tracing brave = null;
        brave = this.camelContext.isUseMDCLogging() != false ? Tracing.newBuilder().currentTraceContext(ThreadLocalCurrentTraceContext.newBuilder().addScopeDecorator(MDCScopeDecorator.create()).build()).localServiceName(serviceName).sampler(Sampler.create(this.rate)).spanReporter(this.spanReporter).build() : Tracing.newBuilder().localServiceName(serviceName).sampler(Sampler.create(this.rate)).spanReporter(this.spanReporter).build();
        return brave;
    }

    private Tracing getTracing(String serviceName) {
        Tracing brave = null;
        if (serviceName != null && (brave = this.braves.get(serviceName)) == null && this.useFallbackServiceNames) {
            LOG.debug("Creating Tracing assigned to serviceName: {}", (Object)(serviceName + " as fallback"));
            brave = this.newTracing(serviceName);
            this.braves.put(serviceName, brave);
        }
        return brave;
    }

    private void clientRequest(Tracing brave, String serviceName, CamelEvent.ExchangeSendingEvent event) {
        String parentId;
        Span last;
        ExtendedExchange exchange = event.getExchange().adapt(ExtendedExchange.class);
        ZipkinState state = exchange.getSafeCopyProperty("CamelZipkinState", ZipkinState.class);
        if (state == null) {
            state = new ZipkinState();
            exchange.setSafeCopyProperty("CamelZipkinState", state);
        }
        Span span = (last = state.peekServerSpan()) != null ? brave.tracer().newChild(last.context()) : brave.tracer().nextSpan();
        Span.Kind spanKind = this.getProducerComponentSpanKind(event.getEndpoint());
        span.kind(spanKind).start();
        ZipkinClientRequestAdapter parser = new ZipkinClientRequestAdapter(this, event.getEndpoint());
        CamelRequest request = new CamelRequest(event.getExchange().getIn(), spanKind);
        INJECTOR.inject(span.context(), request);
        parser.onRequest(event.getExchange(), span.customizer());
        state.pushClientSpan(span);
        TraceContext context = span.context();
        String traceId = "" + context.traceIdString();
        String spanId = "" + context.spanId();
        String string = parentId = context.parentId() != null ? "" + context.parentId() : null;
        if (this.camelContext.isUseMDCLogging().booleanValue()) {
            MDC.put((String)"traceId", (String)traceId);
            MDC.put((String)"spanId", (String)spanId);
            MDC.put((String)"parentId", (String)parentId);
        }
        if (LOG.isDebugEnabled()) {
            if (parentId != null) {
                LOG.debug(String.format("clientRequest [service=%s, traceId=%20s, spanId=%20s, parentId=%20s]", serviceName, traceId, spanId, parentId));
            } else {
                LOG.debug(String.format("clientRequest [service=%s, traceId=%20s, spanId=%20s]", serviceName, traceId, spanId));
            }
        }
    }

    protected Span.Kind getProducerComponentSpanKind(Endpoint endpoint) {
        return this.producerComponentToSpanKind.getOrDefault(this.getComponentName(endpoint), Span.Kind.CLIENT);
    }

    protected void addProducerComponentSpanKind(String component, Span.Kind kind) {
        this.producerComponentToSpanKind.putIfAbsent(component, kind);
    }

    private void clientResponse(Tracing brave, String serviceName, CamelEvent.ExchangeSentEvent event) {
        Span span = null;
        ExtendedExchange exchange = event.getExchange().adapt(ExtendedExchange.class);
        ZipkinState state = exchange.getSafeCopyProperty("CamelZipkinState", ZipkinState.class);
        if (state != null) {
            span = state.popClientSpan();
        }
        if (span != null) {
            String parentId;
            ZipkinClientResponseAdaptor parser = new ZipkinClientResponseAdaptor(this, event.getEndpoint());
            parser.onResponse(event.getExchange(), span.customizer());
            span.finish();
            TraceContext context = span.context();
            String traceId = "" + context.traceIdString();
            String spanId = "" + context.spanId();
            String string = parentId = context.parentId() != null ? "" + context.parentId() : null;
            if (this.camelContext.isUseMDCLogging().booleanValue()) {
                MDC.put((String)"traceId", (String)traceId);
                MDC.put((String)"spanId", (String)spanId);
                MDC.put((String)"parentId", (String)parentId);
            }
            if (LOG.isDebugEnabled()) {
                if (parentId != null) {
                    LOG.debug(String.format("clientResponse[service=%s, traceId=%20s, spanId=%20s, parentId=%20s]", serviceName, traceId, spanId, parentId));
                } else {
                    LOG.debug(String.format("clientResponse[service=%s, traceId=%20s, spanId=%20s]", serviceName, traceId, spanId));
                }
            }
        }
    }

    private Span serverRequest(Tracing brave, String serviceName, Exchange exchange) {
        String parentId;
        ExtendedExchange extendedExchange = exchange.adapt(ExtendedExchange.class);
        ZipkinState state = extendedExchange.getSafeCopyProperty("CamelZipkinState", ZipkinState.class);
        if (state == null) {
            state = new ZipkinState();
            extendedExchange.setSafeCopyProperty("CamelZipkinState", state);
        }
        Span span = null;
        Span.Kind spanKind = this.getConsumerComponentSpanKind(exchange.getFromEndpoint());
        CamelRequest cr = new CamelRequest(exchange.getIn(), spanKind);
        TraceContextOrSamplingFlags sampleFlag = EXTRACTOR.extract(cr);
        span = ObjectHelper.isEmpty(sampleFlag) ? brave.tracer().nextSpan() : brave.tracer().nextSpan(sampleFlag);
        span.kind(spanKind).start();
        ZipkinServerRequestAdapter parser = new ZipkinServerRequestAdapter(this, exchange);
        parser.onRequest(exchange, span.customizer());
        INJECTOR.inject(span.context(), cr);
        state.pushServerSpan(span);
        TraceContext context = span.context();
        String traceId = "" + context.traceIdString();
        String spanId = "" + context.spanId();
        String string = parentId = context.parentId() != null ? "" + context.parentId() : null;
        if (this.camelContext.isUseMDCLogging().booleanValue()) {
            MDC.put((String)"traceId", (String)traceId);
            MDC.put((String)"spanId", (String)spanId);
            MDC.put((String)"parentId", (String)parentId);
        }
        if (LOG.isDebugEnabled()) {
            if (parentId != null) {
                LOG.debug(String.format("serverRequest [service=%s, traceId=%20s, spanId=%20s, parentId=%20s]", serviceName, traceId, spanId, parentId));
            } else {
                LOG.debug(String.format("serverRequest [service=%s, traceId=%20s, spanId=%20s]", serviceName, traceId, spanId));
            }
        }
        return span;
    }

    protected Span.Kind getConsumerComponentSpanKind(Endpoint endpoint) {
        return this.consumerComponentToSpanKind.getOrDefault(this.getComponentName(endpoint), Span.Kind.SERVER);
    }

    private void serverResponse(Tracing brave, String serviceName, Exchange exchange) {
        Span span = null;
        ExtendedExchange extendedExchange = exchange.adapt(ExtendedExchange.class);
        ZipkinState state = extendedExchange.getSafeCopyProperty("CamelZipkinState", ZipkinState.class);
        if (state != null) {
            span = state.popServerSpan();
        }
        if (span != null) {
            String parentId;
            ZipkinServerResponseAdapter parser = new ZipkinServerResponseAdapter(this, exchange);
            parser.onResponse(exchange, span.customizer());
            span.finish();
            TraceContext context = span.context();
            String traceId = "" + context.traceIdString();
            String spanId = "" + context.spanId();
            String string = parentId = context.parentId() != null ? "" + context.parentId() : null;
            if (this.camelContext.isUseMDCLogging().booleanValue()) {
                MDC.put((String)"traceId", (String)traceId);
                MDC.put((String)"spanId", (String)spanId);
                MDC.put((String)"parentId", (String)parentId);
            }
            if (LOG.isDebugEnabled()) {
                if (parentId != null) {
                    LOG.debug(String.format("serverResponse[service=%s, traceId=%20s, spanId=%20s, parentId=%20s]", serviceName, traceId, spanId, parentId));
                } else {
                    LOG.debug(String.format("serverResponse[service=%s, traceId=%20s, spanId=%20s]", serviceName, traceId, spanId));
                }
            }
        }
    }

    private String getComponentName(Endpoint endpoint) {
        String[] uriParts;
        String uri = endpoint.getEndpointBaseUri();
        if (uri != null && (uriParts = uri.split(":")) != null && uriParts.length > 0) {
            return uriParts[0].toLowerCase();
        }
        return null;
    }

    private static Expression routeIdExpression() {
        return new Expression(){

            @Override
            public <T> T evaluate(Exchange exchange, Class<T> type) {
                String answer = ExchangeHelper.getRouteId(exchange);
                return type.cast(answer);
            }
        };
    }

    private final class ZipkinRoutePolicy
    extends RoutePolicySupport {
        private ZipkinRoutePolicy() {
        }

        @Override
        public void onExchangeBegin(Route route, Exchange exchange) {
            String serviceName = ZipkinTracer.this.getServiceName(exchange, route.getEndpoint(), true, false);
            Tracing brave = ZipkinTracer.this.getTracing(serviceName);
            if (brave != null) {
                ZipkinTracer.this.serverRequest(brave, serviceName, exchange);
            }
        }

        @Override
        public void onExchangeDone(Route route, Exchange exchange) {
            String serviceName = ZipkinTracer.this.getServiceName(exchange, route.getEndpoint(), true, false);
            Tracing brave = ZipkinTracer.this.getTracing(serviceName);
            if (brave != null) {
                ZipkinTracer.this.serverResponse(brave, serviceName, exchange);
            }
        }
    }

    private final class ZipkinEventNotifier
    extends EventNotifierSupport {
        private ZipkinEventNotifier() {
        }

        @Override
        public void notify(CamelEvent event) throws Exception {
            CamelEvent.ExchangeSentEvent ese;
            String serviceName;
            Tracing brave;
            if (event instanceof CamelEvent.ExchangeSendingEvent) {
                CamelEvent.ExchangeSendingEvent ese2 = (CamelEvent.ExchangeSendingEvent)event;
                String serviceName2 = ZipkinTracer.this.getServiceName(ese2.getExchange(), ese2.getEndpoint(), false, true);
                Tracing brave2 = ZipkinTracer.this.getTracing(serviceName2);
                if (brave2 != null) {
                    ZipkinTracer.this.clientRequest(brave2, serviceName2, ese2);
                }
            } else if (event instanceof CamelEvent.ExchangeSentEvent && (brave = ZipkinTracer.this.getTracing(serviceName = ZipkinTracer.this.getServiceName((ese = (CamelEvent.ExchangeSentEvent)event).getExchange(), ese.getEndpoint(), false, true))) != null) {
                ZipkinTracer.this.clientResponse(brave, serviceName, ese);
            }
        }

        @Override
        public boolean isEnabled(CamelEvent event) {
            switch (event.getType()) {
                case ExchangeSending: 
                case ExchangeSent: 
                case ExchangeCreated: 
                case ExchangeCompleted: 
                case ExchangeFailed: {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "ZipkinEventNotifier";
        }
    }
}

